/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.backup;

import com.tridium.batchJob.BBatchJobStepLogFile;
import com.tridium.nd.BNiagaraStation;
import com.tridium.provisioningNiagara.ProvisioningNiagaraManagerImpl;
import com.tridium.provisioningNiagara.backup.BBackupStepDetails;
import java.util.ArrayList;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.BIJobStepSummary;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.driver.BDevice;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.provisioningNiagara.backup.BProvisioningBackupStep;
import javax.baja.provisioningNiagara.backup.ProvisioningBackupManager;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.IterableCursor;

public class ProvisioningBackupManagerImpl
implements ProvisioningBackupManager {
    private ProvisioningNiagaraManagerImpl parent;

    public ProvisioningBackupManagerImpl(ProvisioningNiagaraManagerImpl parent) {
        this.parent = parent;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BDeviceStepDetails[] listBackupStepDetails(BDevice station) throws Exception {
        BBatchJobService svc = (BBatchJobService)BOrd.make((String)"service:batchJob:BatchJobService").get((BObject)station);
        svc.lease(3);
        ArrayList<BBackupStepDetails> result = new ArrayList<BBackupStepDetails>();
        try (IterableCursor c = svc.getJobQueryManager().listStepSummaries(BProvisioningBackupStep.TYPE, "deviceId", (BSimple)BString.make((String)((BNiagaraStation)station).getStationName()), (BObject)station);){
            while (c.next()) {
                try {
                    BBackupStepDetails details = (BBackupStepDetails)BBatchJobStepLogFile.find((BIJobStepSummary)((BIJobStepSummary)c.get()), (BObject)station).getDetails();
                    if (details.getState() != BJobState.success) continue;
                    result.add(details);
                }
                catch (UnresolvedException unresolvedException) {}
            }
            return result.toArray(new BDeviceStepDetails[0]);
        }
    }

    @Override
    public BOrd getBackupFileOrd(BDeviceStepDetails backupStepDetails) throws Exception {
        return ((BBackupStepDetails)backupStepDetails).getBackupFileOrd();
    }

    @Override
    public BOrd startRestoreJob(BDeviceStepDetails backupStepDetails) throws Exception {
        return ((BBackupStepDetails)backupStepDetails).startRestoreJob((BObject)this.parent.getDeviceNetwork(), null, null);
    }
}

