/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.backup;

import com.tridium.batchJob.BBatchJobStepLogFile;
import com.tridium.provisioningNiagara.BProvisioningStationExt;
import com.tridium.provisioningNiagara.backup.BBackupStepDetails;
import com.tridium.provisioningNiagara.software.BInstallStep;
import com.tridium.util.TimeFormat;
import java.util.ArrayList;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.BIJobStepSummary;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.provisioningNiagara.BNiagaraNetworkJob;
import javax.baja.provisioningNiagara.backup.BProvisioningBackupStep;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IterableCursor;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"niagaraDriver:NiagaraStation"})})
@NiagaraProperty(name="lastBackupTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1)
@NiagaraTopic(name="backupCreated", eventType="BOrd")
public class BBackupStationExt
extends BProvisioningStationExt {
    @Generated
    public static final Property lastBackupTime = BBackupStationExt.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Topic backupCreated = BBackupStationExt.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBackupStationExt.class);
    private static final BIcon icon = BIcon.std((String)"backup.png");

    @Generated
    public BAbsTime getLastBackupTime() {
        return (BAbsTime)this.get(lastBackupTime);
    }

    @Generated
    public void setLastBackupTime(BAbsTime v) {
        this.set(lastBackupTime, (BValue)v, null);
    }

    @Generated
    public void fireBackupCreated(BOrd event) {
        this.fire(backupCreated, (BValue)event, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBatchJob startRestore(BIFile backupFile, Context cx) throws Exception {
        BNiagaraNetworkJob localJob = new BNiagaraNetworkJob(this.getNiagaraStation().getStationName());
        localJob.addStep(new BInstallStep(backupFile, false));
        BBatchJobService svc = (BBatchJobService)BOrd.make((String)"service:batchJob:BatchJobService").get((BObject)this);
        return svc.submitJob((BBatchJob)localJob, cx);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BIFile[] listBackupFiles() throws Exception {
        BBatchJobService svc = (BBatchJobService)BOrd.make((String)"service:batchJob:BatchJobService").get((BObject)this);
        svc.lease(3);
        ArrayList<BIFile> result = new ArrayList<BIFile>();
        try (IterableCursor c = svc.getJobQueryManager().listStepSummaries(BProvisioningBackupStep.TYPE, "deviceId", (BSimple)BString.make((String)this.getNiagaraStation().getStationName()), (BObject)this);){
            while (c.next()) {
                try {
                    BBackupStepDetails details = (BBackupStepDetails)BBatchJobStepLogFile.find((BIJobStepSummary)((BIJobStepSummary)c.get()), (BObject)this).getDetails();
                    if (details.getState() != BJobState.success) continue;
                    try {
                        result.add((BIFile)details.getBackupFileOrd().get((BObject)this));
                    }
                    catch (UnresolvedException unresolvedException) {}
                }
                catch (UnresolvedException unresolvedException) {}
            }
            return result.toArray(new BIFile[0]);
        }
    }

    public String getDisplayNameInParent(Context cx) {
        return Lexicon.make((BModule)TYPE.getModule(), (Context)cx).getText("BackupStationExt");
    }

    public BOrd newBackupFileOrd() throws Exception {
        String stationName = this.getNiagaraStation().getStationName();
        FilePath dir = new FilePath("^^provisioningNiagara/stationData").merge(stationName).merge("backups");
        return BOrd.make((OrdQuery)dir.merge("backup_" + stationName + "_" + TimeFormat.format((BAbsTime)BAbsTime.now(), (String)"YYMMDD_HHmm") + ".dist"));
    }

    public BIcon getIcon() {
        return icon;
    }
}

