/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara;

import com.tridium.fox.session.FoxAuthenticationException;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.nd.BNiagaraStation;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.RemotePlatformStation;
import com.tridium.platform.daemon.message.AuthenticationInfoMessage;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.provisioningNiagara.BPlatformConnection;
import com.tridium.provisioningNiagara.BProvisioningNiagaraNetworkExt;
import com.tridium.util.RetryUtil;
import com.tridium.util.TimeFormat;
import java.io.InputStream;
import java.net.ConnectException;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.job.BJobState;
import javax.baja.naming.NullOrdException;
import javax.baja.nre.security.SharedSecretKey;
import javax.baja.platform.PlatformDaemon;
import javax.baja.platform.RemoteStation;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.net.ssl.SSLException;
import org.bouncycastle.tls.TlsException;

public class ProvisioningConnectionUtil
implements AutoCloseable {
    private static final BFacets TIMESTAMP_FORMAT = BFacets.make((String[])new String[]{"timeFormat", "showDate", "showTime", "showSeconds", "showMilliseconds"}, (BIDataValue[])new BIDataValue[]{BString.make((String)"YYYYMMDD_HHmmss"), BBoolean.TRUE, BBoolean.TRUE, BBoolean.TRUE, BBoolean.TRUE});
    private final BNiagaraStation niagaraStation;
    private final BDeviceStepDetails deviceStepDetails;
    private final String interestName;
    private final BFoxClientConnection.Interest stringInterest;
    private Exception lastException;
    private static final Lexicon lex = Lexicon.make((String)"provisioningNiagara");
    private static final Logger logger = Logger.getLogger(ProvisioningConnectionUtil.class.getPackage().getName());
    public static final Function<Integer, Integer> FOX_SESSION_RETRY_DECAY = callCount -> (int)(5000.0 * Math.pow(2.0, (double)callCount.intValue() - 1.0));

    public ProvisioningConnectionUtil(BDevice device, BDeviceStepDetails details) throws Exception {
        this(device, details, null);
    }

    public ProvisioningConnectionUtil(BDevice device, BDeviceStepDetails details, String interestName) throws Exception {
        if (!(device instanceof BNiagaraStation)) {
            throw new ProvisioningConnectionException(lex.getText("Provisioning.error.notNiagaraStation"));
        }
        this.niagaraStation = (BNiagaraStation)device;
        this.deviceStepDetails = details;
        this.interestName = interestName != null ? interestName : (this.deviceStepDetails == null ? "ProvisioningConnectionUtil-" + this.hashCode() + TimeFormat.format((BAbsTime)BAbsTime.now(), (Context)TIMESTAMP_FORMAT) : this.deviceStepDetails.getStep().getName() + TimeFormat.format((BAbsTime)this.deviceStepDetails.getStartTime(), (Context)TIMESTAMP_FORMAT));
        this.stringInterest = new BFoxClientConnection.StringInterest(this.interestName);
    }

    public BPlatformConnection getPlatformConnection() throws Exception {
        return this.getPlatformConnection(Behavior.THROW_ON_ERROR);
    }

    public BPlatformConnection getPlatformConnection(Behavior option) throws Exception {
        try {
            BPlatformConnection platformConnection = (BPlatformConnection)this.niagaraStation.getMixIn(BPlatformConnection.TYPE);
            if (platformConnection == null) {
                throw new ProvisioningConnectionException(lex.getText("Provisioning.error.platformConnectionMissing"));
            }
            if (platformConnection.isFatalFault() || platformConnection.isDisabled()) {
                throw new ProvisioningConnectionException(lex.getText("Provisioning.error.platformConnectionUnoperational"));
            }
            if (!platformConnection.isRunning()) {
                throw new ProvisioningConnectionException(lex.getText("Provisioning.error.platformConnectionNotRunning"));
            }
            return platformConnection;
        }
        catch (Exception e) {
            this.handleException(e, "Provisioning.error.platformConnection", option);
            return null;
        }
    }

    public BDaemonSession getDaemonSession() throws Exception {
        return this.getDaemonSession(Behavior.THROW_ON_ERROR);
    }

    private BDaemonSession getDaemonSession(Behavior option) throws Exception {
        try {
            BDaemonSession daemonSession;
            BPlatformConnection platformConnection = (BPlatformConnection)this.niagaraStation.getMixIn(BPlatformConnection.TYPE);
            if (platformConnection == null) {
                this.handleException("Provisioning.error.platformConnectionMissing", option);
            }
            if ((daemonSession = platformConnection.getDaemonSession()) == null) {
                this.handleException("Provisioning.error.daemonSession", option);
            }
            return daemonSession;
        }
        catch (AuthenticationException ae) {
            this.handleException((Exception)((Object)ae), "Provisioning.error.daemonSessionAuthentication", option);
        }
        catch (Exception e) {
            this.handleException(e, "Provisioning.error.daemonSession", option);
        }
        return null;
    }

    public BFoxSession getEngagedFoxSession() throws Exception {
        return this.getEngagedFoxSession(Behavior.THROW_ON_ERROR);
    }

    public BFoxSession getEngagedFoxSession(Behavior option) throws Exception {
        try {
            BProvisioningNiagaraNetworkExt ext = (BProvisioningNiagaraNetworkExt)Sys.getService((Type)BProvisioningNiagaraNetworkExt.TYPE);
            int connectTimeoutMS = ext.getConnectTimeout();
            return (BFoxSession)RetryUtil.make(() -> {
                BFoxSession foxSession = (BFoxSession)BProvisioningNiagaraNetworkExt.getFoxProxySession(this.niagaraStation);
                foxSession.engageNoRetry(this.interestName);
                return foxSession;
            }, exception -> {
                if (exception instanceof FoxAuthenticationException || exception instanceof AuthenticationException) {
                    throw exception;
                }
                if (exception instanceof SSLException || exception instanceof TlsException) {
                    throw exception;
                }
                if (exception instanceof SecurityException) {
                    throw exception;
                }
                if (exception instanceof NullOrdException) {
                    throw exception;
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("ProvisioningConnectionUtil getEngagedFoxSession for '" + this.niagaraStation.getRemoteHost() + "' retrying on Exception '" + exception + "'...");
                }
                return exception;
            }, FOX_SESSION_RETRY_DECAY, (int)connectTimeoutMS).call();
        }
        catch (Exception e) {
            this.handleException(e, "Provisioning.error.foxSession", option);
            return null;
        }
    }

    public void disengageFoxSession() {
        try {
            BFoxSession foxSession = (BFoxSession)BProvisioningNiagaraNetworkExt.getFoxProxySession(this.niagaraStation);
            if (foxSession.isEngaged(this.interestName)) {
                foxSession.disengage(this.interestName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean sendDaemonMessage(DaemonMessage message) throws Exception {
        return this.sendDaemonMessage(message, Behavior.THROW_ON_ERROR);
    }

    private boolean sendDaemonMessage(DaemonMessage message, Behavior option) throws Exception {
        boolean result = false;
        try {
            result = this.getDaemonSession().sendMessage(message);
            if (!result) {
                throw new ProvisioningConnectionException(lex.getText("Provisioning.error.daemonMessageUnsuccessful"));
            }
        }
        catch (Exception e) {
            this.handleException(e, "Provisioning.error.daemonMessage", option);
        }
        return result;
    }

    public XElem getDaemonResponse(DaemonMessage message) throws Exception {
        return this.getDaemonResponse(message, Behavior.THROW_ON_ERROR);
    }

    private XElem getDaemonResponse(DaemonMessage message, Behavior option) throws Exception {
        try {
            if (message instanceof AuthenticationInfoMessage) {
                return XParser.make((InputStream)this.getDaemonSession().getInputStream(message, AuthenticationInfoMessage.AUTH_INFO_MESSAGE_TIMEOUT, "text/xml")).parse();
            }
            return XParser.make((InputStream)this.getDaemonSession().getInputStream(message, "text/xml")).parse();
        }
        catch (ConnectException | AuthenticationException e) {
            this.handleException((Exception)e, "Provisioning.error.daemonMessageSendReceive", option);
        }
        catch (Exception e) {
            this.handleException(e, "Provisioning.error.daemonMessageParse", option);
        }
        return null;
    }

    public SharedSecretKey generateDaemonSessionSharedSecretKey(String name) throws Exception {
        return this.generateDaemonSessionSharedSecretKey(name, Behavior.THROW_ON_ERROR);
    }

    private SharedSecretKey generateDaemonSessionSharedSecretKey(String name, Behavior option) throws Exception {
        try {
            return this.getDaemonSession().generateSharedSecretKey(name);
        }
        catch (Exception e) {
            this.handleException(e, "Provisioning.error.sharedSecret", option);
            return null;
        }
    }

    public Boolean hasRunningStation() throws Exception {
        return this.hasRunningStation(Behavior.THROW_ON_ERROR);
    }

    private Boolean hasRunningStation(Behavior option) throws Exception {
        try {
            return BStationSurrogate.isAnyStationRunning((BDaemonSession)this.getDaemonSession());
        }
        catch (Exception e) {
            this.handleException(e, "Provisioning.error.runningStation", option);
            return null;
        }
    }

    public RemoteStation getRemoteStation(String name) throws Exception {
        return this.getRemoteStation(name, Behavior.THROW_ON_ERROR);
    }

    private RemoteStation getRemoteStation(String name, Behavior option) throws Exception {
        try {
            return this.getPlatformDaemon().getStationManager().getStation(name);
        }
        catch (Exception e) {
            this.handleException(e, "Provisioning.error.remoteStation", option);
            return null;
        }
    }

    public RemoteStation[] getRemoteStationList() throws Exception {
        return this.getRemoteStationList(Behavior.THROW_ON_ERROR);
    }

    private RemoteStation[] getRemoteStationList(Behavior option) throws Exception {
        try {
            return RemotePlatformStation.getAllStations((BDaemonSession)this.getDaemonSession());
        }
        catch (Exception e) {
            this.handleException(e, "Provisioning.error.remoteStationList", option);
            return null;
        }
    }

    public PlatformDaemon getPlatformDaemon() throws Exception {
        return this.getPlatformDaemon(Behavior.THROW_ON_ERROR);
    }

    private PlatformDaemon getPlatformDaemon(Behavior option) throws Exception {
        try {
            return this.getPlatformConnection().getPlatformDaemon();
        }
        catch (Exception e) {
            this.handleException(e, "Provisioning.error.platformDaemon", option);
            return null;
        }
    }

    public BRemoteDaemonPlatform getRemoteDaemonPlatform() throws Exception {
        return this.getRemoteDaemonPlatform(Behavior.THROW_ON_ERROR);
    }

    private BRemoteDaemonPlatform getRemoteDaemonPlatform(Behavior option) throws Exception {
        try {
            BRemoteDaemonPlatform remoteDaemonPlatform = BRemoteDaemonPlatform.make((BDaemonSession)this.getDaemonSession(), (DaemonSessionTaskListener)DaemonSessionTaskListener.NULL_TASK_LISTENER);
            if (remoteDaemonPlatform == null) {
                throw new ProvisioningConnectionException(lex.getText("Provisioning.error.remoteDaemonPlatform"));
            }
            return remoteDaemonPlatform;
        }
        catch (Exception e) {
            this.handleException(e, "Provisioning.error.remoteDaemonPlatform", option);
            return null;
        }
    }

    private Exception makeReadableException(Exception exception, String lexKey) {
        String message = lex.getText(lexKey);
        if (exception instanceof ProvisioningConnectionException || message == null) {
            return exception;
        }
        return new ProvisioningConnectionException(message, exception);
    }

    public Exception getLastException() {
        return this.lastException;
    }

    public void reset() {
        this.disengageFoxSession();
    }

    @Override
    public void close() {
        this.reset();
    }

    private void handleException(String lexKey, Behavior option) throws Exception {
        this.handleException(null, lexKey, option);
    }

    private void handleException(Exception e, String lexKey, Behavior option) throws Exception {
        this.lastException = this.makeReadableException(e, lexKey);
        logger.info(this.lastException.getMessage());
        if (option == Behavior.THROW_ON_ERROR) {
            this.reset();
            throw this.lastException;
        }
        if (option == Behavior.LOG_ON_ERROR && this.deviceStepDetails != null) {
            this.deviceStepDetails.message(this.lastException.getMessage());
        } else if (this.deviceStepDetails != null) {
            this.deviceStepDetails.failed("provisioningNiagara", lexKey, (Throwable)this.lastException);
            this.deviceStepDetails.complete(BJobState.failed);
        }
    }

    public static enum Behavior {
        LOG_ON_ERROR,
        FAIL_ON_ERROR,
        THROW_ON_ERROR;

    }

    public static class ProvisioningConnectionException
    extends Exception {
        ProvisioningConnectionException(String message) {
            super(message);
        }

        ProvisioningConnectionException(String message, Exception exception) {
            super(message, exception);
        }
    }
}

