/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara;

import com.tridium.install.installable.BInstallable;
import com.tridium.nd.BNiagaraStation;
import java.util.ArrayList;
import java.util.List;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.sys.Context;

public class NiagaraNetworkJobOp
extends DeviceNetworkJobOp {
    public static final InstallListener NULL_LISTENER = (details, installable, op) -> {};

    public NiagaraNetworkJobOp(Context base) {
        super(base);
    }

    public void install(BNiagaraStation station, BInstallable installable) {
        this.install(station, installable, NULL_LISTENER);
    }

    public void install(BNiagaraStation station, BInstallable installable, InstallListener listener) {
        ArrayList<InstallRequest> stationInstallRequests = (ArrayList<InstallRequest>)this.getDeviceAttribute((BDevice)station, "installRequests");
        if (stationInstallRequests == null) {
            stationInstallRequests = new ArrayList<InstallRequest>();
            this.setDeviceAttribute((BDevice)station, "installRequests", stationInstallRequests);
        }
        stationInstallRequests.add(new InstallRequest(installable, listener));
    }

    public boolean hasStationInstallables(BNiagaraStation station) {
        return this.getDeviceAttribute((BDevice)station, "installRequests") != null;
    }

    public BInstallable[] getStationInstallables(BNiagaraStation station) {
        List installRequests = (List)this.getDeviceAttribute((BDevice)station, "installRequests");
        if (installRequests == null) {
            return new BInstallable[0];
        }
        BInstallable[] result = new BInstallable[installRequests.size()];
        for (int i = 0; i < installRequests.size(); ++i) {
            result[i] = ((InstallRequest)installRequests.get((int)i)).installable;
        }
        return result;
    }

    public void stationInstallComplete(BDeviceStepDetails details) {
        List installRequests = (List)this.getDeviceAttribute(details.getDevice(), "installRequests");
        if (installRequests != null) {
            for (InstallRequest installRequest : installRequests) {
                installRequest.installComplete(details);
            }
            this.removeDeviceAttribute(details.getDevice(), "installRequests");
        }
    }

    public static interface InstallListener {
        public void installComplete(BDeviceStepDetails var1, BInstallable var2, NiagaraNetworkJobOp var3);
    }

    protected class InstallRequest {
        public BInstallable installable;
        public InstallListener listener;

        public InstallRequest(BInstallable installable, InstallListener listener) {
            this.installable = installable;
            this.listener = listener;
        }

        public void installComplete(BDeviceStepDetails details) {
            this.listener.installComplete(details, this.installable, NiagaraNetworkJobOp.this);
        }
    }
}

