/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara;

import com.tridium.file.types.text.BLicenseFile;
import com.tridium.fox.encoding.BogCodec;
import com.tridium.fox.encoding.DecoderFactory;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxObject;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.install.BDependency;
import com.tridium.install.BVersion;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BInstallableSpec;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.nd.BNiagaraStation;
import com.tridium.platform.BFilesystemAttributes;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.ConsoleInputStream;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.fox.ChunkedInputStream;
import com.tridium.platform.fox.ChunkedOutputStream;
import com.tridium.platform.fox.MessageClient;
import com.tridium.platform.fox.TaskDispatcher;
import com.tridium.platform.fox.TaskListenerClient;
import com.tridium.platform.license.BCertificateSummary;
import com.tridium.platform.license.BEnvLicenseSummary;
import com.tridium.platform.license.BLicenseArchiveFile;
import com.tridium.platform.license.PortalLicenseUtil;
import com.tridium.provisioningNiagara.BPlatformConnection;
import com.tridium.provisioningNiagara.backup.BBackupStepDetailsRpc;
import com.tridium.provisioningNiagara.station.BStationProxy;
import com.tridium.sys.license.dom.CertificateDatabase;
import com.tridium.sys.license.dom.LicenseDatabase;
import com.tridium.sys.license.dom.VendorCertificate;
import com.tridium.sys.license.dom.VendorLicense;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.FileUtil;
import javax.baja.platform.ICancelHint;
import javax.baja.security.BPassword;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.IterableCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
public class BNiagaraProvisioningChannel
extends BFoxChannel {
    @Generated
    public static final Type TYPE = Sys.loadType(BNiagaraProvisioningChannel.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BNiagaraProvisioningChannel() {
        super("niagaraProv");
    }

    public FoxResponse process(FoxRequest request) throws Exception {
        String command = request.command;
        if (command.equals("getFilesystemAttributes")) {
            return this.getFilesystemAttributes(request);
        }
        if (command.equals("validatePassphraseToDist")) {
            return this.validatePassphraseToDist(request);
        }
        if (command.equals("validateDistPassphraseToPlatform")) {
            return this.validateDistPassphraseToPlatform(request);
        }
        throw new InvalidCommandException(command);
    }

    public void circuitOpened(FoxCircuit circuit) throws Exception {
        String command;
        switch (command = circuit.command) {
            case "findInstallable": {
                this.findInstallable(circuit);
                return;
            }
            case "getInstallableByPath": {
                this.getInstallableByPath(circuit);
                return;
            }
            case "findInstallables": {
                this.findInstallables(circuit);
                return;
            }
            case "getInstallables": {
                this.getInstallables(circuit);
                return;
            }
            case "registerInstallable": {
                this.registerInstallable(circuit);
                return;
            }
            case "registerStationInstallable": {
                this.registerStationInstallable(circuit);
                return;
            }
            case "getStationOutput": {
                this.getStationOutput(circuit);
                return;
            }
            case "startStation": {
                this.startStation(circuit);
                return;
            }
            case "stopStation": {
                this.stopStation(circuit);
                return;
            }
            case "killStation": {
                this.killStation(circuit);
                return;
            }
            case "saveStation": {
                this.saveStation(circuit);
                return;
            }
            case "getUpdatedLicenses": {
                this.getUpdatedLicenses(circuit);
                return;
            }
            case "getLicenseSummaries": {
                this.getLicenseSummaries(circuit);
                return;
            }
            case "importLicenseFile": {
                this.importLicenseFile(circuit);
                return;
            }
            case "importLicenseArchiveFile": {
                this.importLicenseArchiveFile(circuit);
                return;
            }
            case "getLicensedHostIds": {
                this.getLicensedHostIds(circuit);
                return;
            }
            case "getLicenses": {
                this.getLicenses(circuit);
                return;
            }
            case "exportLicenses": {
                this.exportLicenses(circuit);
                return;
            }
            case "removeLicense": {
                this.removeLicense(circuit);
                return;
            }
            case "addLicense": {
                this.addLicense(circuit);
                return;
            }
            case "licenseIterator": {
                this.licenseIterator(circuit);
                return;
            }
            case "getCertificateSummaries": {
                this.getCertificateSummaries(circuit);
                return;
            }
            case "addCertificate": {
                this.addCertificate(circuit);
                return;
            }
        }
        throw new InvalidCommandException(command);
    }

    public BFilesystemAttributes getFilesystemAttributes(String stationName, FilePath path) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:getFilesystemAttributes");
        }
        FoxRequest request = this.makeRequest("getFilesystemAttributes");
        request.add("stationName", stationName);
        request.add("path", path.getBody());
        FoxResponse response = this.sendSync(request);
        FoxObject attrsEncoded = (FoxObject)response.getOptional("attributes");
        if (attrsEncoded == null) {
            return null;
        }
        return (BFilesystemAttributes)DecoderFactory.decode((FoxObject)attrsEncoded, null);
    }

    public FoxResponse getFilesystemAttributes(FoxRequest request) throws Exception {
        FoxResponse response = new FoxResponse(request);
        FilePath path = new FilePath(request.getString("path"));
        BNiagaraStation s = BNiagaraProvisioningChannel.getStation((FoxMessage)request);
        if (s != null) {
            BPlatformConnection conn = (BPlatformConnection)s.getMixIn(BPlatformConnection.TYPE);
            BogCodec.add((FoxMessage)response, (String)"attributes", (BValue)DaemonFileUtil.getFilesystemAttributes((BDaemonSession)conn.getDaemonSession(), (FilePath)path), null);
        }
        return response;
    }

    public void startStation(String stationName, ICancelHint cancelHint, DaemonSessionTaskListener listener) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:startStation");
        }
        this.stationControl("startStation", stationName, cancelHint, listener);
    }

    public void startStation(FoxCircuit circuit) throws Exception {
        BStationSurrogate s;
        FoxMessage request = circuit.readMessage();
        if (this.isTraceOn()) {
            this.trace("s:startStation");
        }
        if ((s = this.getStationSurrogate(request)) != null) {
            s.startStation(null, (DaemonSessionTaskListener)new TaskDispatcher(circuit));
        }
        FoxMessage response = new FoxMessage();
        response.add("type", "end");
        circuit.writeMessage(response);
        circuit.flush();
    }

    public void saveStation(String stationName, ICancelHint cancelHint, DaemonSessionTaskListener listener) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:saveStation");
        }
        this.stationControl("saveStation", stationName, cancelHint, listener);
    }

    public void saveStation(FoxCircuit circuit) throws Exception {
        BStationSurrogate s;
        FoxMessage request = circuit.readMessage();
        if (this.isTraceOn()) {
            this.trace("s:saveStation");
        }
        if ((s = this.getStationSurrogate(request)) != null) {
            s.saveStation(null, (DaemonSessionTaskListener)new TaskDispatcher(circuit));
        }
        FoxMessage response = new FoxMessage();
        response.add("type", "end");
        circuit.writeMessage(response);
        circuit.flush();
    }

    public void stopStation(String stationName, ICancelHint cancelHint, DaemonSessionTaskListener listener) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:stopStation");
        }
        this.stationControl("stopStation", stationName, cancelHint, listener);
    }

    public void stopStation(FoxCircuit circuit) throws Exception {
        BStationSurrogate s;
        FoxMessage request = circuit.readMessage();
        if (this.isTraceOn()) {
            this.trace("s:stopStation");
        }
        if ((s = this.getStationSurrogate(request)) != null) {
            s.stopStation(BStationProxy.stationShutdownCancelHint(null, null), (DaemonSessionTaskListener)new TaskDispatcher(circuit));
        }
        FoxMessage response = new FoxMessage();
        response.add("type", "end");
        circuit.writeMessage(response);
        circuit.flush();
    }

    public void killStation(String stationName, ICancelHint cancelHint, DaemonSessionTaskListener listener) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:killStation");
        }
        this.stationControl("killStation", stationName, cancelHint, listener);
    }

    public void killStation(FoxCircuit circuit) throws Exception {
        BStationSurrogate s;
        FoxMessage request = circuit.readMessage();
        if (this.isTraceOn()) {
            this.trace("s:killStation");
        }
        if ((s = this.getStationSurrogate(request)) != null) {
            s.killStation(null, (DaemonSessionTaskListener)new TaskDispatcher(circuit));
        }
        FoxMessage response = new FoxMessage();
        response.add("type", "end");
        circuit.writeMessage(response);
        circuit.flush();
    }

    public InputStream getStationOutput(String stationName, boolean follow, boolean updatesOnly) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:getStationOutput");
        }
        FoxCircuit circuit = this.openCircuit("getStationOutput");
        FoxMessage request = new FoxMessage();
        request.add("stationName", stationName);
        request.add("follow", follow);
        request.add("updatesOnly", updatesOnly);
        circuit.writeMessage(request);
        circuit.flush();
        return ConsoleInputStream.make((InputStream)circuit.getInputStream());
    }

    /*
     * Exception decompiling
     */
    public void getStationOutput(FoxCircuit circuit) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 24[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void stationControl(String command, String stationName, ICancelHint cancelHint, DaemonSessionTaskListener listener) throws Exception {
        FoxCircuit circuit = this.openCircuit(command);
        FoxMessage request = new FoxMessage();
        request.add("stationName", stationName);
        TaskListenerClient listenerClient = new TaskListenerClient(listener);
        circuit.writeMessage(request);
        circuit.flush();
        try {
            while (true) {
                if (cancelHint != null && cancelHint.isCanceled()) {
                    throw new ICancelHint.CanceledException();
                }
                FoxMessage message = circuit.readMessage();
                if (listenerClient.handleMessage(message) || !message.getString("type").equals("end")) continue;
                return;
            }
        }
        finally {
            listenerClient.close();
        }
    }

    private static BNiagaraStation getStation(FoxMessage request) throws Exception {
        String stationName = request.getString("stationName");
        return BBackupStepDetailsRpc.getStation(stationName);
    }

    private BStationSurrogate getStationSurrogate(FoxMessage request) throws Exception {
        BNiagaraStation s = BNiagaraProvisioningChannel.getStation(request);
        if (s == null) {
            return null;
        }
        BPlatformConnection conn = (BPlatformConnection)s.getMixIn(BPlatformConnection.TYPE);
        return BStationSurrogate.make((BDaemonSession)conn.getDaemonSession(), (String)s.getStationName());
    }

    public VendorLicense[] getUpdatedLicenses(BEnvLicenseSummary[] summaries) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:getUpdatedLicenses");
        }
        FoxCircuit circuit = this.openCircuit("getUpdatedLicenses");
        for (BEnvLicenseSummary summary : summaries) {
            this.writeLicenseSummaryMessage(circuit, summary);
        }
        this.writeEndOfDataMessage(circuit);
        circuit.flush();
        ArrayList<VendorLicense> result = new ArrayList<VendorLicense>();
        VendorLicense license = this.readLicense(circuit);
        while (license != null) {
            result.add(license);
            license = this.readLicense(circuit);
        }
        return result.toArray(new VendorLicense[0]);
    }

    public void getUpdatedLicenses(FoxCircuit circuit) throws Exception {
        if (this.isTraceOn()) {
            this.trace("s:getUpdatedLicenses");
        }
        AccessController.doPrivileged(() -> {
            BEnvLicenseSummary summary = this.readLicenseSummary(circuit);
            while (summary != null) {
                VendorLicense[] licenses;
                for (VendorLicense license : licenses = PortalLicenseUtil.getUpdatedLicenses((BEnvLicenseSummary[])new BEnvLicenseSummary[]{summary}, (LicenseDatabase)LicenseDatabase.LOCAL_INSTANCE)) {
                    this.writeLicenseMessage(circuit, license);
                }
                summary = this.readLicenseSummary(circuit);
            }
            return null;
        });
        this.writeEndOfDataMessage(circuit);
        circuit.flush();
    }

    public BEnvLicenseSummary[] getLicenseSummaries(String[] hostIds) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:getLicenseSummaries");
        }
        FoxCircuit circuit = this.openCircuit("getLicenseSummaries");
        FoxMessage request = new FoxMessage();
        for (String hostId : hostIds) {
            request.add("hostId", hostId);
        }
        circuit.writeMessage(request);
        circuit.flush();
        ArrayList<BEnvLicenseSummary> result = new ArrayList<BEnvLicenseSummary>();
        BEnvLicenseSummary summary = this.readLicenseSummary(circuit);
        while (summary != null) {
            result.add(summary);
            summary = this.readLicenseSummary(circuit);
        }
        return result.toArray(new BEnvLicenseSummary[0]);
    }

    public void getLicenseSummaries(FoxCircuit circuit) throws Exception {
        if (this.isTraceOn()) {
            this.trace("s:getLicenseSummaries");
        }
        FoxMessage request = circuit.readMessage();
        AccessController.doPrivileged(() -> {
            for (String hostId : request.listStrings("hostId")) {
                VendorLicense[] licenses = LicenseDatabase.LOCAL_INSTANCE.getLicenses(hostId);
                for (BEnvLicenseSummary summary : BEnvLicenseSummary.make((VendorLicense[])licenses)) {
                    this.writeLicenseSummaryMessage(circuit, summary);
                }
            }
            return null;
        });
        this.writeEndOfDataMessage(circuit);
        circuit.flush();
    }

    public BCertificateSummary[] getCertificateSummaries() throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:getCertificateSummaries");
        }
        FoxCircuit circuit = this.openCircuit("getCertificateSummaries");
        ArrayList<BCertificateSummary> result = new ArrayList<BCertificateSummary>();
        BCertificateSummary summary = this.readCertSummary(circuit);
        while (summary != null) {
            result.add(summary);
            summary = this.readCertSummary(circuit);
        }
        return result.toArray(new BCertificateSummary[0]);
    }

    public void getCertificateSummaries(FoxCircuit circuit) throws Exception {
        BCertificateSummary[] summaries;
        if (this.isTraceOn()) {
            this.trace("s:getCertificateSummaries");
        }
        for (BCertificateSummary summary : summaries = AccessController.doPrivileged(() -> BCertificateSummary.make((VendorCertificate[])CertificateDatabase.LOCAL_INSTANCE.getCertificates()))) {
            this.writeCertSummaryMessage(circuit, summary);
        }
        this.writeEndOfDataMessage(circuit);
        circuit.flush();
    }

    public void importLicenseFile(BIFile file) throws Exception {
        FoxCircuit circuit;
        if (this.isTraceOn()) {
            this.trace("c:importLicenseFile");
        }
        if (file instanceof BLicenseFile) {
            circuit = this.openCircuit("importLicenseFile");
        } else if (file instanceof BLicenseArchiveFile) {
            circuit = this.openCircuit("importLicenseArchiveFile");
        } else {
            throw new IllegalArgumentException(file.getFilePath().getBody() + " is not a valid license file");
        }
        try (InputStream in = file.getInputStream();
             ChunkedOutputStream out = new ChunkedOutputStream(circuit);){
            FileUtil.pipe((InputStream)in, (long)file.getSize(), (OutputStream)out);
        }
    }

    public void importLicenseFile(FoxCircuit circuit) throws Exception {
        if (this.isTraceOn()) {
            this.trace("s:importLicenseFile");
        }
        AccessController.doPrivileged(() -> {
            LicenseDatabase.LOCAL_INSTANCE.add(VendorLicense.make((String)"provClient", (InputStream)new ChunkedInputStream(circuit), (boolean)true));
            return null;
        });
    }

    public void importLicenseArchiveFile(FoxCircuit circuit) throws Exception {
        if (this.isTraceOn()) {
            this.trace("s:importLicenseArchiveFile");
        }
        AccessController.doPrivileged(() -> {
            LicenseDatabase.LOCAL_INSTANCE.importLicenses((InputStream)new ChunkedInputStream(circuit));
            return null;
        });
    }

    public String[] getLicensedHostIds() throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:getLicensedHostIds");
        }
        FoxCircuit circuit = this.openCircuit("getLicensedHostIds");
        FoxMessage response = circuit.readMessage();
        return response.listStrings("hostId");
    }

    public void getLicensedHostIds(FoxCircuit circuit) throws Exception {
        if (this.isTraceOn()) {
            this.trace("s:getLicensedHostIds");
        }
        String[] hostIds = AccessController.doPrivileged(() -> ((LicenseDatabase)LicenseDatabase.LOCAL_INSTANCE).getHostIds());
        FoxMessage response = new FoxMessage();
        for (String hostId : hostIds) {
            response.add("hostId", hostId);
        }
        circuit.writeMessage(response);
        circuit.flush();
    }

    public VendorLicense[] getLicenses(String hostId) throws Exception {
        VendorLicense license;
        if (this.isTraceOn()) {
            this.trace("c:getLicenses");
        }
        FoxCircuit circuit = this.openCircuit("getLicenses");
        FoxMessage request = new FoxMessage();
        request.add("hostId", hostId);
        circuit.writeMessage(request);
        circuit.flush();
        ArrayList<VendorLicense> result = new ArrayList<VendorLicense>();
        while ((license = this.readLicense(circuit)) != null) {
            result.add(license);
        }
        return result.toArray(new VendorLicense[0]);
    }

    public void getLicenses(FoxCircuit circuit) throws Exception {
        if (this.isTraceOn()) {
            this.trace("s:getLicenses");
        }
        FoxMessage request = circuit.readMessage();
        AccessController.doPrivileged(() -> {
            for (VendorLicense license : LicenseDatabase.LOCAL_INSTANCE.getLicenses(request.getString("hostId"))) {
                this.writeLicenseMessage(circuit, license);
            }
            return null;
        });
        this.writeEndOfDataMessage(circuit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportLicenses(OutputStream out) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:exportLicenses");
        }
        FoxCircuit circuit = this.openCircuit("exportLicenses");
        FoxMessage request = new FoxMessage();
        request.add("scope", "all");
        circuit.writeMessage(request);
        circuit.flush();
        ChunkedInputStream in = new ChunkedInputStream(circuit);
        try {
            FileUtil.pipe((InputStream)in, (OutputStream)out);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportLicenses(String[] hostIds, OutputStream out) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:exportLicenses");
        }
        FoxCircuit circuit = this.openCircuit("exportLicenses");
        FoxMessage request = new FoxMessage();
        request.add("scope", "hostIds");
        for (String hostId : hostIds) {
            request.add("hostId", hostId);
        }
        circuit.writeMessage(request);
        circuit.flush();
        ChunkedInputStream in = new ChunkedInputStream(circuit);
        try {
            FileUtil.pipe((InputStream)in, (OutputStream)out);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    public void exportLicenses(FoxCircuit circuit) throws Exception {
        if (this.isTraceOn()) {
            this.trace("s:exportLicenses");
        }
        FoxMessage request = circuit.readMessage();
        try (ChunkedOutputStream out = new ChunkedOutputStream(circuit);){
            AccessController.doPrivileged(() -> BNiagaraProvisioningChannel.lambda$exportLicenses$6(request, (OutputStream)out));
        }
    }

    public void removeLicense(VendorLicense license) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:removeLicense");
        }
        FoxCircuit circuit = this.openCircuit("removeLicense");
        this.writeLicenseMessage(circuit, license);
    }

    public void removeLicense(FoxCircuit circuit) throws Exception {
        if (this.isTraceOn()) {
            this.trace("s:removeLicense");
        }
        AccessController.doPrivileged(() -> {
            LicenseDatabase.LOCAL_INSTANCE.remove(this.readLicense(circuit));
            return null;
        });
    }

    public boolean addLicense(VendorLicense license) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:addLicense");
        }
        FoxCircuit circuit = this.openCircuit("addLicense");
        this.writeLicenseMessage(circuit, license);
        FoxMessage response = circuit.readMessage();
        return response.getBoolean("result");
    }

    public void addLicense(FoxCircuit circuit) throws Exception {
        if (this.isTraceOn()) {
            this.trace("s:addLicense");
        }
        FoxMessage response = new FoxMessage();
        AccessController.doPrivileged(() -> {
            response.add("result", LicenseDatabase.LOCAL_INSTANCE.add(this.readLicense(circuit)));
            return null;
        });
        circuit.writeMessage(response);
        circuit.flush();
    }

    public boolean addCertificate(VendorCertificate cert) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:addCertificate");
        }
        FoxCircuit circuit = this.openCircuit("addCertificate");
        this.writeCertificateMessage(circuit, cert);
        FoxMessage response = circuit.readMessage();
        return response.getBoolean("result");
    }

    public void addCertificate(FoxCircuit circuit) throws Exception {
        if (this.isTraceOn()) {
            this.trace("s:addCertificate");
        }
        FoxMessage response = new FoxMessage();
        try {
            AccessController.doPrivileged(() -> {
                response.add("result", CertificateDatabase.LOCAL_INSTANCE.add(this.readCertificate(circuit)));
                return null;
            });
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
        circuit.writeMessage(response);
        circuit.flush();
    }

    public Iterator<VendorLicense> licenseIterator() throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:licenseIterator");
        }
        return new LicenseIterator(this.openCircuit("licenseIterator"));
    }

    public void licenseIterator(FoxCircuit circuit) throws Exception {
        if (this.isTraceOn()) {
            this.trace("s:licenseIterator");
        }
        AccessController.doPrivileged(() -> {
            Iterator i = LicenseDatabase.LOCAL_INSTANCE.iterator();
            while (i.hasNext()) {
                this.writeLicenseMessage(circuit, (VendorLicense)i.next());
            }
            return null;
        });
        this.writeEndOfDataMessage(circuit);
    }

    private void writeLicenseSummaryMessage(FoxCircuit circuit, BEnvLicenseSummary summary) throws Exception {
        FoxMessage request = new FoxMessage();
        request.add("type", "licenseSummary");
        BogCodec.add((FoxMessage)request, (String)"data", (BValue)summary, null);
        circuit.writeMessage(request);
    }

    private BEnvLicenseSummary readLicenseSummary(FoxCircuit circuit) throws Exception {
        FoxMessage response = circuit.readMessage();
        while (!response.getString("type").equals("licenseSummary")) {
            if (response.getString("type").equals("endOfData")) {
                return null;
            }
            response = circuit.readMessage();
        }
        return (BEnvLicenseSummary)DecoderFactory.decode((FoxMessage)response, (String)"data", null);
    }

    private void writeCertSummaryMessage(FoxCircuit circuit, BCertificateSummary summary) throws Exception {
        FoxMessage request = new FoxMessage();
        request.add("type", "certSummary");
        BogCodec.add((FoxMessage)request, (String)"data", (BValue)summary, null);
        circuit.writeMessage(request);
    }

    private BCertificateSummary readCertSummary(FoxCircuit circuit) throws Exception {
        FoxMessage response = circuit.readMessage();
        while (!response.getString("type").equals("certSummary")) {
            if (response.getString("type").equals("endOfData")) {
                return null;
            }
            response = circuit.readMessage();
        }
        return (BCertificateSummary)DecoderFactory.decode((FoxMessage)response, (String)"data", null);
    }

    private void writeLicenseMessage(FoxCircuit circuit, VendorLicense license) throws Exception {
        FoxMessage request = new FoxMessage();
        request.add("type", "license");
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        license.save((OutputStream)bytes, true);
        request.add("data", bytes.toByteArray());
        circuit.writeMessage(request);
    }

    private VendorLicense readLicense(FoxCircuit circuit) throws Exception {
        FoxMessage response = circuit.readMessage();
        while (!response.getString("type").equals("license")) {
            if (response.getString("type").equals("endOfData")) {
                return null;
            }
            response = circuit.readMessage();
        }
        ByteArrayInputStream bytes = new ByteArrayInputStream(response.getBlob("data"));
        return VendorLicense.make((String)"provisioning", (InputStream)bytes, (boolean)true);
    }

    private void writeCertificateMessage(FoxCircuit circuit, VendorCertificate cert) throws Exception {
        FoxMessage request = new FoxMessage();
        request.add("type", "certificate");
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        cert.save((OutputStream)bytes, true);
        request.add("data", bytes.toByteArray());
        circuit.writeMessage(request);
    }

    private VendorCertificate readCertificate(FoxCircuit circuit) throws Exception {
        FoxMessage response = circuit.readMessage();
        while (!response.getString("type").equals("certificate")) {
            if (response.getString("type").equals("endOfData")) {
                return null;
            }
            response = circuit.readMessage();
        }
        ByteArrayInputStream bytes = new ByteArrayInputStream(response.getBlob("data"));
        return VendorCertificate.make((String)"provisioning", (InputStream)bytes, (boolean)true);
    }

    private void writeEndOfDataMessage(FoxCircuit circuit) throws Exception {
        FoxMessage response = new FoxMessage();
        response.add("type", "endOfData");
        circuit.writeMessage(response);
    }

    public BInstallable getInstallableByPath(FilePath path) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:getInstallableByPath");
        }
        FoxCircuit circuit = this.openCircuit("getInstallableByPath");
        FoxMessage request = new FoxMessage();
        request.add("pathString", path.getBody());
        circuit.writeMessage(request);
        circuit.flush();
        FoxMessage response = circuit.readMessage();
        if ("notFound".equals(response.getString("status"))) {
            return null;
        }
        return (BInstallable)DecoderFactory.decode((FoxMessage)response, (String)"payload", null);
    }

    public void getInstallableByPath(FoxCircuit circuit) throws Exception {
        FoxMessage request = circuit.readMessage();
        if (this.isTraceOn()) {
            this.trace("s:getInstallableByPath");
        }
        BIFile file = BFileSystem.INSTANCE.findFile(new FilePath(request.getString("pathString")));
        BInstallable result = null;
        if (file != null) {
            result = BInstallable.make((BIFile)file);
        }
        FoxMessage response = new FoxMessage();
        if (result == null) {
            response.add("status", "notFound");
        } else {
            response.add("status", "ok");
            BogCodec.add((FoxMessage)response, (String)"payload", (BValue)result, null);
        }
        circuit.writeMessage(response);
        circuit.flush();
    }

    public void registerStationInstallable(BInstallable inst, DaemonSessionTaskListener listener) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:registerInstallable");
        }
        if (inst.getInstallableFileOrd().isNull()) {
            throw new IllegalArgumentException("Installable has no associated file");
        }
        FoxCircuit circuit = this.openCircuit("registerInstallable");
        FoxMessage request = new FoxMessage();
        request.add("name", inst.getInstallableName());
        request.add("fileName", inst.getInstallableFileName());
        BogCodec.add((FoxMessage)request, (String)"version", (BValue)inst.getVersion(), null);
        BogCodec.add((FoxMessage)request, (String)"typeSpec", (BValue)inst.getType().getTypeSpec(), null);
        BogCodec.add((FoxMessage)request, (String)"fileOrd", (BValue)inst.getInstallableFileOrd(), null);
        circuit.writeMessage(request);
        circuit.flush();
        try (TaskListenerClient listenerClient = new TaskListenerClient(listener);){
            while (true) {
                FoxMessage response;
                if ("status".equals((response = circuit.readMessage()).getString("type"))) {
                    return;
                }
                listenerClient.handleMessage(response);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerStationInstallable(FoxCircuit circuit) throws Exception {
        FoxMessage request = circuit.readMessage();
        if (this.isTraceOn()) {
            this.trace("s:registerStationInstallable");
        }
        try {
            BIFile file;
            BInstallable inst;
            String name = request.getString("name");
            BVersion version = (BVersion)DecoderFactory.decode((FoxMessage)request, (String)"version", null);
            BTypeSpec typeSpec = (BTypeSpec)DecoderFactory.decode((FoxMessage)request, (String)"typeSpec", null);
            BOrd fileOrd = (BOrd)DecoderFactory.decode((FoxMessage)request, (String)"fileOrd", null);
            BInstallable existing = LocalInstallableRegistry.getInstance().findInstallable(name, version.getVendorVersion(), typeSpec.getResolvedType(), (DaemonSessionTaskListener)new TaskDispatcher(circuit));
            FoxMessage response = new FoxMessage();
            if (existing == null && (inst = BInstallable.make((BIFile)(file = (BIFile)fileOrd.get()))) != null) {
                LocalInstallableRegistry.getInstance().register(inst, null);
            }
            response.add("type", "status");
            response.add("status", "ok");
            circuit.writeMessage(response);
            circuit.flush();
        }
        finally {
            circuit.close();
        }
    }

    public void registerInstallable(BInstallable inst, DaemonSessionTaskListener listener) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:registerInstallable");
        }
        if (inst.getInstallableFileOrd().isNull()) {
            throw new IllegalArgumentException("Installable has no associated file");
        }
        BIFile file = (BIFile)inst.getInstallableFileOrd().get();
        if (file != null && file.getStore() instanceof BLocalFileStore) {
            FoxCircuit circuit = this.openCircuit("registerInstallable");
            FoxMessage request = new FoxMessage();
            request.add("name", inst.getInstallableName());
            request.add("fileName", inst.getInstallableFileName());
            BogCodec.add((FoxMessage)request, (String)"version", (BValue)inst.getVersion(), null);
            BogCodec.add((FoxMessage)request, (String)"typeSpec", (BValue)inst.getType().getTypeSpec(), null);
            circuit.writeMessage(request);
            circuit.flush();
            try (TaskListenerClient listenerClient = new TaskListenerClient(listener);){
                while (true) {
                    FoxMessage response;
                    if ("status".equals((response = circuit.readMessage()).getString("type"))) {
                        if ("continue".equals(response.getString("status"))) {
                            try (InputStream in = file.getInputStream();
                                 ChunkedOutputStream out = new ChunkedOutputStream(circuit);){
                                FileUtil.pipe((InputStream)in, (long)file.getSize(), (OutputStream)out);
                            }
                        }
                        return;
                    }
                    listenerClient.handleMessage(response);
                }
            }
        }
        throw new IllegalArgumentException("Installable is not a local file");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInstallable(FoxCircuit circuit) throws Exception {
        FoxMessage request = circuit.readMessage();
        if (this.isTraceOn()) {
            this.trace("s:registerInstallable");
        }
        try {
            String name = request.getString("name");
            String fileName = request.getString("fileName");
            BVersion version = (BVersion)DecoderFactory.decode((FoxMessage)request, (String)"version", null);
            BTypeSpec typeSpec = (BTypeSpec)DecoderFactory.decode((FoxMessage)request, (String)"typeSpec", null);
            BInstallable existing = LocalInstallableRegistry.getInstance().findInstallable(name, version.getVendorVersion(), typeSpec.getResolvedType(), (DaemonSessionTaskListener)new TaskDispatcher(circuit));
            FoxMessage response = new FoxMessage();
            if (existing == null) {
                response.add("type", "status");
                response.add("status", "continue");
                circuit.writeMessage(response);
                circuit.flush();
                LocalInstallableRegistry.getInstance().register(name, fileName, version, (InputStream)new ChunkedInputStream(circuit), null);
            } else {
                response.add("type", "status");
                response.add("status", "duplicate");
                circuit.writeMessage(response);
                circuit.flush();
            }
        }
        finally {
            circuit.close();
        }
    }

    public <T> IterableCursor<T> getInstallables(boolean latestOnly, boolean sendSpec, DaemonSessionTaskListener listener, String includes, String excludes) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:getInstallables");
        }
        FoxCircuit circuit = this.openCircuit("getInstallables");
        FoxMessage request = new FoxMessage();
        request.add("latestOnly", latestOnly);
        request.add("sendSpec", sendSpec);
        if (includes != null) {
            request.add("includes", includes);
        }
        if (excludes != null) {
            request.add("excludes", excludes);
        }
        circuit.writeMessage(request);
        circuit.flush();
        return new GetInstallablesCursor(circuit, listener);
    }

    public IterableCursor<BInstallable> getInstallables(BDependency depend, DaemonSessionTaskListener listener) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:getInstallables");
        }
        FoxCircuit circuit = this.openCircuit("getInstallables");
        FoxMessage request = new FoxMessage();
        request.add("latestOnly", false);
        request.add("sendSpec", false);
        BogCodec.add((FoxMessage)request, (String)"depend", (BValue)depend, null);
        circuit.writeMessage(request);
        circuit.flush();
        return new GetInstallablesCursor<BInstallable>(circuit, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getInstallables(FoxCircuit circuit) throws Exception {
        FoxMessage request = circuit.readMessage();
        if (this.isTraceOn()) {
            this.trace("s:getInstallables");
        }
        boolean latestOnly = request.getBoolean("latestOnly", false);
        boolean sendSpec = request.getBoolean("sendSpec", false);
        String includes = request.getString("includes", null);
        String excludes = request.getString("excludes", null);
        FoxObject dependEncoded = (FoxObject)request.getOptional("depend");
        try (IterableCursor c = dependEncoded == null ? LocalInstallableRegistry.getInstance().getInstallables(latestOnly, (DaemonSessionTaskListener)new TaskDispatcher(circuit), includes, excludes) : LocalInstallableRegistry.getInstance().getInstallables((BDependency)DecoderFactory.decode((FoxObject)dependEncoded, null), (DaemonSessionTaskListener)new TaskDispatcher(circuit));){
            while (c.next()) {
                BInstallable inst = (BInstallable)c.get();
                FoxMessage response = new FoxMessage();
                if (sendSpec) {
                    response.add("type", "spec");
                    BogCodec.add((FoxMessage)response, (String)"payload", (BValue)BInstallableSpec.make((BInstallable)inst), null);
                } else {
                    response.add("type", "installable");
                    inst.getDependencies();
                    BogCodec.add((FoxMessage)response, (String)"payload", (BValue)inst, null);
                }
                circuit.writeMessage(response);
                circuit.flush();
            }
            FoxMessage response = new FoxMessage();
            response.add("type", "end");
            circuit.writeMessage(response);
            circuit.flush();
        }
        finally {
            circuit.close();
        }
    }

    public BInstallable[] findInstallables(BDependency depend, DaemonSessionTaskListener listener) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:findInstallable");
        }
        FoxCircuit circuit = this.openCircuit("findInstallables");
        FoxMessage request = new FoxMessage();
        BogCodec.add((FoxMessage)request, (String)"depend", (BValue)depend, null);
        circuit.writeMessage(request);
        circuit.flush();
        TaskListenerClient listenerClient = new TaskListenerClient(listener);
        ArrayList<BInstallable> result = new ArrayList<BInstallable>();
        try {
            while (true) {
                FoxMessage message;
                if (listenerClient.handleMessage(message = circuit.readMessage())) continue;
                String messageType = message.getString("type");
                if (messageType.equals("result")) {
                    result.add((BInstallable)DecoderFactory.decode((FoxMessage)message, (String)"payload", null));
                    continue;
                }
                if (!messageType.equals("end")) continue;
                BInstallable[] bInstallableArray = result.toArray(new BInstallable[0]);
                return bInstallableArray;
            }
        }
        finally {
            listenerClient.close();
            circuit.close();
        }
    }

    public void findInstallables(FoxCircuit circuit) throws Exception {
        FoxMessage response;
        FoxMessage request = circuit.readMessage();
        if (this.isTraceOn()) {
            this.trace("s:findInstallables");
        }
        BDependency depend = (BDependency)DecoderFactory.decode((FoxMessage)request, (String)"depend", null);
        for (BInstallable inst : LocalInstallableRegistry.getInstance().getInstallables(depend, (DaemonSessionTaskListener)new TaskDispatcher(circuit))) {
            response = new FoxMessage();
            response.add("type", "result");
            inst.getDependencies();
            BogCodec.add((FoxMessage)response, (String)"payload", (BValue)inst, null);
            circuit.writeMessage(response);
        }
        response = new FoxMessage();
        response.add("type", "end");
        circuit.writeMessage(response);
        circuit.flush();
        circuit.close();
    }

    public BInstallable findInstallable(BDependency depend, DaemonSessionTaskListener listener) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:findInstallable");
        }
        FoxCircuit circuit = this.openCircuit("findInstallable");
        FoxMessage request = new FoxMessage();
        BogCodec.add((FoxMessage)request, (String)"depend", (BValue)depend, null);
        circuit.writeMessage(request);
        circuit.flush();
        TaskListenerClient listenerClient = new TaskListenerClient(listener);
        try {
            while (true) {
                FoxMessage message;
                if (listenerClient.handleMessage(message = circuit.readMessage())) continue;
                String messageType = message.getString("type");
                if (messageType.equals("result")) {
                    BInstallable bInstallable = (BInstallable)DecoderFactory.decode((FoxMessage)message, (String)"payload", null);
                    return bInstallable;
                }
                if (!messageType.equals("notFound")) continue;
                BInstallable bInstallable = null;
                return bInstallable;
            }
        }
        finally {
            listenerClient.close();
            circuit.close();
        }
    }

    public void findInstallable(FoxCircuit circuit) throws Exception {
        FoxMessage request = circuit.readMessage();
        if (this.isTraceOn()) {
            this.trace("s:findInstallable");
        }
        BDependency depend = (BDependency)DecoderFactory.decode((FoxMessage)request, (String)"depend", null);
        BInstallable result = LocalInstallableRegistry.getInstance().findInstallable(depend, (DaemonSessionTaskListener)new TaskDispatcher(circuit));
        FoxMessage response = new FoxMessage();
        if (result == null) {
            response.add("type", "notFound");
        } else {
            response.add("type", "result");
            result.getDependencies();
            BogCodec.add((FoxMessage)response, (String)"payload", (BValue)result, null);
        }
        circuit.writeMessage(response);
        circuit.flush();
        circuit.close();
    }

    public boolean validateDistPassphraseToPlatform(String stationName, FilePath path) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:validateDistPassphraseToPlatform");
        }
        FoxRequest request = this.makeRequest("validateDistPassphraseToPlatform");
        request.add("stationName", stationName);
        request.add("path", path.getBody());
        FoxResponse response = this.sendSync(request);
        return response.getBoolean("isPassphraseValid", false);
    }

    public boolean validatePassphraseToDist(FilePath path, BPassword password) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:validatePassphraseToDist");
        }
        FoxRequest request = this.makeRequest("validatePassphraseToDist");
        request.add("path", path.getBody());
        request.add("encodedPassword", this.marshal((BValue)password, null));
        FoxResponse response = this.sendSync(request);
        return response.getBoolean("isPassphraseValid", false);
    }

    public FoxResponse validateDistPassphraseToPlatform(FoxRequest request) throws Exception {
        FoxResponse response = new FoxResponse(request);
        FilePath path = new FilePath(request.getString("path"));
        BNiagaraStation station = BNiagaraProvisioningChannel.getStation((FoxMessage)request);
        boolean result = BBackupStepDetailsRpc.validateDistPassphraseToPlatform(station, path);
        response.add("isPassphraseValid", result);
        return response;
    }

    public FoxResponse validatePassphraseToDist(FoxRequest request) throws Exception {
        FoxResponse response = new FoxResponse(request);
        FilePath path = new FilePath(request.getString("path"));
        BPassword passphrase = (BPassword)this.unmarshal(request.getString("encodedPassword"), null);
        boolean result = BBackupStepDetailsRpc.validatePassphraseToDist(path, passphrase);
        response.add("isPassphraseValid", result);
        return response;
    }

    protected final boolean useSharedKeyEncryption() {
        return true;
    }

    public Context getEncryptionContext(Context context, boolean outgoing) {
        return this.makeEncryptionContext(context, outgoing);
    }

    private static /* synthetic */ Void lambda$exportLicenses$6(FoxMessage request, OutputStream out) throws Exception {
        if (request.getString("scope").equals("all")) {
            LicenseDatabase.LOCAL_INSTANCE.exportLicenses(out);
        } else {
            LicenseDatabase.LOCAL_INSTANCE.exportLicenses(request.listStrings("hostId"), out);
        }
        return null;
    }

    private class LicenseIterator
    implements Iterator<VendorLicense> {
        private FoxCircuit circuit;
        private VendorLicense nextObject = null;

        public LicenseIterator(FoxCircuit circuit) {
            this.circuit = circuit;
        }

        @Override
        public boolean hasNext() {
            if (this.circuit == null) {
                return false;
            }
            if (this.nextObject == null) {
                try {
                    this.nextObject = BNiagaraProvisioningChannel.this.readLicense(this.circuit);
                    if (this.nextObject == null) {
                        this.circuit = null;
                        return false;
                    }
                    return true;
                }
                catch (Exception e) {
                    this.circuit = null;
                    this.nextObject = null;
                    e.printStackTrace();
                    return false;
                }
            }
            return true;
        }

        @Override
        public VendorLicense next() {
            if (this.hasNext()) {
                VendorLicense temp = this.nextObject;
                this.nextObject = null;
                return temp;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class GetInstallablesCursor<T>
    implements IterableCursor<T> {
        private final FoxCircuit circuit;
        private final MessageClient[] messageClients;
        private T current = null;

        public GetInstallablesCursor(FoxCircuit pCircuit, DaemonSessionTaskListener pListener) {
            this(pCircuit, new MessageClient[]{new TaskListenerClient(pListener)});
        }

        public GetInstallablesCursor(FoxCircuit pCircuit, MessageClient[] messageClients) {
            this.messageClients = messageClients;
            this.circuit = pCircuit;
        }

        public Context getContext() {
            return null;
        }

        public boolean next() {
            try {
                FoxMessage message;
                String messageType;
                do {
                    message = null;
                    boolean keepReading = true;
                    block4: while (keepReading) {
                        keepReading = false;
                        message = this.circuit.readMessage();
                        for (MessageClient messageClient : this.messageClients) {
                            if (!messageClient.handleMessage(message)) continue;
                            keepReading = true;
                            continue block4;
                        }
                    }
                    messageType = message.getString("type");
                    if (!messageType.equals("end")) continue;
                    this.close();
                    return false;
                } while (!messageType.equals("installable") && !messageType.equals("spec"));
                this.current = DecoderFactory.decode((FoxMessage)message, (String)"payload", null);
                return true;
            }
            catch (RuntimeException re) {
                this.close();
                throw re;
            }
            catch (Exception e) {
                this.close();
                throw new BajaRuntimeException((Throwable)e);
            }
        }

        public T get() {
            return this.current;
        }

        public void close() {
            this.circuit.close();
            for (MessageClient messageClient : this.messageClients) {
                messageClient.close();
            }
        }
    }
}

