/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara;

import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.provisioningNiagara.BProvisioningStationExt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.batchJob.driver.BNetworkBatchAgent;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.PermissionException;
import javax.baja.space.BSpace;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"niagaraDriver:NiagaraNetwork"})})
@NiagaraSingleton
public class BNiagaraNetworkBatchAgent
extends BNetworkBatchAgent {
    @Generated
    public static final BNiagaraNetworkBatchAgent INSTANCE = new BNiagaraNetworkBatchAgent();
    @Generated
    public static final Type TYPE = Sys.loadType(BNiagaraNetworkBatchAgent.class);
    private static TypeInfo[] EXT_TYPES = null;
    private static final Logger logger = Logger.getLogger("provisioningNiagara");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSimple getBatchDeviceId(BDevice device) {
        return BString.make((String)((BNiagaraStation)device).getStationName());
    }

    public BDevice getBatchDevice(BDeviceNetwork nw, BSimple deviceId) {
        if (!(nw instanceof BNiagaraNetwork)) {
            return null;
        }
        if (EXT_TYPES == null) {
            EXT_TYPES = Sys.getRegistry().getConcreteTypes(BProvisioningStationExt.TYPE.getTypeInfo());
        }
        StringBuilder bql = new StringBuilder("bql:select slotPath from niagaraDriver:NiagaraStation stop where name = '");
        bql.append(deviceId.toString());
        bql.append("' and ( ");
        for (int i = 0; i < EXT_TYPES.length; ++i) {
            if (i > 0) {
                bql.append("or ");
            }
            bql.append(EXT_TYPES[i].getModuleName());
            bql.append('_');
            bql.append(EXT_TYPES[i].getTypeName());
            bql.append(".enabled ");
        }
        bql.append(')');
        BITable table = (BITable)BOrd.make((String)bql.toString()).get((BObject)nw);
        try (TableCursor c = table.cursor();){
            if (c.next()) {
                Column slotPathCol = table.getColumns().get(0);
                String stationPath = c.cell(slotPathCol).toString();
                BNiagaraStation bNiagaraStation = (BNiagaraStation)BOrd.make((String)stationPath).get((BObject)nw);
                return bNiagaraStation;
            }
        }
        return null;
    }

    public BDeviceNetwork getDeviceNetwork(BDevice device) {
        return ((BNiagaraStation)device).getNiagaraNetwork();
    }

    public BDevice[] listBatchDevices(BDeviceNetwork nw) {
        ArrayList<BNiagaraStation> result = new ArrayList<BNiagaraStation>();
        try {
            nw.lease(1);
            BSpace space = BOrd.toSpace((BObject)nw);
            if (EXT_TYPES == null) {
                EXT_TYPES = Sys.getRegistry().getConcreteTypes(BProvisioningStationExt.TYPE.getTypeInfo());
            }
            StringBuilder bql = new StringBuilder("bql:select slotPath from niagaraDriver:NiagaraStation stop ");
            for (int i = 0; i < EXT_TYPES.length; ++i) {
                if (i == 0) {
                    bql.append("where ");
                } else {
                    bql.append("or ");
                }
                bql.append(EXT_TYPES[i].getModuleName());
                bql.append('_');
                bql.append(EXT_TYPES[i].getTypeName());
                bql.append(".enabled ");
            }
            BITable table = (BITable)BOrd.make((String)bql.toString()).get((BObject)nw);
            Column slotPathCol = table.getColumns().get(0);
            HashSet<String> usedPaths = new HashSet<String>();
            try (TableCursor c = table.cursor();){
                while (c.next()) {
                    String stationPath = c.cell(slotPathCol).toString();
                    if (usedPaths.contains(stationPath)) continue;
                    BNiagaraStation station = (BNiagaraStation)BOrd.make((String)stationPath).get((BObject)space);
                    usedPaths.add(stationPath);
                    result.add(station);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cannot list devices", e);
        }
        return (BDevice[])result.toArray(new BNiagaraStation[0]);
    }

    public boolean isBatchDevice(BDevice device) {
        if (!(device instanceof BNiagaraStation)) {
            return false;
        }
        BITable table = (BITable)BOrd.make((String)"bql:select slotPath from provisioningNiagara:ProvisioningStationExt stop where enabled").get((BObject)device);
        return table.cursor().next();
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static List<String> listNiagaraNetworkBatchDeviceNames(String nwOrd, Context cx) {
        BDeviceNetwork nw = (BDeviceNetwork)BOrd.make((String)nwOrd).get(null, cx);
        if (!nw.getPermissions(cx).hasOperatorRead()) {
            throw new PermissionException("Insufficient privileges to Device Network");
        }
        List<BDevice> devices = Arrays.asList(INSTANCE.listBatchDevices(nw));
        return devices.stream().filter(device -> device.getPermissions(cx).hasOperatorRead()).map(BComplex::getName).collect(Collectors.toList());
    }
}

