/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.basicdriver;

import com.tridium.basicdriver.MessageListener;
import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.util.BBasicCoalescingWorker;
import com.tridium.basicdriver.util.BBasicPollScheduler;
import com.tridium.basicdriver.util.BBasicWorker;
import javax.baja.data.BIDataValue;
import javax.baja.driver.loadable.BLoadableNetwork;
import javax.baja.driver.point.BTuningPolicyMap;
import javax.baja.driver.util.BPollScheduler;
import javax.baja.log.Log;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIService;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.ICoalesceable;
import javax.baja.util.IFuture;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="tuningPolicies", type="BTuningPolicyMap", defaultValue="new BTuningPolicyMap()"), @NiagaraProperty(name="dispatcher", type="BBasicWorker", defaultValue="new BBasicWorker()", flags=4), @NiagaraProperty(name="worker", type="BBasicWorker", defaultValue="new BBasicCoalescingWorker()", flags=4), @NiagaraProperty(name="writeWorker", type="BBasicCoalescingWorker", defaultValue="new BBasicCoalescingWorker()", flags=4), @NiagaraProperty(name="pollScheduler", type="BPollScheduler", defaultValue="new BBasicPollScheduler()"), @NiagaraProperty(name="retryCount", type="int", defaultValue="1"), @NiagaraProperty(name="responseTimeout", type="BRelTime", defaultValue="BRelTime.make(500)", facets={@Facet(value="BFacets.make(BFacets.SHOW_MILLISECONDS, BBoolean.TRUE)")})})
public abstract class BBasicNetwork
extends BLoadableNetwork
implements BIService {
    @Generated
    public static final Property tuningPolicies = BBasicNetwork.newProperty((int)0, (BValue)new BTuningPolicyMap(), null);
    @Generated
    public static final Property dispatcher = BBasicNetwork.newProperty((int)4, (BValue)new BBasicWorker(), null);
    @Generated
    public static final Property worker = BBasicNetwork.newProperty((int)4, (BValue)new BBasicCoalescingWorker(), null);
    @Generated
    public static final Property writeWorker = BBasicNetwork.newProperty((int)4, (BValue)new BBasicCoalescingWorker(), null);
    @Generated
    public static final Property pollScheduler = BBasicNetwork.newProperty((int)0, (BValue)new BBasicPollScheduler(), null);
    @Generated
    public static final Property retryCount = BBasicNetwork.newProperty((int)0, (int)1, null);
    @Generated
    public static final Property responseTimeout = BBasicNetwork.newProperty((int)0, (BValue)BRelTime.make((long)500L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Type TYPE = Sys.loadType(BBasicNetwork.class);
    private Comm comm = null;
    private long totalSentMessages = 0L;
    private long totalReceivedMessages = 0L;
    private long lastSentMessages = 0L;
    private long lastReceivedMessages = 0L;
    private long lastRateTicks = Clock.ticks();
    private long totalTimeoutMessages = 0L;

    @Generated
    public BTuningPolicyMap getTuningPolicies() {
        return (BTuningPolicyMap)this.get(tuningPolicies);
    }

    @Generated
    public void setTuningPolicies(BTuningPolicyMap v) {
        this.set(tuningPolicies, (BValue)v, null);
    }

    @Generated
    public BBasicWorker getDispatcher() {
        return (BBasicWorker)this.get(dispatcher);
    }

    @Generated
    public void setDispatcher(BBasicWorker v) {
        this.set(dispatcher, (BValue)v, null);
    }

    @Generated
    public BBasicWorker getWorker() {
        return (BBasicWorker)this.get(worker);
    }

    @Generated
    public void setWorker(BBasicWorker v) {
        this.set(worker, (BValue)v, null);
    }

    @Generated
    public BBasicCoalescingWorker getWriteWorker() {
        return (BBasicCoalescingWorker)this.get(writeWorker);
    }

    @Generated
    public void setWriteWorker(BBasicCoalescingWorker v) {
        this.set(writeWorker, (BValue)v, null);
    }

    @Generated
    public BPollScheduler getPollScheduler() {
        return (BPollScheduler)this.get(pollScheduler);
    }

    @Generated
    public void setPollScheduler(BPollScheduler v) {
        this.set(pollScheduler, (BValue)v, null);
    }

    @Generated
    public int getRetryCount() {
        return this.getInt(retryCount);
    }

    @Generated
    public void setRetryCount(int v) {
        this.setInt(retryCount, v, null);
    }

    @Generated
    public BRelTime getResponseTimeout() {
        return (BRelTime)this.get(responseTimeout);
    }

    @Generated
    public void setResponseTimeout(BRelTime v) {
        this.set(responseTimeout, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{this.getType()};
    }

    public void serviceStarted() throws Exception {
        this.buildComm();
    }

    public void serviceStopped() throws Exception {
    }

    private void buildComm() throws Exception {
        this.comm = this.makeComm();
        this.initComm(this.comm);
    }

    protected void initComm(Comm comm) throws Exception {
    }

    public void startComm() throws Exception {
        if (!this.isDisabled() && !this.isFatalFault() && this.comm != null) {
            if (this.getLog().isTraceOn()) {
                this.getLog().trace(this.getName() + " *** Starting Communication Handler ***");
            }
            this.comm.start();
            if (this.getLog().isTraceOn()) {
                this.getLog().trace(this.getName() + " *** Started Communication Handler ***");
            }
        }
    }

    public void stopComm() throws Exception {
        if (this.comm != null && this.comm.isCommStarted()) {
            if (this.getLog().isTraceOn()) {
                this.getLog().trace(this.getName() + " *** Stopping Communication Handler ***");
            }
            this.comm.stop();
            if (this.getLog().isTraceOn()) {
                this.getLog().trace(this.getName() + " *** Stopped Communication Handler ***");
            }
        }
    }

    public void started() throws Exception {
        super.started();
        try {
            this.startComm();
        }
        catch (Exception e) {
            this.getLog().error("Could not start communication handler", (Throwable)e);
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        try {
            this.stopComm();
        }
        catch (Exception e) {
            this.getLog().error("Could not stop communication handler", (Throwable)e);
        }
    }

    public boolean isCommActive() {
        boolean commStart = true;
        if (this.comm != null) {
            commStart = this.comm.isCommStarted();
        }
        return commStart && !this.isDisabled() && !this.isFault();
    }

    public Comm getComm() {
        return this.comm;
    }

    protected abstract Comm makeComm();

    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (!this.isRunning()) {
            return;
        }
        try {
            if (prop == status) {
                if (!(this.isCommActive() || this.isDisabled() || this.isFatalFault())) {
                    this.startComm();
                } else if (this.isDisabled()) {
                    this.stopComm();
                }
            }
        }
        catch (Exception e) {
            this.getLog().error("BBasicNetwork caught exception in changed(): ", (Throwable)e);
        }
    }

    public Log getLog() {
        return Log.getLog((String)this.getName());
    }

    public final IFuture postAsync(Runnable r) {
        return this.post(r);
    }

    public final IFuture dispatch(Runnable r) {
        return this.getDispatcher().post(r);
    }

    public final IFuture post(Runnable r) {
        return this.getWorker().post(r);
    }

    public final IFuture postWrite(Runnable r) {
        return this.getWriteWorker().post(r);
    }

    public final Message sendSync(Message msg) {
        return this.sendSync(msg, this.getResponseTimeout(), this.getRetryCount());
    }

    public Message sendSync(Message msg, BRelTime responseTimeout, int retryCount) {
        return this.processSend(msg, responseTimeout, retryCount);
    }

    public final void sendAsync(Message msg, MessageListener listener) {
        this.sendAsync(msg, listener, this.getResponseTimeout(), this.getRetryCount());
    }

    public void sendAsync(Message msg, MessageListener listener, BRelTime responseTimeout, int retryCount) {
        this.post(new AsyncMessageRequest(this, msg, listener, responseTimeout, retryCount));
    }

    public final void sendAsyncWrite(Message msg, MessageListener listener) {
        this.sendAsyncWrite(msg, listener, this.getResponseTimeout(), this.getRetryCount());
    }

    public void sendAsyncWrite(Message msg, MessageListener listener, BRelTime responseTimeout, int retryCount) {
        this.postWrite(new AsyncWriteMessageRequest(this, msg, listener, responseTimeout, retryCount));
    }

    private Message processSend(Message msg, BRelTime responseTimeout, int retryCount) {
        if (!this.isCommActive() || msg == null) {
            return null;
        }
        boolean responseExpected = msg.getResponseExpected();
        DispatchRequest req = new DispatchRequest(this, msg, responseTimeout, retryCount);
        if (responseExpected) {
            this.dispatch(req);
            return req.getResponse(0);
        }
        this.dispatch(req);
        return null;
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"BasicNetwork", 2);
        long elapsedTime = Clock.ticks() - this.lastRateTicks;
        double sentMessagesPerSecond = (double)(this.totalSentMessages - this.lastSentMessages) / ((double)elapsedTime / 1000.0);
        double receivedMessagesPerSecond = (double)(this.totalReceivedMessages - this.lastReceivedMessages) / ((double)elapsedTime / 1000.0);
        this.lastSentMessages = this.totalSentMessages;
        this.lastReceivedMessages = this.totalReceivedMessages;
        this.lastRateTicks = Clock.ticks();
        out.prop((Object)"Comm", (Object)this.comm);
        out.prop((Object)"Total Sent Messages", (Object)this.totalSentMessages);
        out.prop((Object)"Sent Messages per Second", (Object)sentMessagesPerSecond);
        out.prop((Object)"Total Received Messages", (Object)this.totalReceivedMessages);
        out.prop((Object)"Received Messages per Second", (Object)receivedMessagesPerSecond);
        out.prop((Object)"Total Failed Messages (timeouts)", (Object)this.totalTimeoutMessages);
        out.endProps();
    }

    public final void incrementSent() {
        ++this.totalSentMessages;
    }

    public final void incrementReceived() {
        ++this.totalReceivedMessages;
    }

    public final void incrementTimeouts() {
        ++this.totalTimeoutMessages;
    }

    public final long getTotalSentMessages() {
        return this.totalSentMessages;
    }

    public final long getTotalReceivedMessages() {
        return this.totalReceivedMessages;
    }

    public final long getTotalTimeoutMessages() {
        return this.totalTimeoutMessages;
    }

    private class AsyncWriteMessageRequest
    extends AsyncMessageRequest
    implements ICoalesceable {
        int hashCode;

        public AsyncWriteMessageRequest(BBasicNetwork basicNet, Message msg, MessageListener source, BRelTime responseTimeout, int retryCount) {
            super(basicNet, msg, source, responseTimeout, retryCount);
            this.hashCode = source.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (object instanceof AsyncWriteMessageRequest) {
                AsyncWriteMessageRequest o = (AsyncWriteMessageRequest)object;
                return this.source == o.source;
            }
            return false;
        }

        public Object getCoalesceKey() {
            return this;
        }

        public ICoalesceable coalesce(ICoalesceable c) {
            return c;
        }
    }

    private class AsyncMessageRequest
    implements Runnable {
        MessageListener source;
        Message msg;
        BBasicNetwork basicNet;
        BRelTime responseTimeout;
        int retryCount;

        public AsyncMessageRequest(BBasicNetwork basicNet, Message msg, MessageListener source, BRelTime responseTimeout, int retryCount) {
            this.basicNet = basicNet;
            this.msg = msg;
            this.source = source;
            this.responseTimeout = responseTimeout;
            this.retryCount = retryCount;
        }

        @Override
        public void run() {
            Message response = this.basicNet.sendSync(this.msg, this.responseTimeout, this.retryCount);
            if (this.source != null && this.msg.getResponseExpected()) {
                this.source.processMessage(response);
            }
        }
    }

    private class DispatchRequest
    implements Runnable {
        Message msg;
        Message response = null;
        boolean complete = false;
        BBasicNetwork basicNet;
        BRelTime responseTimeout;
        int retryCount;

        public DispatchRequest(BBasicNetwork basicNet, Message msg, BRelTime responseTimeout, int retryCount) {
            this.basicNet = basicNet;
            this.msg = msg;
            this.responseTimeout = responseTimeout;
            this.retryCount = retryCount;
        }

        @Override
        public void run() {
            this.execute();
        }

        synchronized void execute() {
            this.response = null;
            try {
                if (this.msg == null) {
                    return;
                }
                if (!this.msg.getResponseExpected()) {
                    this.basicNet.getComm().transmitNoResponse(this.msg);
                } else {
                    this.response = this.basicNet.getComm().transmit(this.msg, this.responseTimeout, this.retryCount);
                }
            }
            catch (Exception e) {
                this.basicNet.getLog().error("DispatchRequest caught exception in execute(): ", (Throwable)e);
            }
            this.complete = true;
            this.notify();
        }

        synchronized Message getResponse(int timeout) {
            if (!this.complete) {
                try {
                    this.wait(timeout);
                }
                catch (Exception e) {
                    this.basicNet.getLog().error("DispatchRequest caught exception in getResponse(): ", (Throwable)e);
                }
            }
            return this.response;
        }
    }
}

