/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.ui;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import javax.baja.file.BIFile;
import javax.baja.file.BajaFileUtil;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.FileUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.event.BScrollEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BSplitPane;

@NiagaraType
@NiagaraAction(name="rightVScroll", parameterType="BScrollEvent", defaultValue="new BScrollEvent()")
public class BAaPhpVisualDiffPane
extends BEdgePane {
    @Generated
    public static final Action rightVScroll = BAaPhpVisualDiffPane.newAction((int)0, (BValue)new BScrollEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAaPhpVisualDiffPane.class);
    private static final double LN_10 = Math.log(10.0);
    private static final int DIFF_MATCH = 0;
    private static final int DIFF_DELETE = -1;
    private static final int DIFF_ADD = 1;
    ComparisonResult[] comparisonResults;
    private int strLineWidth = 6;
    BScrollPane file1Scroller;
    BScrollPane file2Scroller;
    BGridPane file1Pane = new BGridPane(1);
    BGridPane file2Pane = new BGridPane(1);

    @Generated
    public void rightVScroll(BScrollEvent parameter) {
        this.invoke(rightVScroll, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAaPhpVisualDiffPane() {
        this.file1Pane.setHalign(BHalign.left);
        this.file2Pane.setHalign(BHalign.left);
        this.file1Scroller = new BScrollPane((BWidget)new BBorderPane((BWidget)this.file1Pane, BInsets.make((double)3.0)));
        this.file2Scroller = new BScrollPane((BWidget)new BBorderPane((BWidget)this.file2Pane, BInsets.make((double)3.0)));
        this.linkTo((BComponent)this.file2Scroller, (Slot)BScrollPane.vscroll, (Slot)rightVScroll);
        this.file1Scroller.setVpolicy(BScrollBarPolicy.never);
        this.file1Scroller.setHpolicy(BScrollBarPolicy.asNeeded);
        this.file2Scroller.setHpolicy(BScrollBarPolicy.asNeeded);
        BSplitPane splitBothFiles = new BSplitPane((BWidget)this.file1Scroller, (BWidget)this.file2Scroller);
        splitBothFiles.setOrientation(BOrientation.horizontal);
        BBorderPane splitPaneWithMargin = new BBorderPane((BWidget)splitBothFiles, BInsets.make((double)10.0));
        this.setCenter((BWidget)splitPaneWithMargin);
    }

    public void doRightVScroll(BScrollEvent event) {
        this.file1Scroller.doVscroll(event);
    }

    private void showMatch(ComparisonResult match, PrintWriter pw) {
        String[] matchLines = (String[])match.lines.trim();
        int firstOldLine = match.line1;
        int firstNewLine = match.line2;
        for (int i = 0; i < matchLines.length; ++i) {
            if (pw == null) {
                StringBuffer oldLineBuf = new StringBuffer();
                StringBuffer newLineBuf = new StringBuffer();
                this.formatText(firstOldLine + i, matchLines[i], oldLineBuf);
                this.formatText(firstNewLine + i, matchLines[i], newLineBuf);
                this.file1Pane.add("match?", (BValue)this.makeLabel(oldLineBuf.toString(), BColor.black, false));
                this.file2Pane.add("match?", (BValue)this.makeLabel(newLineBuf.toString(), BColor.black, false));
                continue;
            }
            StringBuffer pwBuf = new StringBuffer();
            if (firstOldLine == firstNewLine) {
                this.formatText(firstOldLine + i, matchLines[i], pwBuf);
            } else {
                this.formatText(firstOldLine + i, firstNewLine + i, matchLines[i], pwBuf);
            }
            pw.println("=== " + pwBuf);
        }
    }

    private void showDeletion(ComparisonResult deletion, PrintWriter pw) {
        String[] deletionLines = (String[])deletion.lines.trim();
        int deletionStartLine = deletion.line1;
        for (int i = 0; i < deletionLines.length; ++i) {
            StringBuffer deletionLineBuf = new StringBuffer();
            this.formatText(deletionStartLine + i, deletionLines[i], deletionLineBuf);
            if (pw == null) {
                this.file1Pane.add("deletion?", (BValue)this.makeLabel(deletionLineBuf.toString(), BColor.red, true));
                this.file2Pane.add("deletionPlaceHolder?", (BValue)this.makeLabel("-", BColor.black, true));
                continue;
            }
            pw.println("--- " + deletionLineBuf);
        }
    }

    private void showAddition(ComparisonResult addition, PrintWriter pw) {
        String[] additionLines = (String[])addition.lines.trim();
        int additionStartLine = addition.line2;
        for (int i = 0; i < additionLines.length; ++i) {
            StringBuffer additionLineBuf = new StringBuffer();
            this.formatText(additionStartLine + i, additionLines[i], additionLineBuf);
            if (pw == null) {
                this.file1Pane.add("additionPlaceHolder?", (BValue)this.makeLabel("-", BColor.black, true));
                this.file2Pane.add("addition?", (BValue)this.makeLabel(additionLineBuf.toString(), BColor.green, true));
                continue;
            }
            pw.println("+++ " + additionLineBuf);
        }
    }

    private void formatText(int lineNum, String text, StringBuffer buf) {
        buf.append(TextUtil.padLeft((String)Integer.toString(lineNum), (int)this.strLineWidth));
        buf.append(':');
        buf.append(text);
    }

    private void formatText(int oldLineNum, int newLineNum, String text, StringBuffer buf) {
        buf.append(TextUtil.padLeft((String)Integer.toString(oldLineNum), (int)this.strLineWidth));
        buf.append("=>");
        buf.append(TextUtil.padLeft((String)Integer.toString(newLineNum), (int)this.strLineWidth));
        buf.append(':');
        buf.append(text);
    }

    private void showChange(ComparisonResult deletion, ComparisonResult addition, PrintWriter pw) {
        String[] additionLines;
        int additionSize;
        String[] deletionLines = (String[])deletion.lines.trim();
        int deletionSize = deletionLines.length;
        int maxSize = deletionSize > (additionSize = (additionLines = (String[])addition.lines.trim()).length) ? deletionSize : additionSize;
        int deletionStartLine = deletion.line1;
        int additionStartLine = addition.line2;
        if (pw != null) {
            pw.println();
        }
        for (int i = 0; i < maxSize; ++i) {
            StringBuffer deletionLineBuf = new StringBuffer();
            StringBuffer additionLineBuf = new StringBuffer();
            if (i < deletionLines.length) {
                this.formatText(deletionStartLine + i, deletionLines[i], deletionLineBuf);
            } else {
                deletionLineBuf.append(TextUtil.padLeft((String)"-", (int)this.strLineWidth));
            }
            if (i < additionLines.length) {
                this.formatText(additionStartLine + i, additionLines[i], additionLineBuf);
            } else {
                additionLineBuf.append(TextUtil.padLeft((String)"-", (int)this.strLineWidth));
            }
            if (pw == null) {
                this.file1Pane.add("change?", (BValue)this.makeLabel(deletionLineBuf.toString(), BColor.darkGray, true));
                this.file2Pane.add("change?", (BValue)this.makeLabel(additionLineBuf.toString(), BColor.blue, true));
                continue;
            }
            pw.println("!!- " + deletionLineBuf);
            pw.println("!!+ " + additionLineBuf);
            pw.println();
        }
    }

    private BLabel makeLabel(String text, BColor textColor, boolean bold) {
        BLabel ret = new BLabel(text, BFont.make((String)(bold ? "bold 12pt Courier" : "12pt Courier")));
        ret.setForeground(BBrush.makeSolid((BColor)textColor));
        return ret;
    }

    public void computeDiff(File txtFile1, File txtFile2) throws IOException {
        this.computeDiff(FileUtil.readLines((File)txtFile1), FileUtil.readLines((File)txtFile2));
    }

    public void computeDiff(Reader txtReader1, Reader txtReader2) throws IOException {
        this.computeDiff(FileUtil.readLines((Reader)txtReader1), FileUtil.readLines((Reader)txtReader2));
    }

    public void computeDiff(BIFile txtFile1, BIFile txtFile2) throws IOException {
        this.computeDiff(BajaFileUtil.readLines((BIFile)txtFile1), BajaFileUtil.readLines((BIFile)txtFile2));
    }

    public void computeDiff(String[] file1Lines, String[] file2Lines) {
        this.file1Pane.removeAll();
        this.file2Pane.removeAll();
        int maxLineNum = file1Lines.length > file2Lines.length ? file1Lines.length : file2Lines.length;
        this.strLineWidth = (int)(Math.log(maxLineNum) / LN_10) + 1;
        this.comparisonResults = (ComparisonResult[])this.getComparisonResults(file1Lines, file2Lines).trim();
        for (int i = 0; i < this.comparisonResults.length; ++i) {
            int resultType = this.comparisonResults[i].getType();
            if (resultType == 0) {
                this.showMatch(this.comparisonResults[i], null);
                continue;
            }
            if (resultType == -1) {
                if (i + 1 < this.comparisonResults.length && this.comparisonResults[i + 1].getType() == 1) {
                    this.showChange(this.comparisonResults[i], this.comparisonResults[++i], null);
                    continue;
                }
                this.showDeletion(this.comparisonResults[i], null);
                continue;
            }
            if (resultType == 1) {
                this.showAddition(this.comparisonResults[i], null);
                continue;
            }
            throw new IllegalStateException("Unsupported comparison type :" + resultType + "; Please have my program fixed.");
        }
        this.file1Pane.add("blank?", (BValue)new BLabel());
        this.file1Pane.add("blank?", (BValue)new BLabel());
        this.file2Pane.add("blank?", (BValue)new BLabel());
        this.file2Pane.add("blank?", (BValue)new BLabel());
    }

    public void printText(PrintWriter pw, boolean showMatches, boolean showChanges, boolean showDeletions, boolean showAdditions) {
        for (int i = 0; i < this.comparisonResults.length; ++i) {
            int resultType = this.comparisonResults[i].getType();
            if (resultType == 0) {
                if (!showMatches) continue;
                this.showMatch(this.comparisonResults[i], pw);
                continue;
            }
            if (resultType == -1) {
                if (i + 1 < this.comparisonResults.length && this.comparisonResults[i + 1].getType() == 1) {
                    if (!showChanges) continue;
                    this.showChange(this.comparisonResults[i], this.comparisonResults[++i], pw);
                    continue;
                }
                if (!showDeletions) continue;
                this.showDeletion(this.comparisonResults[i], pw);
                continue;
            }
            if (resultType == 1) {
                if (!showAdditions) continue;
                this.showAddition(this.comparisonResults[i], pw);
                continue;
            }
            throw new IllegalStateException("Unsupported comparison type :" + resultType + "; Please have my program fixed.");
        }
    }

    private Array<ComparisonResult> getComparisonResults(String[] x, String[] y) {
        int j;
        int i;
        int M = x.length;
        int N = y.length;
        int[][] opt = new int[M + 1][N + 1];
        for (i = M - 1; i >= 0; --i) {
            for (j = N - 1; j >= 0; --j) {
                opt[i][j] = x[i].equals(y[j]) ? opt[i + 1][j + 1] + 1 : Math.max(opt[i + 1][j], opt[i][j + 1]);
            }
        }
        i = 0;
        j = 0;
        ComparisonResult lastResult = null;
        Array results = new Array(ComparisonResult.class);
        while (i < M && j < N) {
            if (x[i].equals(y[j])) {
                if (this.isNewComparisonResult(0, lastResult)) {
                    lastResult = new ComparisonResult(0, i, j, x[i++]);
                    results.add((Object)lastResult);
                } else {
                    lastResult.append(x[i++]);
                }
                ++j;
                continue;
            }
            if (opt[i + 1][j] >= opt[i][j + 1]) {
                if (this.isNewComparisonResult(-1, lastResult)) {
                    lastResult = new ComparisonResult(-1, i, j, x[i++]);
                    results.add((Object)lastResult);
                    continue;
                }
                lastResult.append(x[i++]);
                continue;
            }
            if (this.isNewComparisonResult(1, lastResult)) {
                lastResult = new ComparisonResult(1, i, j, y[j++]);
                results.add((Object)lastResult);
                continue;
            }
            lastResult.append(y[j++]);
        }
        while (i < M || j < N) {
            if (i == M) {
                if (this.isNewComparisonResult(1, lastResult)) {
                    lastResult = new ComparisonResult(1, i, j, y[j++]);
                    results.add((Object)lastResult);
                    continue;
                }
                lastResult.append(y[j++]);
                continue;
            }
            if (j != N) continue;
            if (this.isNewComparisonResult(-1, lastResult)) {
                lastResult = new ComparisonResult(-1, i, j, x[i++]);
                results.add((Object)lastResult);
                continue;
            }
            lastResult.append(x[i++]);
        }
        return results;
    }

    private boolean isNewComparisonResult(int type, ComparisonResult lastResult) {
        return lastResult == null || type != lastResult.getType();
    }

    private static class ComparisonResult {
        public int type;
        public int line1;
        public int line2;
        public Array<String> lines;

        public ComparisonResult(int type, int line1, int line2, String line) {
            this.type = type;
            this.lines = new Array(String.class);
            this.lines.add((Object)line);
            this.line1 = line1;
            this.line2 = line2;
        }

        public int getType() {
            return this.type;
        }

        public void append(String line) {
            this.lines.add((Object)line);
        }
    }
}

