/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.cnf;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import java.util.Map;
import net.minidev.json.JSONObject;

public abstract class AbstractConfirmation {
    public abstract Map.Entry<String, JSONObject> toJWTClaim();

    public JSONObject toJSONObject() {
        JSONObject jsonObject = new JSONObject();
        Map.Entry<String, JSONObject> cnfClaim = this.toJWTClaim();
        jsonObject.put((Object)cnfClaim.getKey(), (Object)cnfClaim.getValue());
        return jsonObject;
    }

    public void mergeInto(JSONObject jsonObject) {
        JSONObject cnf = new JSONObject();
        if (jsonObject.get((Object)"cnf") != null) {
            try {
                cnf = JSONObjectUtils.getJSONObject(jsonObject, "cnf");
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        Map.Entry<String, JSONObject> en = this.toJWTClaim();
        cnf.putAll((Map)en.getValue());
        jsonObject.put((Object)"cnf", (Object)cnf);
    }

    public JWTClaimsSet applyTo(JWTClaimsSet jwtClaimsSet) {
        Map.Entry<String, JSONObject> cnfClaim = this.toJWTClaim();
        return new JWTClaimsSet.Builder(jwtClaimsSet).claim(cnfClaim.getKey(), cnfClaim.getValue()).build();
    }

    public String toString() {
        return this.toJSONObject().toJSONString();
    }

    protected static JSONObject parseConfirmationJSONObject(JWTClaimsSet jwtClaimsSet) {
        Map<String, Object> jsonObjectClaim;
        try {
            jsonObjectClaim = jwtClaimsSet.getJSONObjectClaim("cnf");
        }
        catch (java.text.ParseException e) {
            return null;
        }
        if (jsonObjectClaim == null) {
            return null;
        }
        return new JSONObject(jsonObjectClaim);
    }
}

