/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitIo.conv;

import com.tridium.util.EscUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.driver.point.BProxyConversion;
import javax.baja.driver.point.BProxyExt;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.UnitException;

@NiagaraType
public final class BTabularConversion
extends BProxyConversion {
    private static final String DEFAULT_ENCODING = "Linear|0.0,0.0;100.0,100.0;";
    public static final BTabularConversion NULL = BTabularConversion.make();
    public static final BTabularConversion DEFAULT = BTabularConversion.make("Linear|0.0,0.0;100.0,100.0;");
    public static final Type TYPE = Sys.loadType(BTabularConversion.class);
    private Array<XYPoint> points = new Array(XYPoint.class);
    private double[] srcArray = null;
    private double[] destArray = null;
    private String description = "";
    private int hashCode = -1;

    public Type getType() {
        return TYPE;
    }

    public static BTabularConversion make() {
        return new BTabularConversion();
    }

    public static BTabularConversion make(String desc, Array<XYPoint> pnts) {
        return new BTabularConversion(desc, pnts);
    }

    public static BTabularConversion make(String encoding) {
        try {
            return (BTabularConversion)NULL.decodeFromString(encoding);
        }
        catch (Exception e) {
            return null;
        }
    }

    private BTabularConversion(String desc, Array<XYPoint> pnts) {
        this.description = desc == null ? "" : desc;
        this.points = pnts;
        this.points.sort();
        this.refreshArrays();
    }

    private BTabularConversion() {
    }

    public Array<XYPoint> getPoints() {
        return this.points.copy();
    }

    public String getDescription() {
        return this.description;
    }

    public void convertDeviceToProxy(BProxyExt ext, BStatusValue deviceValue, BStatusValue proxyValue) throws Exception {
        if (deviceValue instanceof BStatusNumeric) {
            if (this.srcArray == null) {
                deviceValue.copyFrom((BComplex)proxyValue);
                throw new UnitException("Not convertible: invalid points table");
            }
            double src = ((BStatusNumeric)deviceValue).getValue();
            double dest = this.convertTo(src, this.srcArray, this.destArray);
            proxyValue.setStatus(deviceValue.getStatus());
            ((BStatusNumeric)proxyValue).setValue(dest);
            return;
        }
        proxyValue.copyFrom((BComplex)deviceValue);
        throw new UnitException("Not convertible: invalid point type");
    }

    public void convertProxyToDevice(BProxyExt ext, BStatusValue proxyValue, BStatusValue deviceValue) throws Exception {
        if (proxyValue instanceof BStatusNumeric) {
            if (this.srcArray == null) {
                deviceValue.copyFrom((BComplex)proxyValue);
                throw new UnitException("Not convertible: invalid points table");
            }
            double dest = ((BStatusNumeric)proxyValue).getValue();
            double src = this.convertTo(dest, this.destArray, this.srcArray);
            deviceValue.setStatus(proxyValue.getStatus());
            ((BStatusNumeric)deviceValue).setValue(src);
            return;
        }
        deviceValue.copyFrom((BComplex)proxyValue);
        throw new UnitException("Not convertible: invalid point type");
    }

    private double convertTo(double src, double[] srcArray, double[] destArray) {
        int band = 0;
        int count = srcArray.length;
        if (src < srcArray[0]) {
            return destArray[0];
        }
        if (src > srcArray[count - 1]) {
            return destArray[count - 1];
        }
        if (src == srcArray[count - 1]) {
            return destArray[count - 1];
        }
        for (int i = 0; i < count - 1; ++i) {
            if (!(src >= srcArray[i]) || !(src < srcArray[i + 1])) continue;
            band = i;
            break;
        }
        double p1 = srcArray[band];
        double p2 = srcArray[band + 1];
        double v1 = destArray[band];
        double v2 = destArray[band + 1];
        return v1 - (p1 - src) * (v1 - v2) / (p1 - p2);
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.encodeToString().hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        BTabularConversion x;
        return obj instanceof BTabularConversion && (x = (BTabularConversion)((Object)obj)).hashCode() == this.hashCode();
    }

    public String toString(Context context) {
        return this.encodeToString();
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    public String encodeToString() {
        StringBuilder sb = new StringBuilder();
        String descriptionx = EscUtil.slot.escape(this.description);
        sb.append(descriptionx).append("|");
        for (int i = 0; i < this.points.size(); ++i) {
            XYPoint p = (XYPoint)this.points.get(i);
            if (i > 0) {
                sb.append(';');
            }
            sb.append(p.x()).append(',').append(p.y());
        }
        return sb.toString();
    }

    public BObject decodeFromString(String src) throws IOException {
        Array arr = new Array(XYPoint.class);
        int last = -1;
        int sep = src.indexOf(124);
        String desc = EscUtil.slot.unescape(src.substring(0, sep));
        last = sep;
        sep = src.indexOf(59);
        while (true) {
            if (sep == -1) break;
            this.decodePoint(src.substring(last + 1, sep), (Array<XYPoint>)arr);
            last = sep;
            sep = src.indexOf(59, last + 1);
        }
        this.decodePoint(src.substring(last + 1), (Array<XYPoint>)arr);
        BTabularConversion conv = BTabularConversion.make(desc, (Array<XYPoint>)arr);
        return conv;
    }

    private void decodePoint(String src, Array<XYPoint> arr) {
        int comma = src.indexOf(44);
        if (comma == -1) {
            return;
        }
        String xstr = src.substring(0, comma).trim();
        String ystr = src.substring(comma + 1).trim();
        if (xstr.length() > 0 && ystr.length() > 0) {
            try {
                double x = Double.parseDouble(xstr);
                double y = Double.parseDouble(ystr);
                arr.add((Object)new XYPoint(x, y));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void refreshArrays() {
        if (this.points.size() >= 2) {
            this.srcArray = new double[this.points.size()];
            this.destArray = new double[this.points.size()];
            for (int i = 0; i < this.points.size(); ++i) {
                XYPoint pnt = (XYPoint)this.points.get(i);
                this.srcArray[i] = pnt.x();
                this.destArray[i] = pnt.y();
            }
        } else {
            this.destArray = null;
            this.srcArray = null;
        }
    }

    public static class XYPoint
    implements Comparable<Object> {
        private double x;
        private double y;

        public XYPoint(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public double x() {
            return this.x;
        }

        public double y() {
            return this.y;
        }

        @Override
        public int compareTo(Object o) {
            if (o instanceof XYPoint) {
                XYPoint p = (XYPoint)o;
                if (p.x > this.x) {
                    return -1;
                }
                if (p.x < this.x) {
                    return 1;
                }
                return 0;
            }
            throw new ClassCastException("object not of type XYPoint.class");
        }

        public boolean equals(Object o) {
            if (o instanceof XYPoint) {
                XYPoint p = (XYPoint)o;
                return this.x == p.x && this.y == p.y;
            }
            return false;
        }

        public int hashCode() {
            return (String.valueOf(this.x) + "," + String.valueOf(this.y)).hashCode();
        }
    }
}

