/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mqttClientDriver.clients.jwt;

import com.tridium.mqttClientDriver.BAbstractMqttDevice;
import com.tridium.mqttClientDriver.authenticator.gcp.BGcpAuthenticator;
import com.tridium.mqttClientDriver.authenticator.gcp.async.Callback;
import com.tridium.mqttClientDriver.clients.INiagaraMqttClient;
import com.tridium.mqttClientDriver.clients.jwt.MqttConnectOptionBuilder;
import com.tridium.mqttClientDriver.util.MqttActions;
import com.tridium.platform.LocalizableConnectException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.sys.BDate;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

public class GcpMqttClient
implements INiagaraMqttClient {
    private final BGcpAuthenticator authenticator;
    private MqttAsyncClient mqttClient;
    private String mqttBridgeHostname;
    private int mqttBridgePort;
    private String clientId;
    protected static final Logger log = BGcpAuthenticator.GCP_LOGGER;

    public GcpMqttClient(BGcpAuthenticator authenticator) {
        this.authenticator = authenticator;
        this.applyOptions(authenticator);
    }

    public void applyOptions(BGcpAuthenticator authenticator) {
        this.mqttBridgeHostname = authenticator.getBrokerEndpoint();
        this.mqttBridgePort = authenticator.getBrokerPort();
        this.clientId = authenticator.getClientID();
    }

    private void googleStyleMqttClient(String serverAddress, String clientId, MqttConnectOptions connectOptions) throws MqttException, InterruptedException {
        MqttClient client = new MqttClient(serverAddress, clientId, new MemoryPersistence());
        long initialConnectIntervalMillis = 500L;
        long maxConnectIntervalMillis = 6000L;
        long maxConnectRetryTimeElapsedMillis = 900000L;
        float intervalMultiplier = 1.5f;
        long retryIntervalMs = initialConnectIntervalMillis;
        long totalRetryTimeMs = 0L;
        while (!client.isConnected() && totalRetryTimeMs < maxConnectRetryTimeElapsedMillis) {
            try {
                client.connect(connectOptions);
            }
            catch (MqttException e) {
                int reason = e.getReasonCode();
                if (log.isLoggable(Level.FINE)) {
                    log.warning("An error occurred: " + e.getMessage());
                }
                if (reason == 32109 || reason == 32103) {
                    if (log.isLoggable(Level.INFO)) {
                        log.info("Retrying in " + (double)retryIntervalMs / 1000.0 + " seconds.");
                    }
                    Thread.sleep(retryIntervalMs);
                    totalRetryTimeMs += retryIntervalMs;
                    if ((retryIntervalMs = (long)((float)retryIntervalMs * intervalMultiplier)) <= maxConnectIntervalMillis) continue;
                    retryIntervalMs = maxConnectIntervalMillis;
                    continue;
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() throws Exception {
        log.fine(() -> String.format("Connecting to %s", this.clientId));
        if (this.authenticator.getEnableExpirationDateOfRsaKeys() && BDate.today().isAfter(this.authenticator.getExpirationDateOfRsaKeys())) {
            if (this.isConnected()) {
                this.mqttClient.disconnect();
            }
            log.warning("The RSA keys has expired, hence cannot connect to the client");
            throw new LocalizableConnectException("abstractMqttDriver", BAbstractMqttDevice.lex.getText("rsaKeyExpired"));
        }
        String mqttServerAddress = String.format("ssl://%s:%s", this.mqttBridgeHostname, this.mqttBridgePort);
        GcpMqttClient gcpMqttClient = this;
        synchronized (gcpMqttClient) {
            try {
                if (this.mqttClient != null && this.mqttClient.isConnected()) {
                    this.mqttClient.disconnect();
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(() -> String.format("Disconnected old connection: %s ", this.clientId));
                    }
                }
                this.mqttClient = this.getNewMqttAsyncClient(mqttServerAddress);
                this.authenticator.executor.newExecutorService(this.clientId);
            }
            catch (Exception e) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.WARNING, String.format("Client %s failed to connect.", this.clientId), e);
                } else {
                    log.warning(() -> String.format("Client %s failed to connect.", this.clientId));
                }
                throw e;
            }
        }
        log.fine(() -> String.format("Client %s is connected.", this.clientId));
    }

    private MqttAsyncClient getNewMqttAsyncClient(String mqttServerAddress) throws Exception {
        MqttConnectOptions mqttConnectOptions = MqttConnectOptionBuilder.build(this.authenticator);
        MqttAsyncClient newMqttClient = new MqttAsyncClient(mqttServerAddress, this.clientId, null);
        newMqttClient.setCallback(this.authenticator.getCallbackRouter());
        IMqttToken token = newMqttClient.connect(mqttConnectOptions);
        token.waitForCompletion();
        return newMqttClient;
    }

    @Override
    public void subscribe(String[] topics, int[] qosList) throws Exception {
        this.authenticator.setCurrentMqttAction(MqttActions.SUBSCRIBEALL);
        this.mqttClient.subscribe(topics, qosList);
        this.authenticator.setCurrentMqttAction(MqttActions.NONE);
    }

    @Override
    public void unsubscribe(String[] topicsArray) throws Exception {
        this.authenticator.setCurrentMqttAction(MqttActions.UNSUBSCRIBEALL);
        this.mqttClient.unsubscribe(topicsArray);
        this.authenticator.setCurrentMqttAction(MqttActions.NONE);
    }

    @Override
    public void disconnect() throws Exception {
        IMqttToken tok = this.mqttClient.disconnect();
        tok.waitForCompletion();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Client:" + this.clientId + " disconnected.");
        }
        this.authenticator.executor.getExecutorService().shutdown();
    }

    @Override
    public Future<String> publish(String topic, int qos, String message, boolean retained) {
        if (this.isConnected()) {
            this.authenticator.setCurrentMqttAction(MqttActions.PUBLISH);
            MqttMessage mqttMessage = new MqttMessage(message.getBytes());
            mqttMessage.setQos(qos);
            mqttMessage.setRetained(retained);
            Future<String> future = this.authenticator.executor.getExecutorService().submit(new Callback.MqttPubCallable(this.mqttClient, mqttMessage, topic));
            this.authenticator.setCurrentMqttAction(MqttActions.NONE);
            return future;
        }
        return null;
    }

    @Override
    public void subscribe(String topic, int qos) throws Exception {
        if (this.isConnected()) {
            this.authenticator.setCurrentMqttAction(MqttActions.SUBSCRIBE);
            IMqttToken tok = this.mqttClient.subscribe(topic, qos);
            tok.waitForCompletion();
            this.authenticator.setCurrentMqttAction(MqttActions.NONE);
        }
    }

    @Override
    public void unsubscribe(String topic) throws Exception {
        if (this.isConnected()) {
            this.authenticator.setCurrentMqttAction(MqttActions.UNSUBSCRIBE);
            IMqttToken tok = this.mqttClient.unsubscribe(topic);
            tok.waitForCompletion();
            this.authenticator.setCurrentMqttAction(MqttActions.NONE);
        }
    }

    @Override
    public boolean isConnected() {
        return this.mqttClient != null && this.mqttClient.isConnected();
    }
}

