/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mqttClientDriver.clients.aws;

import com.amazonaws.services.iot.client.AWSIotConnectionStatus;
import com.amazonaws.services.iot.client.AWSIotMessage;
import com.amazonaws.services.iot.client.AWSIotMqttClient;
import com.amazonaws.services.iot.client.AWSIotQos;
import com.tridium.mqttClientDriver.BAbstractMqttDevice;
import com.tridium.mqttClientDriver.authenticator.IBasicMqttOptions;
import com.tridium.mqttClientDriver.clients.INiagaraMqttClient;
import com.tridium.mqttClientDriver.clients.aws.MqttAwsPubCallable;
import com.tridium.mqttClientDriver.clients.aws.MqttAwsTopic;
import com.tridium.mqttClientDriver.util.MqttActions;
import com.tridium.nre.security.SecretChars;
import com.tridium.nre.util.NamedThreadFactory;
import com.tridium.platcrypto.core.BCertManagerService;
import java.io.IOException;
import java.security.AccessController;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.security.ClientTlsParameters;
import javax.baja.security.BCertificateAliasAndPassword;
import javax.baja.security.BPassword;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.jetty.util.StringUtil;

public class MqttClientAwsIoT
implements INiagaraMqttClient {
    private ThreadPoolExecutor executorService;
    protected static final Logger logger = Logger.getLogger("abstractMqttDriver.mqttClient");
    private final IBasicMqttOptions connectOptions;
    private AWSIotMqttClient awsIotMqttClient;
    private static final int corePoolSize = 1;
    private static final int maximumPoolSize = 5;
    private static final int poolKeepAlive = 500;

    public MqttClientAwsIoT(IBasicMqttOptions connectOptions) {
        this.connectOptions = connectOptions;
    }

    @Override
    public void connect() throws Exception {
        String clientEndpoint = this.connectOptions.getBrokerEndpoint();
        String clientId = this.connectOptions.getClientID();
        BCertificateAliasAndPassword aliasAndPassword = this.connectOptions.getCertificateAliasAndPassword();
        this.awsIotMqttClient = new AWSIotMqttClient(clientEndpoint, clientId, MqttClientAwsIoT.getSocketFactory(aliasAndPassword));
        this.setupClientWithOptions();
        this.awsIotMqttClient.connect();
        String threadName = "MQTTThreadPool-" + clientId;
        this.executorService = new ThreadPoolExecutor(1, 5, 500L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory(threadName));
    }

    private static SSLSocketFactory getSocketFactory(BCertificateAliasAndPassword aliasAndPassword) throws IOException {
        try {
            BCertManagerService certService = (BCertManagerService)Sys.getService((Type)BCertManagerService.TYPE);
            ClientTlsParameters clientTlsParameters = null;
            if (aliasAndPassword != null) {
                clientTlsParameters = new ClientTlsParameters("tlsv1.2", aliasAndPassword.getAlias());
                if (!aliasAndPassword.getPassword().isDefault()) {
                    try (SecretChars passwordChars = AccessController.doPrivileged(() -> ((BPassword)aliasAndPassword.getPassword()).getSecretChars());){
                        clientTlsParameters.setKeyPassphrase(passwordChars.get());
                    }
                }
            } else {
                clientTlsParameters = new ClientTlsParameters("tlsv1.2", null);
            }
            return (SSLSocketFactory)certService.getClientSocketFactory(clientTlsParameters);
        }
        catch (Exception e) {
            throw new IOException("Unable to get client socket factory: " + e.getMessage(), e);
        }
    }

    @Override
    public void disconnect() throws Exception {
        this.awsIotMqttClient.disconnect();
        logger.fine("Client:" + this.connectOptions.getClientID() + " disconnected.");
        this.executorService.shutdown();
    }

    @Override
    public Future<String> publish(String topic, int qos, String message, boolean retained) throws Exception {
        if (this.isConnected()) {
            this.connectOptions.setCurrentMqttAction(MqttActions.PUBLISH);
            Future<String> future = this.executorService.submit(new MqttAwsPubCallable(topic, this.awsIotMqttClient, qos, message));
            this.connectOptions.setCurrentMqttAction(MqttActions.NONE);
            return future;
        }
        return null;
    }

    @Override
    public void subscribe(String topic, int qos) throws Exception {
        if (this.isConnected()) {
            this.connectOptions.setCurrentMqttAction(MqttActions.SUBSCRIBE);
            AWSIotQos awsIotQos = AWSIotQos.valueOf(qos);
            MqttAwsTopic awsTopic = new MqttAwsTopic(topic, awsIotQos, this.executorService, this.connectOptions);
            this.awsIotMqttClient.subscribe(awsTopic);
            this.connectOptions.setCurrentMqttAction(MqttActions.NONE);
        }
    }

    @Override
    public void unsubscribe(String topic) throws Exception {
        if (this.isConnected()) {
            this.connectOptions.setCurrentMqttAction(MqttActions.UNSUBSCRIBE);
            this.awsIotMqttClient.unsubscribe(topic);
            this.connectOptions.setCurrentMqttAction(MqttActions.NONE);
        }
    }

    @Override
    public boolean isConnected() {
        return this.awsIotMqttClient != null && this.awsIotMqttClient.getConnectionStatus() == AWSIotConnectionStatus.CONNECTED;
    }

    @Override
    public void subscribe(String[] topics, int[] qosList) throws Exception {
        throw new LocalizableRuntimeException("Subscribing to multiple topics is not supported for AWS IoT.", null);
    }

    @Override
    public void unsubscribe(String[] topicsArray) throws Exception {
        throw new LocalizableRuntimeException("Unsubscribing from multiple topics is not supported for AWS IoT.", null);
    }

    private void setupClientWithOptions() {
        this.awsIotMqttClient.setCleanSession(((BAbstractMqttDevice)this.connectOptions.getDevice()).getCleanSession());
        this.awsIotMqttClient.setConnectionTimeout(((BAbstractMqttDevice)this.connectOptions.getDevice()).getConnectionTimeout());
        this.awsIotMqttClient.setKeepAliveInterval(((BAbstractMqttDevice)this.connectOptions.getDevice()).getKeepAlive());
        if (!StringUtil.isEmpty((String)((BAbstractMqttDevice)this.connectOptions.getDevice()).getTopicForLWT())) {
            int qos = ((BAbstractMqttDevice)this.connectOptions.getDevice()).getQosForLWT().getOrdinal();
            AWSIotQos awsQos = AWSIotQos.valueOf(qos);
            AWSIotMessage lwtMsg = new AWSIotMessage(((BAbstractMqttDevice)this.connectOptions.getDevice()).getTopicForLWT(), awsQos, ((BAbstractMqttDevice)this.connectOptions.getDevice()).getMessageForLWT());
            this.awsIotMqttClient.setWillMessage(lwtMsg);
        } else {
            logger.log(Level.WARNING, "\"Topic For LWT\" is missing which is a mandatory field to construct the \"will message\" for AWS mqtt client.");
        }
    }
}

