/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mqttClientDriver.clients;

import com.tridium.mqttClientDriver.BAbstractMqttDriverDevice;
import com.tridium.mqttClientDriver.clients.INiagaraMqttClient;
import com.tridium.mqttClientDriver.util.BMqttConnectionType;
import javax.baja.security.BPassword;
import javax.baja.sys.LocalizableRuntimeException;

public class MqttClientValidationsDriverDevice {
    private static final MqttClientValidationsDriverDevice clientValidations = new MqttClientValidationsDriverDevice();

    private MqttClientValidationsDriverDevice() {
    }

    public static MqttClientValidationsDriverDevice getMqttClientValidationsInstance() {
        return clientValidations;
    }

    public boolean validateConnectParams(BAbstractMqttDriverDevice device, INiagaraMqttClient client) {
        if (client != null && client.isConnected()) {
            String message = BAbstractMqttDriverDevice.lex.get("clientAlreadyConnectedConnectionError", null);
            device.setStatusMessage(message);
            return false;
        }
        return true;
    }

    public boolean validateDisconnectParams(BAbstractMqttDriverDevice device, INiagaraMqttClient client) {
        if (client != null && !client.isConnected()) {
            String message = BAbstractMqttDriverDevice.lex.get("clientAlreadyDisconnectedConnectionError");
            device.setStatusMessage(message);
            return false;
        }
        return true;
    }

    public boolean validateMQTTParams(BAbstractMqttDriverDevice device) {
        if (device == null) {
            throw new LocalizableRuntimeException("abstractMqttDriver", "nullBMqttClientDriverDeviceObject");
        }
        String ipAddress = device.getBrokerIpAddress();
        boolean enableLogin = device.getConnectionType() == BMqttConnectionType.UserLoginOverSSL;
        String username = device.getUsernameAndPassword().getUsername();
        BPassword password = device.getUsernameAndPassword().getPassword();
        boolean enableLWT = device.getEnableLWT();
        String topicLWT = device.getTopicForLWT();
        String messageForLWT = device.getMessageForLWT();
        String clientId = device.getClientID();
        if (clientId == null || clientId.isEmpty()) {
            String message = BAbstractMqttDriverDevice.lex.get("emptyClientIdConnectionError");
            device.setStatusMessage(message);
            throw new LocalizableRuntimeException("abstractMqttDriver", "emptyClientIdConnectionError");
        }
        if (ipAddress == null || "".equals(ipAddress)) {
            String message = BAbstractMqttDriverDevice.lex.get("emptyIpAddressConnectionError");
            device.setStatusMessage(message);
            throw new LocalizableRuntimeException("abstractMqttDriver", "emptyIpAddressConnectionError");
        }
        if (enableLogin) {
            if (username == null || "".equals(username)) {
                String message = BAbstractMqttDriverDevice.lex.get("emptyUsernameConnectionError");
                device.setStatusMessage(message);
                throw new LocalizableRuntimeException("abstractMqttDriver", "emptyUsernameConnectionError");
            }
            if (password == BPassword.DEFAULT || password == null || "".equals(password) || password.isNull() || "".equals(password.getValue())) {
                String message = BAbstractMqttDriverDevice.lex.get("emptyPasswordConnectionError");
                device.setStatusMessage(message);
                throw new LocalizableRuntimeException("abstractMqttDriver", "emptyPasswordConnectionError");
            }
        }
        if (enableLWT) {
            if (topicLWT == null || "".equals(topicLWT)) {
                String message = BAbstractMqttDriverDevice.lex.get("emptyTopicForLWTConnectionError");
                device.setStatusMessage(message);
                throw new LocalizableRuntimeException("abstractMqttDriver", "emptyTopicForLWTConnectionError");
            }
            if (messageForLWT == null || "".equals(messageForLWT)) {
                String message = BAbstractMqttDriverDevice.lex.get("emptyMessageForLWTForLWTConnectionError");
                device.setStatusMessage(message);
                throw new LocalizableRuntimeException("abstractMqttDriver", "emptyMessageForLWTForLWTConnectionError");
            }
        }
        if (device.getMqttClientDriverNetwork().clientIdExists(clientId)) {
            String message = BAbstractMqttDriverDevice.lex.get("duplicateClientId");
            device.setStatusMessage(message);
            throw new LocalizableRuntimeException("abstractMqttDriver", "duplicateClientId");
        }
        return true;
    }
}

