/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mqttClientDriver.authenticator.gcp;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.KeyPurpose;
import com.tridium.crypto.core.cert.NKey;
import com.tridium.crypto.core.cert.NX509CertificateBuilder;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.crypto.core.io.ICoreTrustStore;
import com.tridium.mqttClientDriver.BAbstractMqttDevice;
import com.tridium.mqttClientDriver.authenticator.gcp.BGcpAuthenticator;
import com.tridium.mqttClientDriver.authenticator.gcp.BGcpCertificate;
import com.tridium.mqttClientDriver.authenticator.gcp.BToken;
import com.tridium.mqttClientDriver.authenticator.gcp.datatypes.BJwtEncAlgorithm;
import com.tridium.mqttClientDriver.util.jwt.token.TokenFactory;
import com.tridium.sys.Nre;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.spec.X509EncodedKeySpec;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.IX509CertificateEntry;
import javax.baja.security.BCertificateAliasAndPassword;
import javax.baja.security.BPassword;
import javax.baja.security.SecurityAuditEvent;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDate;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.IllegalParentException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="algorithm", type="BJwtEncAlgorithm", defaultValue="BJwtEncAlgorithm.DEFAULT"), @NiagaraProperty(name="validity", type="BRelTime", defaultValue="BRelTime.makeMinutes(20)", facets={@Facet(name="BFacets.UNITS", value="UnitDatabase.getUnit(\"minute\")"), @Facet(name="BFacets.MIN", value="BRelTime.makeMinutes(5)"), @Facet(name="BFacets.MAX", value="BRelTime.makeDays(1)")}), @NiagaraProperty(name="advanceExpiration", type="BRelTime", defaultValue="BRelTime.makeSeconds(10)", facets={@Facet(name="BFacets.UNITS", value="UnitDatabase.getUnit(\"second\")"), @Facet(name="BFacets.MIN", value="BRelTime.makeSeconds(0)"), @Facet(name="BFacets.MAX", value="BRelTime.makeMinutes(1)")}), @NiagaraProperty(name="privateKey", type="BPassword", defaultValue="BPassword.DEFAULT", flags=5), @NiagaraProperty(name="privateKeyExpiration", type="int", defaultValue="1", facets={@Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"year\")"), @Facet(name="BFacets.MIN", value="1"), @Facet(name="BFacets.MAX", value="5")}), @NiagaraProperty(name="certificate", type="BGcpCertificate", defaultValue="new BGcpCertificate()")})
public class BTokenParameters
extends BComponent {
    @Generated
    public static final Property algorithm = BTokenParameters.newProperty((int)0, (BValue)BJwtEncAlgorithm.DEFAULT, null);
    @Generated
    public static final Property validity = BTokenParameters.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)20), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"minute")), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeMinutes((int)5))), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.makeDays((int)1))));
    @Generated
    public static final Property advanceExpiration = BTokenParameters.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)10), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"second")), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)0))), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.makeMinutes((int)1))));
    @Generated
    public static final Property privateKey = BTokenParameters.newProperty((int)5, (BValue)BPassword.DEFAULT, null);
    @Generated
    public static final Property privateKeyExpiration = BTokenParameters.newProperty((int)0, (int)1, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"year")), (BFacets)BFacets.make((String)"min", (int)1)), (BFacets)BFacets.make((String)"max", (int)5)));
    @Generated
    public static final Property certificate = BTokenParameters.newProperty((int)0, (BValue)new BGcpCertificate(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTokenParameters.class);
    private Clock.Ticket reconnectTicket = Clock.expiredTicket;
    private BToken token;
    private PrivateKey pvtKey;
    private static final String DIRECTORY_NAME = "JwtKeys";
    public static final String SERVER_DN = "CN=Niagara4,O=MqttMigrationPurposes,C=US";

    @Generated
    public BJwtEncAlgorithm getAlgorithm() {
        return (BJwtEncAlgorithm)this.get(algorithm);
    }

    @Generated
    public void setAlgorithm(BJwtEncAlgorithm v) {
        this.set(algorithm, (BValue)v, null);
    }

    @Generated
    public BRelTime getValidity() {
        return (BRelTime)this.get(validity);
    }

    @Generated
    public void setValidity(BRelTime v) {
        this.set(validity, (BValue)v, null);
    }

    @Generated
    public BRelTime getAdvanceExpiration() {
        return (BRelTime)this.get(advanceExpiration);
    }

    @Generated
    public void setAdvanceExpiration(BRelTime v) {
        this.set(advanceExpiration, (BValue)v, null);
    }

    @Generated
    public BPassword getPrivateKey() {
        return (BPassword)this.get(privateKey);
    }

    @Generated
    public void setPrivateKey(BPassword v) {
        this.set(privateKey, (BValue)v, null);
    }

    @Generated
    public int getPrivateKeyExpiration() {
        return this.getInt(privateKeyExpiration);
    }

    @Generated
    public void setPrivateKeyExpiration(int v) {
        this.setInt(privateKeyExpiration, v, null);
    }

    @Generated
    public BGcpCertificate getCertificate() {
        return (BGcpCertificate)this.get(certificate);
    }

    @Generated
    public void setCertificate(BGcpCertificate v) {
        this.set(certificate, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void scheduleReconnect() {
        BAbsTime reconnectTime = this.token.getExpires().subtract(this.getAdvanceExpiration());
        this.clearReconnectTicket();
        this.reconnectTicket = Clock.schedule((BComponent)this.getAuthenticator(), (BAbsTime)reconnectTime, (Action)BGcpAuthenticator.reconnect, null);
        if (BGcpAuthenticator.GCP_LOGGER.isLoggable(Level.FINE)) {
            BGcpAuthenticator.GCP_LOGGER.fine(() -> String.format("Scheduled to reconnect at %s and token expiry is at %s", this.reconnectTicket, this.token.getExpires()));
        }
    }

    public void started() throws Exception {
        if (!Flags.has((BComplex)this, (Slot)privateKeyExpiration, (int)0x10000000)) {
            this.getCertificate().getCertAliasAndPassword().setFacets((Slot)BCertificateAliasAndPassword.alias, BFacets.make((BFacets)BCertificateAliasAndPassword.alias.getFacets(), (BFacets)BFacets.make((String)"purposeId", (String)KeyPurpose.CLIENT_CERT.name())));
            this.migrateRSAKeyInKeyStore();
        } else {
            this.pvtKey = this.loadPrivateKey();
        }
        super.started();
    }

    private BAbstractMqttDevice getDevice() {
        return this.getAuthenticator().getMqttDevice();
    }

    private void migrateRSAKeyInKeyStore() {
        if (!this.getPrivateKey().isDefault()) {
            BGcpAuthenticator.GCP_LOGGER.fine(String.format("Migrating RSA key to keystore for device %s", this.getDevice().getDisplayName(null)));
            try {
                String certAlias = this.getDevice().getName().toLowerCase();
                PrivateKey privateKey = this.getPrivateKeyFromPassword();
                PublicKey publicKey = this.getPublicKeyForDevice();
                String newCertAlias = this.setEntryInKeystore(privateKey, publicKey, certAlias, this.getAuthenticator().getCreationDateOfRsaKeys());
                this.getCertificate().getCertAliasAndPassword().setAlias(newCertAlias);
                this.getCertificate().setEnableCerts(true);
                BGcpAuthenticator.GCP_LOGGER.info(String.format("Migrated the RSA key in keystore as %s for device %s", newCertAlias, this.getDevice().getDisplayName(null)));
                this.getAuthenticator().getMqttDevice().setFaultCause("");
                this.getAuthenticator().getMqttDevice().setStatus(BStatus.make((int)(this.getAuthenticator().getMqttDevice().getStatus().getBits() & 0xFFFFFFFD)));
                Flags.add((BComponent)this, (Slot)privateKeyExpiration, null, (int[])new int[]{0x10000005});
                this.setPrivateKey(BPassword.DEFAULT);
                this.pvtKey = this.loadPrivateKey();
            }
            catch (Exception e) {
                BGcpAuthenticator.GCP_LOGGER.log(Level.SEVERE, String.format("%s: %s", this.getDevice().getDisplayName(null), e.getLocalizedMessage()), BGcpAuthenticator.GCP_LOGGER.isLoggable(Level.FINE) ? e : null);
                this.getAuthenticator().getMqttDevice().setFaultCause(e.getLocalizedMessage());
                this.getAuthenticator().getMqttDevice().setStatus(BStatus.make((BStatus)this.getAuthenticator().getMqttDevice().getStatus(), (int)2));
            }
        } else {
            Flags.add((BComponent)this, (Slot)privateKeyExpiration, null, (int[])new int[]{0x10000005});
            this.pvtKey = this.loadPrivateKey();
        }
    }

    private PublicKey getPublicKeyForDevice() throws Exception {
        PublicKey publicKey;
        File jwtKeyFile = new File(this.getDirectoryForJwtKeys(), this.getFileName());
        try (BufferedReader keyReader = Files.newBufferedReader(jwtKeyFile.toPath(), StandardCharsets.UTF_8);
             PemReader pemReader = new PemReader((Reader)keyReader);){
            KeyFactory factory = KeyFactory.getInstance("RSA");
            PemObject pemObject = pemReader.readPemObject();
            if (pemObject == null) {
                throw new BajaRuntimeException("Pem file is empty " + jwtKeyFile.toPath());
            }
            byte[] content = pemObject.getContent();
            X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(content);
            publicKey = factory.generatePublic(pubKeySpec);
        }
        catch (Exception e) {
            throw new LocalizableRuntimeException("abstractMqttDriver", "gcp.migrateRSAKey.publicKeyError", new Object[]{jwtKeyFile.getPath()}, (Throwable)e);
        }
        return publicKey;
    }

    private PrivateKey getPrivateKeyFromPassword() {
        PrivateKey privateKey;
        try {
            String privatePem = AccessController.doPrivileged(() -> ((BPassword)this.getPrivateKey()).getValue());
            privateKey = (PrivateKey)NKey.decodeFromString((String)privatePem);
        }
        catch (Exception e) {
            throw new LocalizableRuntimeException("abstractMqttDriver", "gcp.migrateRSAKey.privateKeyError", (Throwable)e);
        }
        return privateKey;
    }

    private String setEntryInKeystore(PrivateKey privateKey, PublicKey publicKey, String certAlias, BDate creationDateOfRsaKeys) throws Exception {
        String newCertAlias;
        try {
            KeyPair keyPair = new KeyPair(publicKey, privateKey);
            Date notBefore = new Date(BAbsTime.make((BDate)creationDateOfRsaKeys, (BTime)BTime.DEFAULT, (BTimeZone)BTimeZone.DEFAULT).getMillis());
            Date notAfter = Date.from(notBefore.toInstant().atZone(ZoneId.systemDefault()).plusYears(5L).toInstant());
            CoreCryptoManager coreCryptoManager = CoreCryptoManager.get();
            newCertAlias = CertUtils.getUniqueAlias((String)certAlias, (ICoreTrustStore)coreCryptoManager.getKeyStore());
            NX509CertificateBuilder builder = NX509CertificateBuilder.getInstance((KeyPurpose)KeyPurpose.CLIENT_CERT);
            builder.withAlias(newCertAlias).withSubjectDN(SERVER_DN).withIssuerDN(SERVER_DN).withNotBefore(notBefore).withNotAfter(notAfter);
            IX509CertificateEntry serverCertEntry = builder.generateEntry(keyPair);
            coreCryptoManager.getKeyStore().setKeyEntry(newCertAlias, (Key)serverCertEntry.getPrivateKey(), null, serverCertEntry.getCertificates());
            coreCryptoManager.getKeyStore().save();
        }
        catch (Exception e) {
            throw new LocalizableRuntimeException("abstractMqttDriver", "gcp.migrateRSAKey.generateCertificateError", new Object[]{certAlias}, (Throwable)e);
        }
        return newCertAlias;
    }

    private String getFileName() {
        String fileName = this.getDevice().getName();
        return fileName + ".pem";
    }

    private File getDirectoryForJwtKeys() {
        BComplex parent = this.getDevice().getParent();
        StringBuilder path = new StringBuilder();
        path.append(Sys.getStationHome());
        path.append(File.separator);
        path.append(DIRECTORY_NAME);
        path.append(File.separator);
        path.append(this.getDevice().getNetwork().getName());
        ArrayList<String> componentUntilDevice = new ArrayList<String>();
        while (!(parent instanceof BDeviceNetwork)) {
            componentUntilDevice.add(parent.getName());
            parent = parent.getParent();
        }
        int size = componentUntilDevice.size();
        while (size-- > 0) {
            path.append(File.separator);
            path.append((String)componentUntilDevice.get(size));
        }
        File dir = new File(path.toString());
        if (!dir.exists() && dir.mkdirs()) {
            throw new LocalizableRuntimeException("abstractMqttDriver", "gcp.migrateRSAKey.publicKeyError", new Object[]{path.toString()}, (Throwable)new IOException("Failed to create directory" + path));
        }
        return dir;
    }

    public void stopped() throws Exception {
        this.clearReconnectTicket();
        super.stopped();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(validity) || property.equals(privateKey) || property.equals(algorithm) || property.equals(advanceExpiration) || property.equals(certificate)) {
            if (!Flags.has((BComplex)this, (Slot)privateKeyExpiration, (int)0x10000000)) {
                BGcpAuthenticator.GCP_LOGGER.fine(String.format("RSA key is yet to migrate to keystore for %s", this.getDevice().getDisplayName(null)));
                return;
            }
            BGcpAuthenticator.GCP_LOGGER.finest("Restarting connection due to change of " + property.getName());
            this.clearReconnectTicket();
            if (this.token != null) {
                this.token.doReset();
            }
            try {
                this.pvtKey = this.loadPrivateKey();
                this.getDevice().disconnect();
                this.getDevice().connect();
            }
            catch (Exception e) {
                if (BGcpAuthenticator.GCP_LOGGER.isLoggable(Level.FINE)) {
                    BGcpAuthenticator.GCP_LOGGER.warning("The client did not connect. Cause is " + e);
                }
                BGcpAuthenticator.GCP_LOGGER.warning("The client did not connect. Cause is " + e.getMessage());
            }
        }
        if (property.equals(privateKeyExpiration)) {
            this.resetExpirationDateOfKeys();
        }
    }

    private void resetExpirationDateOfKeys() {
        BDate creationDateOfKeys;
        if (Flags.has((BComplex)this, (Slot)privateKeyExpiration, (int)0x10000000)) {
            return;
        }
        BDate expirationDateofKeys = creationDateOfKeys = this.getAuthenticator().getCreationDateOfRsaKeys();
        for (int i = 0; i < this.getPrivateKeyExpiration(); ++i) {
            expirationDateofKeys = expirationDateofKeys.nextYear();
        }
        if (expirationDateofKeys.isBefore(BDate.today())) {
            BGcpAuthenticator.GCP_LOGGER.warning("The date has already passed. Please select correct year.");
        } else {
            this.getAuthenticator().setExpirationDateOfRsaKeys(expirationDateofKeys);
        }
    }

    private void clearReconnectTicket() {
        if (this.reconnectTicket != null && !this.reconnectTicket.isExpired()) {
            this.reconnectTicket.cancel();
            this.reconnectTicket = Clock.expiredTicket;
        }
    }

    public void addTokenAsPassword(MqttConnectOptions options) {
        this.generateNewToken();
        options.setPassword(this.token.getToken().toCharArray());
    }

    private PrivateKey loadPrivateKey() {
        BGcpAuthenticator.GCP_LOGGER.log(Level.FINE, "loading private key...");
        PrivateKey key = null;
        try {
            if (this.getPrivateKey().isDefault()) {
                this.getCertificate().setEnableCerts(true);
            }
            if (!this.getCertificate().getEnableCerts()) {
                String privatePem = AccessController.doPrivileged(() -> ((BPassword)this.getPrivateKey()).getValue());
                key = (PrivateKey)NKey.decodeFromString((String)privatePem);
            } else {
                CoreCryptoManager localCoreCryptoManager = CoreCryptoManager.get();
                X509Certificate certificate = localCoreCryptoManager.getKeyStore().getCertificate(this.getCertificate().getCertAliasAndPassword().getAlias());
                if (certificate == null) {
                    throw new BajaRuntimeException(String.format("Failed to load certificate %s from keystore for device %s", this.getCertificate().getCertAliasAndPassword().getAlias(), this.getDevice().getDisplayName(null)));
                }
                this.getAuthenticator().setCreationDateOfRsaKeys(BAbsTime.make((long)certificate.getNotBefore().getTime()).getDate());
                this.getAuthenticator().setExpirationDateOfRsaKeys(BAbsTime.make((long)certificate.getNotAfter().getTime()).getDate());
                if (localCoreCryptoManager.getCryptoManagerVersion().compareTo((Object)ICoreCryptoManager.ADVANCED_CERT_GEN_VERSION) >= 0) {
                    String certPassword = !this.getCertificate().getCertAliasAndPassword().getPassword().isDefault() ? AccessController.doPrivileged(() -> ((BPassword)this.getCertificate().getCertAliasAndPassword().getPassword()).getValue()) : null;
                    key = (PrivateKey)localCoreCryptoManager.getKeyStore().getKey(this.getCertificate().getCertAliasAndPassword().getAlias(), certPassword != null ? certPassword.toCharArray() : null);
                } else {
                    key = (PrivateKey)localCoreCryptoManager.getKeyStore().getKey(this.getCertificate().getCertAliasAndPassword().getAlias(), null);
                }
            }
            this.getAuthenticator().getMqttDevice().setFaultCause("");
            this.getAuthenticator().getMqttDevice().setStatus(BStatus.make((int)(this.getAuthenticator().getMqttDevice().getStatus().getBits() & 0xFFFFFFFD)));
        }
        catch (Exception e) {
            BGcpAuthenticator.GCP_LOGGER.log(Level.WARNING, e.getLocalizedMessage(), BGcpAuthenticator.GCP_LOGGER.isLoggable(Level.FINE) ? e : null);
            this.getAuthenticator().getMqttDevice().setFaultCause(BAbstractMqttDevice.lex.get("gcp.privateKeyError"));
            this.getAuthenticator().getMqttDevice().setStatus(BStatus.make((BStatus)this.getAuthenticator().getMqttDevice().getStatus(), (int)2));
        }
        return key;
    }

    private void generateNewToken() {
        if (this.pvtKey == null) {
            throw new LocalizableRuntimeException("abstractMqttDriver", "gcp.privateKeyError");
        }
        try {
            this.token = TokenFactory.update(this.token, this.pvtKey, this.getValidity(), this.getAlgorithm(), this.getAuthenticator().getGcpIotParameters().getProjectId());
            Nre.getSecurityAuditor().audit(new SecurityAuditEvent("Token generation", this.getAuthenticator().getClientID(), "A new token has been generated"));
        }
        catch (Exception e) {
            LocalizableRuntimeException localizableRuntimeException = new LocalizableRuntimeException("abstractMqttDriver", "gcp.jwt.token.error", (Throwable)e);
            BGcpAuthenticator.GCP_LOGGER.log(Level.WARNING, e.getLocalizedMessage(), BGcpAuthenticator.GCP_LOGGER.isLoggable(Level.FINE) ? e : null);
            throw localizableRuntimeException;
        }
    }

    public BGcpAuthenticator getAuthenticator() {
        return (BGcpAuthenticator)this.getParent();
    }

    public boolean isNavChild() {
        return false;
    }

    public boolean isParentLegal(BComponent parent) {
        boolean valid = parent.getType().is(BGcpAuthenticator.TYPE);
        if (!valid) {
            throw new IllegalParentException(TYPE.getModule().getModuleName(), "parent.TokenParameters", null);
        }
        return true;
    }

    public BIcon getIcon() {
        return BIcon.std((String)"clock.png");
    }
}

