/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mqttClientDriver.authenticator.gcp;

import com.tridium.mqttClientDriver.authenticator.gcp.BGcpAuthenticator;
import com.tridium.mqttClientDriver.authenticator.gcp.BTokenParameters;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.IllegalParentException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="generated", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=11, facets={@Facet(name="BFacets.SHOW_MILLISECONDS", value="true")}), @NiagaraProperty(name="expires", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=11, facets={@Facet(name="BFacets.SHOW_MILLISECONDS", value="true")})})
@NiagaraAction(name="reset", flags=388)
public class BToken
extends BComponent {
    @Generated
    public static final Property generated = BToken.newProperty((int)11, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showMilliseconds", (boolean)true));
    @Generated
    public static final Property expires = BToken.newProperty((int)11, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showMilliseconds", (boolean)true));
    @Generated
    public static final Action reset = BToken.newAction((int)388, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BToken.class);
    private String currentToken = "";
    private static final String UNKNOWN_TOKEN = "";

    @Generated
    public BAbsTime getGenerated() {
        return (BAbsTime)this.get(generated);
    }

    @Generated
    public void setGenerated(BAbsTime v) {
        this.set(generated, (BValue)v, null);
    }

    @Generated
    public BAbsTime getExpires() {
        return (BAbsTime)this.get(expires);
    }

    @Generated
    public void setExpires(BAbsTime v) {
        this.set(expires, (BValue)v, null);
    }

    @Generated
    public void reset() {
        this.invoke(reset, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BToken() {
    }

    public BToken(BAbsTime generated, BAbsTime expiring, String token) {
        this.updateToken(generated, expiring, token);
    }

    public void updateToken(BAbsTime generated, BAbsTime expiring, String token) {
        this.setGenerated(generated);
        this.setExpires(expiring);
        this.currentToken = token;
    }

    public void doReset() {
        BGcpAuthenticator.GCP_LOGGER.fine(() -> String.format("Resetting Token, Generated:%s Expires:%s", this.getGenerated(), this.getExpires()));
        this.currentToken = UNKNOWN_TOKEN;
        this.setGenerated((BAbsTime)generated.getDefaultValue());
        this.setExpires((BAbsTime)expires.getDefaultValue());
    }

    protected final String getToken() {
        return this.currentToken;
    }

    public boolean isValid() {
        boolean valid;
        if (this.currentToken == null || this.currentToken.isEmpty()) {
            valid = false;
            BGcpAuthenticator.GCP_LOGGER.finest(() -> "Token invalid");
        } else {
            BRelTime advanceExpiration = this.getTokenParameters().getAdvanceExpiration();
            BAbsTime timeOfExpiration = this.getExpires().subtract(advanceExpiration).add(BRelTime.SECOND);
            valid = BAbsTime.now().isBefore(timeOfExpiration);
        }
        return valid;
    }

    public boolean isParentLegal(BComponent parent) {
        boolean valid = parent.getType().is(BGcpAuthenticator.TYPE);
        if (!valid) {
            throw new IllegalParentException(TYPE.getModule().getModuleName(), "parent.Token", null);
        }
        return true;
    }

    public BTokenParameters getTokenParameters() {
        return (BTokenParameters)this.getParent();
    }

    public boolean isNavChild() {
        return false;
    }

    public BIcon getIcon() {
        return BIcon.std((String)"lock.png");
    }
}

