/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mqttClientDriver.authenticator.gcp;

import com.tridium.mqttClientDriver.BAbstractMqttDevice;
import com.tridium.mqttClientDriver.authenticator.IBasicMqttOptions;
import com.tridium.mqttClientDriver.authenticator.gcp.BTokenParameters;
import com.tridium.mqttClientDriver.authenticator.gcp.datatypes.BGcpIotParameters;
import com.tridium.mqttClientDriver.clients.INiagaraMqttClient;
import com.tridium.mqttClientDriver.clients.jwt.GcpMqttClient;
import com.tridium.mqttClientDriver.util.jwt.MqttCallExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.mqttClientDriver.authenticator.BAbstractMqttAuthenticator;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.crypto.BSslTlsEnum;
import javax.baja.security.dashboard.BISecurityDashboardProvider;
import javax.baja.security.dashboard.BISecurityDashboardProviderAgent;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDate;
import javax.baja.sys.BFacets;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="clientID", type="String", defaultValue="", flags=1, override=true), @NiagaraProperty(name="sslVersion", type="BSslTlsEnum", defaultValue="BSslTlsEnum.tlsv1_2", flags=1), @NiagaraProperty(name="creationDateOfRsaKeys", type="BDate", defaultValue="BDate.NULL", flags=5), @NiagaraProperty(name="enableExpirationDateOfRsaKeys", type="boolean", defaultValue="true", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="expirationDateOfRsaKeys", type="BDate", defaultValue="BDate.NULL", flags=1, facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="maxInFlight", type="int", defaultValue="1000", flags=4), @NiagaraProperty(name="gcpIotParameters", type="BGcpIotParameters", defaultValue="new BGcpIotParameters()"), @NiagaraProperty(name="tokenParameters", type="BTokenParameters", defaultValue="new BTokenParameters()")})
@NiagaraActions(value={@NiagaraAction(name="generateRsaKeys", flags=148), @NiagaraAction(name="reconnect", flags=16)})
public class BGcpAuthenticator
extends BAbstractMqttAuthenticator
implements IBasicMqttOptions,
BISecurityDashboardProviderAgent,
BISecurityDashboardProvider {
    @Generated
    public static final Property clientID = BGcpAuthenticator.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property sslVersion = BGcpAuthenticator.newProperty((int)1, (BValue)BSslTlsEnum.tlsv1_2, null);
    @Generated
    public static final Property creationDateOfRsaKeys = BGcpAuthenticator.newProperty((int)5, (BValue)BDate.NULL, null);
    @Generated
    public static final Property enableExpirationDateOfRsaKeys = BGcpAuthenticator.newProperty((int)0, (boolean)true, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property expirationDateOfRsaKeys = BGcpAuthenticator.newProperty((int)1, (BValue)BDate.NULL, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property maxInFlight = BGcpAuthenticator.newProperty((int)4, (int)1000, null);
    @Generated
    public static final Property gcpIotParameters = BGcpAuthenticator.newProperty((int)0, (BValue)new BGcpIotParameters(), null);
    @Generated
    public static final Property tokenParameters = BGcpAuthenticator.newProperty((int)0, (BValue)new BTokenParameters(), null);
    @Generated
    public static final Action generateRsaKeys = BGcpAuthenticator.newAction((int)148, null);
    @Generated
    public static final Action reconnect = BGcpAuthenticator.newAction((int)16, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BGcpAuthenticator.class);
    private final GcpMqttClient mqttClientGoogle = new GcpMqttClient(this);
    public final MqttCallExecutor executor = new MqttCallExecutor();
    private static final int THIRTY_DAYS = 30;
    private static final int FIFTEEN_DAYS = 15;
    public static final Logger GCP_LOGGER = Logger.getLogger("abstractMqttDriver.GcpAuth");

    @Generated
    public BSslTlsEnum getSslVersion() {
        return (BSslTlsEnum)this.get(sslVersion);
    }

    @Generated
    public void setSslVersion(BSslTlsEnum v) {
        this.set(sslVersion, (BValue)v, null);
    }

    @Generated
    public BDate getCreationDateOfRsaKeys() {
        return (BDate)this.get(creationDateOfRsaKeys);
    }

    @Generated
    public void setCreationDateOfRsaKeys(BDate v) {
        this.set(creationDateOfRsaKeys, (BValue)v, null);
    }

    @Generated
    public boolean getEnableExpirationDateOfRsaKeys() {
        return this.getBoolean(enableExpirationDateOfRsaKeys);
    }

    @Generated
    public void setEnableExpirationDateOfRsaKeys(boolean v) {
        this.setBoolean(enableExpirationDateOfRsaKeys, v, null);
    }

    @Generated
    public BDate getExpirationDateOfRsaKeys() {
        return (BDate)this.get(expirationDateOfRsaKeys);
    }

    @Generated
    public void setExpirationDateOfRsaKeys(BDate v) {
        this.set(expirationDateOfRsaKeys, (BValue)v, null);
    }

    @Generated
    public int getMaxInFlight() {
        return this.getInt(maxInFlight);
    }

    @Generated
    public void setMaxInFlight(int v) {
        this.setInt(maxInFlight, v, null);
    }

    @Generated
    public BGcpIotParameters getGcpIotParameters() {
        return (BGcpIotParameters)this.get(gcpIotParameters);
    }

    @Generated
    public void setGcpIotParameters(BGcpIotParameters v) {
        this.set(gcpIotParameters, (BValue)v, null);
    }

    @Generated
    public BTokenParameters getTokenParameters() {
        return (BTokenParameters)this.get(tokenParameters);
    }

    @Generated
    public void setTokenParameters(BTokenParameters v) {
        this.set(tokenParameters, (BValue)v, null);
    }

    @Generated
    public void generateRsaKeys() {
        this.invoke(generateRsaKeys, null, null);
    }

    @Generated
    public void reconnect() {
        this.invoke(reconnect, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public INiagaraMqttClient connect(BAbstractMqttDevice device) throws Exception {
        if (!this.mqttClientGoogle.isConnected() && !device.isFatalFault()) {
            this.mqttClientGoogle.applyOptions(this);
            this.mqttClientGoogle.connect();
            this.getTokenParameters().scheduleReconnect();
        }
        return this.mqttClientGoogle;
    }

    @Override
    public void disconnect() throws Exception {
        if (this.mqttClientGoogle.isConnected()) {
            this.mqttClientGoogle.disconnect();
        } else {
            GCP_LOGGER.warning("GcpAuthenticator could not disconnect as mqttclient is not currently connected");
        }
    }

    @Override
    public void enableAndDisableFields(int flag) {
        ((BAbstractMqttDevice)this.getDevice()).enableAndDisableFields(flag);
        this.setFlags((Slot)brokerEndpoint, flag);
        this.setFlags((Slot)brokerPort, flag);
    }

    public void doReconnect() {
        if (this.isRunning() && this.getMqttDevice().getEnabled()) {
            Thread reconnectThread = new Thread(() -> {
                if (GCP_LOGGER.isLoggable(Level.FINE)) {
                    GCP_LOGGER.fine(() -> String.format("Reconnecting %s", this.getMqttDevice().getName()));
                }
                this.mqttClientGoogle.applyOptions(this);
                try {
                    this.mqttClientGoogle.connect();
                    this.getTokenParameters().scheduleReconnect();
                    String message = BAbstractMqttDevice.lex.get("connected");
                    this.getMqttDevice().setStatusMessage(message);
                    this.getMqttDevice().pingOk();
                }
                catch (Exception e) {
                    this.getMqttDevice().setStatusMessage(BAbstractMqttDevice.lex.get("disconnected"));
                    this.getMqttDevice().pingFail(BAbstractMqttDevice.lex.get("disconnected"));
                    GCP_LOGGER.log(Level.SEVERE, "Failed to reconnect. Initiating a new connection", e);
                    this.getMqttDevice().connect();
                }
            });
            reconnectThread.setName("GcpAuthenticator: Reconnect");
            reconnectThread.start();
        }
    }

    public void doGenerateRsaKeys() throws Exception {
        throw new LocalizableRuntimeException("abstractMqttDriver", "gcp.certificate.generation.notSupported");
    }

    public void started() throws Exception {
        if (this.isRunning()) {
            GCP_LOGGER.fine(() -> "Linking to clientId: " + this.getGcpIotParameters().getClientId());
            this.linkTo(this.getGcpIotParameters(), (Slot)BGcpIotParameters.clientId, (Slot)clientID);
        }
        super.started();
    }

    public boolean isParentLegal(BComponent parent) {
        return parent.getType().is(BAbstractMqttDevice.TYPE);
    }

    public GcpMqttClient getMqttClient() {
        return this.mqttClientGoogle;
    }

    public BAbstractMqttDevice getMqttDevice() {
        return (BAbstractMqttDevice)this.getDevice();
    }

    public LexiconFormatInfo getSecurityDashboardSectionHeader(Context cx) {
        return LexiconFormatInfo.make((Type)TYPE, (String)"securityDashboard.sectionHeader");
    }

    public BOrd getSecurityDashboardSectionHyperlinkOrd() {
        return this.getNavOrd().relativizeToSession();
    }

    public int getSecurityDashboardItemsVersion() {
        return 1;
    }

    public List<SecurityDashboardItem> getSecurityDashboardItems(Context cx) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        this.addAuthenticatorKeysItems(items, cx);
        return items;
    }

    private void addAuthenticatorKeysItems(List<SecurityDashboardItem> items, Context cx) {
        BDate expirationDateOfKeys = this.getExpirationDateOfRsaKeys();
        if (!this.getEnableExpirationDateOfRsaKeys()) {
            items.add(SecurityDashboardItem.makeAlert((Type)TYPE, (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)"securityDashboard.jwtKeysExpiryDisabled.summary", (BSimple[])new BSimple[]{BString.make((String)this.getDevice().getDisplayName(cx)), BString.make((String)expirationDateOfKeys.toString(cx))}), (String)"securityDashboard.jwtKeysExpiryDisabled.description"));
        } else if (BDate.today().isAfter(expirationDateOfKeys)) {
            items.add(SecurityDashboardItem.makeAlert((Type)TYPE, (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)"securityDashboard.jwtKeysExpired.summary", (BSimple[])new BSimple[]{BString.make((String)this.getDevice().getDisplayName(cx)), BString.make((String)expirationDateOfKeys.toString(cx))}), (String)"securityDashboard.jwtKeysExpired.description"));
        } else if (Math.abs(expirationDateOfKeys.delta(BDate.today())) <= 15) {
            items.add(SecurityDashboardItem.makeAlert((Type)TYPE, (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)"securityDashboard.jwtKeysExpiry.summary", (BSimple[])new BSimple[]{BString.make((String)this.getDevice().getDisplayName(cx)), BString.make((String)expirationDateOfKeys.toString(cx))}), (String)"securityDashboard.jwtKeysExpiry.description"));
        } else if (Math.abs(expirationDateOfKeys.delta(BDate.today())) <= 30) {
            items.add(SecurityDashboardItem.makeWarning((Type)TYPE, (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)"securityDashboard.jwtKeysExpiry.summary", (BSimple[])new BSimple[]{BString.make((String)this.getDevice().getDisplayName(cx)), BString.make((String)expirationDateOfKeys.toString(cx))}), (String)"securityDashboard.jwtKeysExpiry.description"));
        } else {
            items.add(SecurityDashboardItem.makeOk((Type)TYPE, (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)"securityDashboard.jwtKeysValid.summary", (BSimple[])new BSimple[]{BString.make((String)this.getDevice().getDisplayName(cx)), BString.make((String)expirationDateOfKeys.toString(cx))}), (String)"securityDashboard.jwtKeysValid.description"));
        }
    }
}

