/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mqttClientDriver.authenticator.aws;

import com.tridium.crypto.core.cert.KeyPurpose;
import com.tridium.crypto.core.cert.PemSource;
import com.tridium.mqttClientDriver.BAbstractMqttDevice;
import com.tridium.mqttClientDriver.authenticator.aws.BAwsMqttAuthenticator;
import com.tridium.nre.security.SigningPasswordPermission;
import com.tridium.platcrypto.signing.BAbstractSigningRequester;
import com.tridium.platcrypto.signing.BRequesterState;
import com.tridium.platcrypto.signing.IRequesterComponent;
import com.tridium.signing.fox.BFoxSigningRequester;
import java.security.AccessController;
import java.security.Permission;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BCertificateAliasAndPassword;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.security.auth.x500.X500Principal;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="certificateAliasAndPassword", type="BCertificateAliasAndPassword", defaultValue="BCertificateAliasAndPassword.DEFAULT", flags=64, facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}, override=true), @NiagaraProperty(name="clientID", type="String", defaultValue="BString.DEFAULT", flags=65, override=true), @NiagaraProperty(name="certRequester", type="BAbstractSigningRequester", defaultValue="new BFoxSigningRequester()"), @NiagaraProperty(name="autoOnboard", type="boolean", defaultValue="false", flags=4), @NiagaraProperty(name="autoOnboardComment", type="String", defaultValue="BString.make(DEFAULT_COMMENT)", flags=4)})
@NiagaraAction(name="attemptAutoOnboard", flags=4)
public class BAwsJitpMqttAuthenticator
extends BAwsMqttAuthenticator
implements IRequesterComponent {
    private static final String DEFAULT_COMMENT = Lexicon.make((String)"platCrypto").getText("signingRequester.defaultOnboardingComment");
    @Generated
    public static final Property certificateAliasAndPassword = BAwsJitpMqttAuthenticator.newProperty((int)64, (BValue)BCertificateAliasAndPassword.DEFAULT, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property clientID = BAwsJitpMqttAuthenticator.newProperty((int)65, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property certRequester = BAwsJitpMqttAuthenticator.newProperty((int)0, (BValue)new BFoxSigningRequester(), null);
    @Generated
    public static final Property autoOnboard = BAwsJitpMqttAuthenticator.newProperty((int)4, (boolean)false, null);
    @Generated
    public static final Property autoOnboardComment = BAwsJitpMqttAuthenticator.newProperty((int)4, (BValue)BString.make((String)DEFAULT_COMMENT), null);
    @Generated
    public static final Action attemptAutoOnboard = BAwsJitpMqttAuthenticator.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAwsJitpMqttAuthenticator.class);
    public static final String ALIAS_PREFIX = "aws";
    private static final String AWS_MQTT_PORT_PROP = "mqtt.aws.port";
    private static final int AWS_MQTT_PORT = System.getProperty("mqtt.aws.port") != null ? Integer.parseInt(System.getProperty("mqtt.aws.port")) : 8883;

    @Generated
    public BAbstractSigningRequester getCertRequester() {
        return (BAbstractSigningRequester)this.get(certRequester);
    }

    @Generated
    public void setCertRequester(BAbstractSigningRequester v) {
        this.set(certRequester, (BValue)v, null);
    }

    @Generated
    public boolean getAutoOnboard() {
        return this.getBoolean(autoOnboard);
    }

    @Generated
    public void setAutoOnboard(boolean v) {
        this.setBoolean(autoOnboard, v, null);
    }

    @Generated
    public String getAutoOnboardComment() {
        return this.getString(autoOnboardComment);
    }

    @Generated
    public void setAutoOnboardComment(String v) {
        this.setString(autoOnboardComment, v, null);
    }

    @Generated
    public void attemptAutoOnboard() {
        this.invoke(attemptAutoOnboard, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    void fwStarted() {
        this.getCertificateAliasAndPassword().setFacets((Slot)BCertificateAliasAndPassword.alias, BFacets.make((String)"purposeId", (String)KeyPurpose.CLIENT_CERT.name()));
        if (this.getBrokerPort() == 1883) {
            this.setBrokerPort(AWS_MQTT_PORT);
        }
        this.generateAlias();
    }

    public void descendantsStarted() throws Exception {
        this.doAttemptAutoOnboard();
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BAbstractMqttDevice;
    }

    public void changed(Property property, Context context) {
        if (this.isRunning() && (property.equals(certificateAliasAndPassword) || property.equals(clientID)) && this.getAutoOnboard() && this.requesterOnboarded() && !this.getParentDevice().isClientConnectedToBroker()) {
            this.getParentDevice().connect();
        }
    }

    public BPassword supplyCertificatePassword() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SigningPasswordPermission(TYPE.getTypeSpec().getModuleName()));
        }
        return BPassword.make((String)AccessController.doPrivileged(() -> this.getCertificateAliasAndPassword().getPassword().getValue()));
    }

    public boolean requiresCertificateParameterTemplates() {
        return true;
    }

    public void certificateSigned(X509Certificate[] certificateChain) {
        if (certificateChain.length > 0) {
            X509Certificate deviceCert = certificateChain[0];
            X500Principal subjectPrincipal = deviceCert.getSubjectX500Principal();
            String commonName = PemSource.extractCommonName((X500Principal)subjectPrincipal);
            if (commonName != null) {
                this.setClientID(commonName);
            } else {
                LOG.warning("Client Id could not be set, no common name in device certificate");
            }
        } else {
            LOG.warning("Client Id could not be set, no device certificate found");
        }
    }

    private void generateAlias() {
        if ("default".equals(this.getCertificateAliasAndPassword().getAlias()) && this.isRunning()) {
            String alias = "aws-" + this.getParentDevice().getName();
            this.getCertificateAliasAndPassword().setAlias(alias);
        }
    }

    public void doAttemptAutoOnboard() {
        if (this.isRunning() && this.getAutoOnboard() && !this.getCertificateAliasAndPassword().getAlias().isEmpty() && this.requesterRequiresOnboarding()) {
            String comment;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this.getDevice().getName() + " performing auto onboard");
            }
            if ((comment = this.getAutoOnboardComment()).isEmpty() || comment.equals(DEFAULT_COMMENT)) {
                comment = BAbstractMqttDevice.lex.getText("aws.auto.onboard.message", new Object[]{Sys.getStation().getStationName(), BAbsTime.now()});
            }
            this.getCertRequester().onboard(BString.make((String)comment));
        }
    }

    private boolean requesterRequiresOnboarding() {
        BRequesterState state = this.getCertRequester().getRequesterState();
        return this.getClientID().isEmpty() && state.equals((Object)BRequesterState.notOnboarded);
    }

    private boolean requesterOnboarded() {
        return !this.getCertificateAliasAndPassword().getAlias().isEmpty() && this.getCertRequester().getRequesterState().equals((Object)BRequesterState.onboarded);
    }

    private BAbstractMqttDevice getParentDevice() {
        return (BAbstractMqttDevice)this.getParent().as(BAbstractMqttDevice.class);
    }
}

