/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mqttClientDriver;

import com.tridium.mqttClientDriver.BAbstractMqttDevice;
import com.tridium.mqttClientDriver.BAbstractMqttDriverDevice;
import com.tridium.mqttClientDriver.BAbstractMqttDriverDeviceFolder;
import com.tridium.mqttClientDriver.IBaseMqttDevice;
import com.tridium.mqttClientDriver.util.BMqttWorker;
import com.tridium.ndriver.BNDevice;
import com.tridium.ndriver.BNNetwork;
import com.tridium.ndriver.poll.BNPollScheduler;
import com.tridium.nre.platform.PlatformUtil;
import java.security.AccessController;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.baja.agent.AgentList;
import javax.baja.license.Feature;
import javax.baja.mqttClientDriver.authenticator.BAbstractMqttAuthenticator;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="pollScheduler", type="BNPollScheduler", defaultValue="new BNPollScheduler()"), @NiagaraProperty(name="worker", type="BMqttWorker", defaultValue="new BMqttWorker()", flags=4), @NiagaraProperty(name="supervisorDeviceLimit", type="int", defaultValue="50", flags=4, facets={@Facet(name="BFacets.MIN", value="1"), @Facet(name="BFacets.MAX", value="500")})})
@NiagaraActions(value={@NiagaraAction(name="subscribeAll", flags=16), @NiagaraAction(name="unsubscribeAll", flags=16)})
public class BAbstractMqttDriverNetwork
extends BNNetwork {
    @Generated
    public static final Property pollScheduler = BAbstractMqttDriverNetwork.newProperty((int)0, (BValue)new BNPollScheduler(), null);
    @Generated
    public static final Property worker = BAbstractMqttDriverNetwork.newProperty((int)4, (BValue)new BMqttWorker(), null);
    @Generated
    public static final Property supervisorDeviceLimit = BAbstractMqttDriverNetwork.newProperty((int)4, (int)50, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)1), (BFacets)BFacets.make((String)"max", (int)500)));
    @Generated
    public static final Action subscribeAll = BAbstractMqttDriverNetwork.newAction((int)16, null);
    @Generated
    public static final Action unsubscribeAll = BAbstractMqttDriverNetwork.newAction((int)16, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAbstractMqttDriverNetwork.class);
    private HashSet<String> clientIdList = new HashSet();
    private final int MQTT_DEVICE_LIMIT = 25;
    private int deviceCounter = 0;
    private int supervisor_DeviceCounter = 0;
    public static final Lexicon lex = Lexicon.make((String)"abstractMqttDriver");
    protected static final Logger logger = Logger.getLogger("abstractMqttDriver.mqttClient");
    private final Object lock = new Object();

    @Generated
    public BNPollScheduler getPollScheduler() {
        return (BNPollScheduler)this.get(pollScheduler);
    }

    @Generated
    public void setPollScheduler(BNPollScheduler v) {
        this.set(pollScheduler, (BValue)v, null);
    }

    @Generated
    public BMqttWorker getWorker() {
        return (BMqttWorker)this.get(worker);
    }

    @Generated
    public void setWorker(BMqttWorker v) {
        this.set(worker, (BValue)v, null);
    }

    @Generated
    public int getSupervisorDeviceLimit() {
        return this.getInt(supervisorDeviceLimit);
    }

    @Generated
    public void setSupervisorDeviceLimit(int v) {
        this.setInt(supervisorDeviceLimit, v, null);
    }

    @Generated
    public void subscribeAll() {
        this.invoke(subscribeAll, null, null);
    }

    @Generated
    public void unsubscribeAll() {
        this.invoke(unsubscribeAll, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public String getNetworkName() {
        return "AbstractMqttDriverNetwork";
    }

    public Type getDeviceFolderType() {
        return BAbstractMqttDriverDeviceFolder.TYPE;
    }

    public Type getDeviceType() {
        return BAbstractMqttDevice.TYPE;
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "mqtt");
    }

    public final AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        list.remove("ndriver:NDeviceManager");
        return list;
    }

    public boolean addUniqueClientId(String clientId) {
        return this.clientIdList.add(clientId);
    }

    public boolean clientIdExists(String clientId) {
        return this.clientIdList.contains(clientId);
    }

    public boolean removeClientIdFromList(String clientId) {
        return this.clientIdList.remove(clientId);
    }

    private static int getDeviceLimit() {
        String limitStr = lex.getText("mqtt.device.limit");
        int limit = 0;
        try {
            limit = Integer.parseInt(limitStr);
        }
        catch (Exception e) {
            limit = AccessController.doPrivileged(() -> Integer.getInteger("mqtt.MQTT_DEVICE_LIMIT", 25));
            logger.warning("The value passed for device limit is not in correct format");
        }
        return limit;
    }

    public void removed(Property property, BValue oldValue, Context context) {
        BNDevice device;
        BValue value = this.get(property);
        if (value instanceof BAbstractMqttDevice) {
            BAbstractMqttAuthenticator authenticator;
            device = (BAbstractMqttDevice)value;
            if (device.isClientConnectedToBroker()) {
                device.doDisconnect();
            }
            if ((authenticator = device.getAuthenticator(false)) != null) {
                authenticator.preRemove();
            }
        }
        if (value instanceof BAbstractMqttDriverDevice && (device = (BAbstractMqttDriverDevice)value).isClientConnectedToBroker()) {
            device.doDisconnect();
        }
        super.removed(property, oldValue, context);
    }

    public void changed(Property property, Context context) {
        block6: {
            super.changed(property, context);
            if (property != enabled || !this.isRunning()) break block6;
            BValue value = this.get(property);
            if (value instanceof BAbstractMqttDevice) {
                for (BAbstractMqttDevice device : (BAbstractMqttDevice[])this.getChildren(BAbstractMqttDevice.class)) {
                    if (!this.getEnabled() && device.isClientConnectedToBroker()) {
                        device.disconnectClient();
                        continue;
                    }
                    if (!this.getEnabled() || device.isClientConnectedToBroker() || !device.getEnabled()) continue;
                    device.doConnect();
                }
            } else {
                for (BAbstractMqttDriverDevice device : (BAbstractMqttDriverDevice[])this.getChildren(BAbstractMqttDriverDevice.class)) {
                    if (!this.getEnabled() && device.isClientConnectedToBroker()) {
                        device.disconnectClient();
                        continue;
                    }
                    if (!this.getEnabled() || device.isClientConnectedToBroker() || !device.getEnabled()) continue;
                    device.doConnect();
                }
            }
        }
    }

    public void doSubscribeAll() {
        for (IBaseMqttDevice device : (IBaseMqttDevice[])this.getChildren(IBaseMqttDevice.class)) {
            device.doSubscribeAll();
        }
    }

    public void doUnsubscribeAll() {
        for (IBaseMqttDevice device : (IBaseMqttDevice[])this.getChildren(IBaseMqttDevice.class)) {
            device.doUnsubscribeAll();
        }
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        this.getWorker().postAsync((Runnable)new Invocation((BComponent)this, action, argument, cx));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String incrementDeviceCount() {
        if (LocalMetaDataHolder.IS_EMBEDDED) {
            Object object = this.lock;
            synchronized (object) {
                ++this.deviceCounter;
            }
            if (this.deviceCounter > 25) {
                return lex.getText("exceededDeviceLimit", new Object[]{25});
            }
        } else {
            Object object = this.lock;
            synchronized (object) {
                ++this.supervisor_DeviceCounter;
            }
            if (this.supervisor_DeviceCounter > this.getSupervisorDeviceLimit()) {
                return lex.getText("exceededDeviceLimit", new Object[]{this.getSupervisorDeviceLimit()});
            }
        }
        return null;
    }

    private static final class LocalMetaDataHolder {
        private static final boolean IS_EMBEDDED = AccessController.doPrivileged(() -> PlatformUtil.getPlatformProvider().isEmbedded());

        private LocalMetaDataHolder() {
        }
    }
}

