/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.client.mqtt;

import com.amazonaws.services.iot.client.AWSIotMessage;
import com.amazonaws.services.iot.client.core.AbstractAwsIotClient;
import java.util.logging.Logger;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttSuback;

public class AwsIotMqttMessageListener
implements IMqttActionListener {
    private static final Logger LOGGER = Logger.getLogger(AwsIotMqttMessageListener.class.getName());
    private static final int SUB_ACK_RETURN_CODE_FAILURE = 128;
    private AbstractAwsIotClient client;

    public AwsIotMqttMessageListener(AbstractAwsIotClient client) {
        this.client = client;
    }

    @Override
    public void onSuccess(IMqttToken token) {
        final AWSIotMessage message = (AWSIotMessage)token.getUserContext();
        if (message == null) {
            return;
        }
        boolean forceFailure = false;
        if (token.getResponse() instanceof MqttSuback) {
            MqttSuback subAck = (MqttSuback)token.getResponse();
            int[] qos = subAck.getGrantedQos();
            for (int i = 0; i < qos.length; ++i) {
                if (qos[i] != 128) continue;
                LOGGER.warning("Request failed: likely due to too many subscriptions or policy violations");
                forceFailure = true;
                break;
            }
        }
        final boolean isSuccess = !forceFailure;
        this.client.scheduleTask(new Runnable(){

            @Override
            public void run() {
                if (isSuccess) {
                    message.onSuccess();
                } else {
                    message.onFailure();
                }
            }
        });
    }

    @Override
    public void onFailure(IMqttToken token, Throwable cause) {
        final AWSIotMessage message = (AWSIotMessage)token.getUserContext();
        if (message == null) {
            LOGGER.warning("Request failed: " + token.getException());
            return;
        }
        LOGGER.warning("Request failed for topic " + message.getTopic() + ": " + token.getException());
        this.client.scheduleTask(new Runnable(){

            @Override
            public void run() {
                message.onFailure();
            }
        });
    }
}

