/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sms.util;

import com.tridium.sms.BSmsMessage;
import com.tridium.sms.SmsException;
import javax.baja.nre.util.Array;

public final class ParseReadMsgs {
    private char[] data;
    private int index;
    private char c0;
    private char c1;
    private char c2;
    private char c3;
    private char c4;
    private char c5;
    private char c6;
    private char c7;
    private boolean foundOk = false;
    private Array<BSmsMessage> readMsgs = new Array(BSmsMessage.class);

    private ParseReadMsgs(String str) {
        this.data = str.toCharArray();
        this.index = -1;
    }

    public static BSmsMessage[] parse(String s) throws SmsException {
        ParseReadMsgs p = new ParseReadMsgs(s);
        p.process();
        return (BSmsMessage[])p.readMsgs.trim();
    }

    private boolean advance() {
        ++this.index;
        if (this.index >= this.data.length) {
            return false;
        }
        this.c7 = this.c6;
        this.c6 = this.c5;
        this.c5 = this.c4;
        this.c4 = this.c3;
        this.c3 = this.c2;
        this.c2 = this.c1;
        this.c1 = this.c0;
        this.c0 = this.data[this.index];
        return true;
    }

    private boolean checkAdvance() throws SmsException {
        boolean b = this.advance();
        if (!b) {
            this.error("Error reading message. Message incomplete");
        }
        return b;
    }

    private boolean verify(char a, char b) throws SmsException {
        if (a != b) {
            StringBuilder buff = new StringBuilder();
            buff.append("Error reading message. Verification error. ");
            buff.append(" Char A: ");
            buff.append(a);
            buff.append(" Does not match Char B: ");
            buff.append(b);
            this.error(buff.toString());
        }
        return true;
    }

    private void error(String errorMsg) throws SmsException {
        StringBuilder buff = new StringBuilder();
        buff.append(errorMsg);
        buff.append("\n");
        buff.append(" Index: ");
        buff.append(this.index);
        buff.append("\n");
        buff.append(" Read so far: ");
        if (this.index < this.data.length) {
            buff.append(new String(this.data).substring(this.index));
        } else {
            buff.append(new String(this.data));
        }
        buff.append("\n");
        throw new SmsException(buff.toString());
    }

    private void process() throws SmsException {
        while (this.advance()) {
            if (this.isMessage()) {
                this.processMessage();
            }
            if (!this.foundOk()) continue;
            return;
        }
        this.error("Invalid Message. No OK!");
    }

    private void processMessage() throws SmsException {
        StringBuilder idBuff = new StringBuilder();
        while (this.checkAdvance() && this.c0 != ',') {
            if (this.c0 == ' ') continue;
            idBuff.append(this.c0);
        }
        BSmsMessage msg = new BSmsMessage();
        msg.setId(Integer.parseInt(idBuff.toString()));
        while (this.checkAdvance() && this.c0 != ',') {
        }
        StringBuilder phoneBuff = new StringBuilder();
        while (this.checkAdvance() && this.c0 != ',') {
            if (this.c0 == '\"') continue;
            phoneBuff.append(this.c0);
        }
        msg.setPhoneNumbers(phoneBuff.toString());
        while (this.checkAdvance() && this.c0 != '\r') {
        }
        this.checkAdvance();
        this.verify(this.c0, '\n');
        StringBuilder msgBuff = new StringBuilder();
        while (this.checkAdvance()) {
            if (this.foundOk()) {
                msgBuff.delete(msgBuff.length() - 5, msgBuff.length());
                break;
            }
            if (this.isMessage()) {
                msgBuff.delete(msgBuff.length() - 7, msgBuff.length());
                break;
            }
            msgBuff.append(this.c0);
        }
        msg.setMessage(msgBuff.toString());
        this.readMsgs.add((Object)msg);
        if (!this.foundOk()) {
            this.processMessage();
        }
    }

    private boolean isMessage() {
        return !(this.c7 != '\r' || this.c6 != '\n' || this.c5 != '+' || this.c4 != 'C' && this.c4 != 'c' || this.c3 != 'M' && this.c3 != 'm' || this.c2 != 'G' && this.c2 != 'g' || this.c1 != 'L' && this.c1 != 'l' || this.c0 != ':');
    }

    private boolean foundOk() {
        if (!this.foundOk) {
            this.foundOk = !(this.c5 != '\r' || this.c4 != '\n' || this.c3 != 'O' && this.c3 != 'o' || this.c2 != 'K' && this.c2 != 'k' || this.c1 != '\r' || this.c0 != '\n');
        }
        return this.foundOk;
    }
}

