/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sms.serial;

import com.tridium.sms.serial.CommTransaction;
import com.tridium.sms.util.SmsToolkit;
import java.io.InputStream;
import java.util.logging.Level;
import javax.baja.nre.util.ByteBuffer;

final class SmsCommReceiver
implements Runnable {
    private InputStream in = null;
    private boolean cancelled = false;
    private CommTransaction commTransaction = null;
    private static final byte[] linetermbytes = new byte[]{13, 10};
    private final ByteBuffer rcvBuffer = new ByteBuffer();

    SmsCommReceiver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (SmsToolkit.log.isLoggable(Level.FINE)) {
            SmsToolkit.log.fine("SmsCommReceiver thread started");
        }
        while (!this.isCancelled()) {
            try {
                String recStr = this.receive();
                if (recStr == null) continue;
                SmsCommReceiver smsCommReceiver = this;
                synchronized (smsCommReceiver) {
                    if (this.commTransaction != null) {
                        this.commTransaction.check(recStr);
                    }
                }
            }
            catch (Exception e) {
                SmsToolkit.log.log(Level.SEVERE, "Cancelling Sms CommReceiver", e);
            }
        }
        if (SmsToolkit.log.isLoggable(Level.FINE)) {
            SmsToolkit.log.fine("SmsCommReceiver thread shutdown");
        }
    }

    String receive() throws Exception {
        block9: {
            this.rcvBuffer.reset();
            try {
                boolean done = false;
                while (!done) {
                    InputStream inStr = this.getInputStream();
                    if (inStr != null) {
                        int charIn = inStr.read();
                        if (charIn != -1) {
                            this.rcvBuffer.write((int)((byte)(charIn &= 0xFF)));
                            if (this.rcvBuffer.endsWith(linetermbytes)) {
                                if (SmsToolkit.log.isLoggable(Level.FINE)) {
                                    this.rcvBuffer.dump();
                                }
                                return new String(this.rcvBuffer.toByteArray());
                            }
                        } else {
                            done = true;
                        }
                    } else {
                        done = true;
                    }
                    if (!this.isCancelled()) continue;
                    break;
                }
            }
            catch (Exception e) {
                if (!SmsToolkit.log.isLoggable(Level.FINE)) break block9;
                SmsToolkit.log.log(Level.FINE, "Error in receive method for CommReceiver", e);
            }
        }
        return new String(this.rcvBuffer.toByteArray());
    }

    synchronized InputStream getInputStream() {
        return this.in;
    }

    synchronized void setInputStream(InputStream in) {
        this.in = in;
    }

    synchronized boolean isCancelled() {
        return this.cancelled;
    }

    synchronized void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    synchronized void setTransaction(CommTransaction commTransaction) {
        this.commTransaction = commTransaction;
    }
}

