/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sms.gprs.command;

import com.tridium.sms.gprs.BGprsSmsTransport;
import com.tridium.sms.serial.command.SmsCommand;
import com.tridium.sms.util.SmsToolkit;
import java.util.logging.Level;
import javax.baja.sys.BRelTime;

public final class GprsSmsSendMsgCommand
extends SmsCommand {
    private String telephoneNum = "";
    private String message = "";
    private static final int MAX_MESSAGE_LENGTH = 140;

    public GprsSmsSendMsgCommand(SmsCommand.ICommsImplementer comms, String newTelephoneNum, String newMessage) {
        super(comms);
        this.telephoneNum = newTelephoneNum;
        this.message = newMessage;
    }

    @Override
    public boolean doRun() {
        boolean success;
        block6: {
            success = false;
            if (!(this.comms instanceof BGprsSmsTransport)) {
                if (SmsToolkit.log.isLoggable(Level.FINE)) {
                    SmsToolkit.log.fine("GprsSmsSendMsgCommand.execute: transport is not gprs transport");
                }
                return false;
            }
            BGprsSmsTransport transport = (BGprsSmsTransport)this.comms;
            int to = transport.getSmsWriteResponseTimeout().getSeconds();
            if (this.message.length() > 140) {
                this.message = this.message.substring(0, 139);
            }
            try {
                this.comms.write("AT+CMGS=" + this.telephoneNum + "|" + this.message + "|" + to, "+cmgs:", BRelTime.makeSeconds((int)(to + 2)));
                success = true;
                if (SmsToolkit.log.isLoggable(Level.FINE)) {
                    SmsToolkit.log.fine("GprsSmsSendMsgCommand.execute(CommsManager): We have successfully sent the text message!");
                }
            }
            catch (Exception e) {
                if (!SmsToolkit.log.isLoggable(Level.FINE)) break block6;
                SmsToolkit.log.fine("GprsSmsSendMsgCommand.execute(CommsManager): Failed to send message through SMS manager");
            }
        }
        return success;
    }

    public String toString() {
        return SmsToolkit.getText("gprsSmsCommand.send");
    }
}

