/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sms;

import com.tridium.sms.BSmsMessage;
import com.tridium.sms.BSmsService;
import com.tridium.sms.util.SmsToolkit;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusString;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="phoneNumbers", type="BStatusString", defaultValue="new BStatusString()", flags=8, facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"sms:PhoneNumbersFE\"))")}), @NiagaraProperty(name="defaultMessage", type="BFormat", defaultValue="BFormat.make(\"default message\")")})
@NiagaraActions(value={@NiagaraAction(name="sendDefaultMessage", flags=16), @NiagaraAction(name="sendMessage", parameterType="BString", defaultValue="BString.make(\"\")", flags=16, facets={@Facet(value="BFacets.make(BFacets.MULTI_LINE, BBoolean.make(true))")})})
public final class BSms
extends BComponent {
    @Generated
    public static final Property phoneNumbers = BSms.newProperty((int)8, (BValue)new BStatusString(), (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"sms:PhoneNumbersFE")));
    @Generated
    public static final Property defaultMessage = BSms.newProperty((int)0, (BValue)BFormat.make((String)"default message"), null);
    @Generated
    public static final Action sendDefaultMessage = BSms.newAction((int)16, null);
    @Generated
    public static final Action sendMessage = BSms.newAction((int)16, (BValue)BString.make((String)""), (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.make((boolean)true)));
    @Generated
    public static final Type TYPE = Sys.loadType(BSms.class);
    private static final BIcon icon = BIcon.make((String)"module://sms/res/sms.png");

    @Generated
    public BStatusString getPhoneNumbers() {
        return (BStatusString)this.get(phoneNumbers);
    }

    @Generated
    public void setPhoneNumbers(BStatusString v) {
        this.set(phoneNumbers, (BValue)v, null);
    }

    @Generated
    public BFormat getDefaultMessage() {
        return (BFormat)this.get(defaultMessage);
    }

    @Generated
    public void setDefaultMessage(BFormat v) {
        this.set(defaultMessage, (BValue)v, null);
    }

    @Generated
    public void sendDefaultMessage() {
        this.invoke(sendDefaultMessage, null, null);
    }

    @Generated
    public void sendMessage(BString parameter) {
        this.invoke(sendMessage, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void doSendDefaultMessage() {
        this.doSendMessage(BString.make((String)""));
    }

    public void doSendMessage(BString arg) {
        String newMsgStr = arg.getString();
        if (newMsgStr.length() <= 0) {
            newMsgStr = this.getDefaultMessage().format((Object)this);
        }
        BSms.sendSMSMessage(this.getPhoneNumbers().getValue(), newMsgStr);
    }

    public static void sendSMSMessage(String phoneNumbers, String message) {
        BSmsService service = BSmsService.getService();
        if (service != null) {
            if (SmsToolkit.log.isLoggable(Level.FINE)) {
                SmsToolkit.log.fine("BSms.sendSMSMessage(String): With arg: " + message);
            }
            try {
                if (SmsToolkit.log.isLoggable(Level.FINE)) {
                    SmsToolkit.log.fine("BSms.sendSMSMessage(String): About to send text message");
                }
                service.send(new BSmsMessage(phoneNumbers, message));
            }
            catch (Exception e) {
                SmsToolkit.log.log(Level.SEVERE, "BSms.sendSMSMessage(String): Error sending message. Exception thrown", e);
            }
        } else {
            SmsToolkit.log.log(Level.SEVERE, "BSms.sendSMSMessage(String): Could not find valid Sms service object");
        }
    }

    public BIcon getIcon() {
        return icon;
    }
}

