/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndriver.comm.udp;

import com.tridium.driver.util.DrByteArrayUtil;
import com.tridium.ndriver.comm.ILinkLayer;
import com.tridium.ndriver.comm.LinkMessage;
import com.tridium.ndriver.comm.NComm;
import com.tridium.ndriver.comm.NLinkMessageFactory;
import com.tridium.ndriver.datatypes.BCommConfig;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.ndriver.datatypes.BUdpCommConfig;
import com.tridium.ndriver.util.SpyUtil;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.spy.SpyWriter;

public class UdpLinkLayer
implements ILinkLayer {
    private Logger log;
    private NComm comm;
    private BUdpCommConfig udpComCfg;
    private InetAddress ia;
    private int port;
    private NLinkMessageFactory lnkFac;
    private DatagramSocket udpSock = null;
    private boolean done = true;
    private Statistics stats = new Statistics();
    LinkReceive receive = null;
    Thread rcvThread;

    public UdpLinkLayer(NComm comm, BUdpCommConfig comCfg) {
        this.comm = comm;
        this.udpComCfg = comCfg;
        this.lnkFac = comCfg.getLinkMessageFactory();
    }

    @Override
    public void start() throws Exception {
        this.log().fine("start UdpLinkLayer");
        this.done = false;
        this.udpSock = this.createSocket(this.udpComCfg);
        this.receive = new LinkReceive();
        this.rcvThread = new Thread((Runnable)this.receive, this.udpComCfg.getResourcePrefix() + ".LinkReceive");
        this.rcvThread.start();
    }

    private DatagramSocket createSocket(BUdpCommConfig cfg) throws Exception {
        this.ia = UdpLinkLayer.ipAddr(cfg);
        this.port = UdpLinkLayer.udpPort(cfg);
        if (this.port > 0) {
            if (this.ia != null) {
                return new DatagramSocket(this.port, this.ia);
            }
            return new DatagramSocket(this.port);
        }
        return new DatagramSocket();
    }

    @Override
    public void stop() {
        try {
            this.done = true;
            if (this.udpSock != null) {
                this.udpSock.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public synchronized void verifySettings(BCommConfig comCfg) throws Exception {
        BUdpCommConfig cfg = (BUdpCommConfig)comCfg;
        InetAddress cfgIa = UdpLinkLayer.ipAddr(cfg);
        if (this.udpSock == null || this.port != UdpLinkLayer.udpPort(cfg) || this.ia == null && cfgIa != null || this.ia != null && !this.ia.equals(cfgIa)) {
            DatagramSocket s = this.udpSock;
            this.udpSock = this.createSocket(cfg);
            if (s != null) {
                s.close();
            }
        }
    }

    private static int udpPort(BUdpCommConfig cfg) {
        return cfg.getAddress().getPort();
    }

    private static InetAddress ipAddr(BUdpCommConfig cfg) {
        BIpAddress myAdr = cfg.getAddress();
        if (myAdr.getIpAddress().equalsIgnoreCase("local")) {
            return null;
        }
        return myAdr.getInetAddress();
    }

    @Override
    public synchronized void sendMessage(LinkMessage msg) throws Exception {
        if (this.done) {
            return;
        }
        if (this.log().isLoggable(Level.FINE)) {
            this.log().fine("send packet to " + msg.address + "\n\n" + DrByteArrayUtil.toString((byte[])msg.getByteArray(), (int)msg.getLength()) + "\n");
        }
        BIpAddress ipAdr = (BIpAddress)((Object)msg.address);
        DatagramPacket pack = new DatagramPacket(msg.getByteArray(), msg.getLength(), ipAdr.getInetAddress(), ipAdr.getPort());
        this.udpSock.send(pack);
        ++this.stats.msgSent;
    }

    @Override
    public void spy(SpyWriter out) throws Exception {
        out.startProps("UdpLinkLayer");
        out.prop((Object)"done", this.done);
        out.prop((Object)"srvSock inet address", (Object)(this.udpSock != null && this.udpSock.getInetAddress() != null ? this.udpSock.getInetAddress().toString() : "n/a"));
        out.prop((Object)"srvSock port", (Object)(this.udpSock != null ? Integer.toString(this.udpSock.getLocalPort()) : "n/a"));
        out.endProps();
        SpyUtil.spy(out, "UdpLink Statistics", this.stats);
    }

    @Override
    public void resetStats() {
        this.stats = new Statistics();
    }

    public final Logger log() {
        if (this.log == null) {
            this.log = Logger.getLogger(this.udpComCfg.getResourcePrefix() + ".Link");
        }
        return this.log;
    }

    public static class Statistics {
        public long msgSent = 0L;
        public long msgReceived = 0L;
        public long receiveError = 0L;
    }

    private class LinkReceive
    implements Runnable {
        private LinkReceive() {
        }

        @Override
        public void run() {
            while (!UdpLinkLayer.this.done) {
                try {
                    LinkMessage lmsg = UdpLinkLayer.this.lnkFac.getLinkMessage();
                    byte[] a = lmsg.getByteArray();
                    DatagramPacket p = new DatagramPacket(a, a.length);
                    UdpLinkLayer.this.udpSock.receive(p);
                    lmsg.setLength(p.getLength());
                    lmsg.address = new BIpAddress(p.getAddress(), p.getPort());
                    if (UdpLinkLayer.this.log().isLoggable(Level.FINE)) {
                        UdpLinkLayer.this.log().fine("received packet from " + lmsg.address + " \n\n" + DrByteArrayUtil.toString((byte[])lmsg.getByteArray(), (int)p.getLength()) + "\n");
                    }
                    UdpLinkLayer.this.comm.receiveMessage(lmsg);
                    ++((UdpLinkLayer)UdpLinkLayer.this).stats.msgReceived;
                }
                catch (Throwable e) {
                    if (UdpLinkLayer.this.done) {
                        return;
                    }
                    UdpLinkLayer.this.log().severe("Exception caught in LinkReceiver. " + e);
                    if (UdpLinkLayer.this.log().isLoggable(Level.FINE)) {
                        UdpLinkLayer.this.log().log(Level.FINE, "Caused by ", e);
                    }
                    ++((UdpLinkLayer)UdpLinkLayer.this).stats.receiveError;
                    if (!UdpLinkLayer.this.udpComCfg.getReconnectOnFailure()) continue;
                    try {
                        if (UdpLinkLayer.this.udpSock != null) {
                            UdpLinkLayer.this.udpSock.close();
                        }
                        UdpLinkLayer.this.udpSock = UdpLinkLayer.this.createSocket(UdpLinkLayer.this.udpComCfg);
                    }
                    catch (Exception e1) {
                        UdpLinkLayer.this.log().severe("Could not reinitialize socket connection: " + e1.getMessage());
                        if (!UdpLinkLayer.this.log().isLoggable(Level.FINE)) continue;
                        UdpLinkLayer.this.log().log(Level.FINE, "Caused by ", e1);
                    }
                }
            }
        }
    }
}

