/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndriver.comm.serial;

import com.tridium.driver.util.DrByteArrayUtil;
import com.tridium.ndriver.comm.DebugStream;
import com.tridium.ndriver.comm.ILinkLayer;
import com.tridium.ndriver.comm.LinkMessage;
import com.tridium.ndriver.comm.NComm;
import com.tridium.ndriver.comm.NCommException;
import com.tridium.ndriver.comm.NLinkMessageFactory;
import com.tridium.ndriver.datatypes.BCommConfig;
import com.tridium.ndriver.datatypes.BSerialCommConfig;
import com.tridium.ndriver.util.SpyUtil;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.serial.BISerialPort;
import javax.baja.serial.BISerialService;
import javax.baja.serial.PortDeniedException;
import javax.baja.serial.PortNotFoundException;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class SerialLinkLayer
implements ILinkLayer {
    DebugStream debIn;
    private Logger log;
    private NComm comm;
    private BSerialCommConfig serCfg;
    private NLinkMessageFactory lnkFac;
    private BISerialPort port = null;
    private String portName = "";
    private Statistics stats = new Statistics();
    private volatile int state = 1;
    private static final int UNAVAILABLE = 1;
    private static final int RECEIVING = 2;
    private static final int TUNNEL_WAIT = 3;
    private static final int TUNNELING = 4;
    private static final int DONE = 5;
    LinkReceive receive = null;
    Thread rcvThread;

    public SerialLinkLayer(NComm comm, BSerialCommConfig serCfg) {
        this.comm = comm;
        this.serCfg = serCfg;
        this.lnkFac = serCfg.getLinkMessageFactory();
        this.debIn = new DebugStream(this.lnkFac.getLinkMaxLength());
    }

    @Override
    public void start() throws Exception {
        this.log().fine("start SerialLinkLayer");
        this.state = 1;
        this.receive = new LinkReceive();
        this.rcvThread = new Thread((Runnable)this.receive, this.serCfg.getResourcePrefix() + ".LinkReceive");
        this.rcvThread.start();
        this.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        try {
            this.state = 5;
            LinkReceive linkReceive = this.receive;
            synchronized (linkReceive) {
                this.receive.notifyAll();
            }
            this.closePort();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public synchronized void verifySettings(BCommConfig comCfg) throws Exception {
        this.serCfg = (BSerialCommConfig)comCfg;
        if (this.port == null || !this.portName.equals(this.serCfg.getPortName())) {
            this.stop();
            this.start();
        } else if (!(this.port.getFlowControlMode().equals((Object)this.serCfg.getFlowControlMode()) && this.port.getBaudRate().equals((Object)this.serCfg.getBaudRate()) && this.port.getDataBits().equals((Object)this.serCfg.getDataBits()) && this.port.getStopBits().equals((Object)this.serCfg.getStopBits()) && this.port.getParity().equals((Object)this.serCfg.getParity()))) {
            this.setCommParams();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open() throws Exception {
        BISerialService platSvc = (BISerialService)Sys.getService((Type)BISerialService.TYPE);
        ((BComponent)platSvc).lease();
        try {
            this.portName = this.serCfg.getPortName();
            if (this.portName.equals("none")) {
                throw new BajaRuntimeException("comm port not initialized");
            }
            this.port = platSvc.openPort(this.portName, this.serCfg.getResourcePrefix());
        }
        catch (PortNotFoundException notPort) {
            String errMsg = "'" + this.serCfg.getPortName() + "' not a valid comm port.";
            this.reportFault(errMsg, (Exception)((Object)notPort));
        }
        catch (PortDeniedException deniedPort) {
            String errMsg = "Denied opening comm port '" + this.serCfg.getPortName() + "'";
            this.reportFault(errMsg, (Exception)((Object)deniedPort));
        }
        catch (Exception e) {
            String errMsg = "Exception opening comm port '" + this.serCfg.getPortName() + "'";
            this.reportFault(errMsg, e);
        }
        this.setCommParams();
        LinkReceive linkReceive = this.receive;
        synchronized (linkReceive) {
            this.state = 2;
            this.receive.notify();
        }
    }

    private void setCommParams() throws Exception {
        String errMsg;
        try {
            this.port.setSerialPortParams(this.serCfg.getBaudRate(), this.serCfg.getDataBits(), this.serCfg.getStopBits(), this.serCfg.getParity());
            this.port.setFlowControlMode(this.serCfg.getFlowControlMode());
        }
        catch (UnsupportedOperationException unsupported) {
            errMsg = "Unsupported comm parameter for " + this.serCfg.getPortName();
            this.reportFault(errMsg, unsupported);
        }
        catch (Exception e) {
            errMsg = "Exception setting comm parameters for " + this.serCfg.getPortName();
            this.reportFault(errMsg, e);
        }
        try {
            int tmo = this.serCfg.getReceiveTimeout();
            if (tmo == 0) {
                this.port.disableReceiveTimeout();
            } else {
                this.port.enableReceiveTimeout(tmo);
            }
        }
        catch (UnsupportedOperationException e) {
            errMsg = "Can't set receiveTimeout on " + this.serCfg.getPortName();
            this.reportFault(errMsg, e);
        }
    }

    private void reportFault(String errMsg, Exception ex) throws Exception {
        this.log().log(Level.SEVERE, errMsg, ex);
        this.state = 1;
        this.closePort();
        throw ex;
    }

    private void closePort() {
        if (this.rcvThread != null) {
            this.rcvThread.interrupt();
        }
        this.rcvThread = null;
        if (this.port == null) {
            return;
        }
        try {
            this.port.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.port = null;
    }

    @Override
    public synchronized void sendMessage(LinkMessage msg) throws Exception {
        if (this.state == 3 || this.state == 4) {
            throw new NCommException("Link layer blocked for tunneling.");
        }
        if (this.state != 2) {
            throw new NCommException("Link layer in fault state.");
        }
        if (this.log().isLoggable(Level.FINE)) {
            this.log().fine("send:" + DrByteArrayUtil.toString((byte[])msg.getByteArray(), (int)msg.getLength()));
        }
        this.receive.initRcvMsg(msg);
        this.port.getOutputStream().write(msg.getByteArray(), 0, msg.getLength());
        ++this.stats.msgSent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BISerialPort tunnelLock() {
        LinkReceive linkReceive = this.receive;
        synchronized (linkReceive) {
            if (this.state != 2) {
                return null;
            }
            this.state = 3;
            while (this.state != 4 && this.state != 5) {
                try {
                    this.receive.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            ++this.stats.tunnelSessions;
            if (this.state == 5) {
                return null;
            }
        }
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock() {
        LinkReceive linkReceive = this.receive;
        synchronized (linkReceive) {
            if (this.state != 5) {
                this.state = 2;
                this.receive.notify();
            }
        }
    }

    @Override
    public void spy(SpyWriter out) throws Exception {
        out.startProps("SerialLinkLayer");
        out.prop((Object)"state", (Object)this.stateToString());
        out.endProps();
        SpyUtil.spy(out, "SerialLink Statistics", this.stats);
    }

    private String stateToString() {
        switch (this.state) {
            case 1: {
                return "UNAVAILABLE";
            }
            case 2: {
                return "RECEIVING";
            }
            case 3: {
                return "TUNNEL_WAIT";
            }
            case 4: {
                return "TUNNELING";
            }
            case 5: {
                return "DONE";
            }
        }
        return "Unknown state " + Integer.toString(this.state);
    }

    @Override
    public void resetStats() {
        this.stats = new Statistics();
    }

    public final Logger log() {
        if (this.log == null) {
            if (this.serCfg == null) {
                return Logger.getLogger(".SerialLink");
            }
            this.log = Logger.getLogger(this.serCfg.getResourcePrefix() + ".Link");
        }
        return this.log;
    }

    public static class Statistics {
        public long msgSent = 0L;
        public long msgReceived = 0L;
        public long receiveError = 0L;
        public long tunnelSessions = 0L;
    }

    private class LinkReceive
    implements Runnable {
        private LinkMessage currRcvMsg = null;

        private LinkReceive() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (SerialLinkLayer.this.state != 5) {
                try {
                    LinkReceive linkReceive = this;
                    synchronized (linkReceive) {
                        if (SerialLinkLayer.this.state == 3) {
                            SerialLinkLayer.this.state = 4;
                            this.notify();
                        }
                        while (SerialLinkLayer.this.state != 2 && SerialLinkLayer.this.state != 5) {
                            this.wait();
                        }
                    }
                    if (SerialLinkLayer.this.state == 5) break;
                    boolean trace = SerialLinkLayer.this.log().isLoggable(Level.FINE);
                    LinkMessage lmsg = SerialLinkLayer.this.lnkFac.getLinkMessage();
                    this.setCurrRcvMsg(lmsg);
                    InputStream in = SerialLinkLayer.this.port.getInputStream();
                    if (trace) {
                        in = SerialLinkLayer.this.debIn.reset(in);
                    }
                    boolean complete = lmsg.receive(in);
                    this.setCurrRcvMsg(null);
                    if (trace && SerialLinkLayer.this.debIn.hasDebug()) {
                        SerialLinkLayer.this.log().fine("rcvd:" + (complete ? "" : "frag:") + SerialLinkLayer.this.debIn.debugString());
                    }
                    if (complete) {
                        SerialLinkLayer.this.comm.receiveMessage(lmsg);
                        ++((SerialLinkLayer)SerialLinkLayer.this).stats.msgReceived;
                        continue;
                    }
                    SerialLinkLayer.this.lnkFac.releaseLinkMessage(lmsg);
                }
                catch (Throwable e) {
                    if (SerialLinkLayer.this.state == 5) {
                        return;
                    }
                    SerialLinkLayer.this.log().log(Level.SEVERE, "Exception caught in LinkReceiver", e);
                    ++((SerialLinkLayer)SerialLinkLayer.this).stats.receiveError;
                }
            }
        }

        synchronized void setCurrRcvMsg(LinkMessage lmsg) {
            this.currRcvMsg = lmsg;
        }

        synchronized void initRcvMsg(LinkMessage lmsg) {
            if (this.currRcvMsg != null) {
                this.currRcvMsg.initReceive(lmsg);
            }
        }
    }
}

