/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndriver.comm;

import com.tridium.ndriver.comm.FragmentManager;
import com.tridium.ndriver.comm.IComm;
import com.tridium.ndriver.comm.ICommFilter;
import com.tridium.ndriver.comm.ICommListener;
import com.tridium.ndriver.comm.IFragmentable;
import com.tridium.ndriver.comm.ILinkLayer;
import com.tridium.ndriver.comm.IMessageFactory;
import com.tridium.ndriver.comm.LinkMessage;
import com.tridium.ndriver.comm.LinkedProcessor;
import com.tridium.ndriver.comm.NCommException;
import com.tridium.ndriver.comm.NCommTimeoutException;
import com.tridium.ndriver.comm.NCommTimer;
import com.tridium.ndriver.comm.NLinkMessageFactory;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.datatypes.BCommConfig;
import com.tridium.ndriver.util.SpyUtil;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;

public class NComm
implements IComm {
    LinkedProcessor receive = new LinkedProcessor(){

        @Override
        public void process(Object obj) {
            NComm.this.doReceiveMessage((LinkMessage)obj);
        }
    };
    LinkedProcessor incoming = new LinkedProcessor(){

        @Override
        public void process(Object obj) {
            NComm.this.doProcessIncoming((NMessage)obj);
        }
    };
    Vector<ListenerData> listeners = new Vector();
    private Logger log;
    private BCommConfig comCfg;
    ILinkLayer linkLayer;
    private ICommListener defListener;
    private NCommTimer ntimer;
    private NLinkMessageFactory lnkFac;
    private IMessageFactory msgFac;
    private FragmentManager fragMgr;
    private boolean serviceStarted = false;
    private Exception lnkEx = null;
    private Statistics stats = new Statistics();

    public NComm(BCommConfig comCfg, ICommListener defaultListener) {
        this.comCfg = comCfg;
        this.ntimer = new NCommTimer(comCfg.getMaxOutstandingTransactions(), comCfg.getMaxTransactionWait(), comCfg.getResourcePrefix());
        this.fragMgr = new FragmentManager(this, this.ntimer);
        this.ntimer.setFragmentManager(this.fragMgr);
        this.linkLayer = comCfg.makeLinkLayer(this);
        this.defListener = defaultListener;
        this.lnkFac = comCfg.getLinkMessageFactory();
        this.msgFac = comCfg.getMessageFactory();
    }

    @Override
    public void start() throws Exception {
        if (this.serviceStarted) {
            return;
        }
        this.ntimer.start();
        this.receive.start(this.comCfg.getResourcePrefix() + ".Receiver");
        this.incoming.start(this.comCfg.getResourcePrefix() + ".Incoming");
        this.log().fine("start NComm");
        try {
            this.linkLayer.start();
            this.lnkEx = null;
        }
        catch (Exception e) {
            this.lnkEx = e;
        }
        this.serviceStarted = true;
        if (this.lnkEx != null) {
            throw this.lnkEx;
        }
    }

    @Override
    public void stop() {
        this.serviceStarted = false;
        this.linkLayer.stop();
        this.ntimer.stop();
        this.receive.stop();
        this.incoming.stop();
        this.listeners.clear();
    }

    @Override
    public void verifySettings(BCommConfig comCfg) throws Exception {
        try {
            if (!this.serviceStarted) {
                return;
            }
            this.linkLayer.verifySettings(comCfg);
            this.lnkEx = null;
        }
        catch (Exception e) {
            this.lnkEx = e;
            throw e;
        }
    }

    public ILinkLayer getLinkLayer() {
        return this.linkLayer;
    }

    @Override
    public void resetStats() {
        this.stats = new Statistics();
        if (this.linkLayer != null) {
            this.linkLayer.resetStats();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NMessage sendRequest(NMessage msg) throws Exception {
        boolean retry;
        Exception te = null;
        NMessage response = null;
        this.verify();
        if (this.log().isLoggable(Level.FINE)) {
            String adrSt = msg.getAddress() != null ? " to " + (Object)((Object)msg.getAddress()) : "";
            this.log.fine("sendRequest" + adrSt + " :\n" + msg.toTraceString() + "\n");
        }
        ++this.stats.sendRequest;
        int retries = msg.getRetryCount();
        do {
            retry = false;
            NCommTimer.Transaction trns = this.ntimer.getTransaction(msg);
            if (trns == null) {
                return null;
            }
            try {
                NCommTimer.Transaction transaction = trns;
                synchronized (transaction) {
                    this.sendFragments(msg);
                    while (!trns.isDone()) {
                        trns.wait();
                    }
                    trns.setComplete(true);
                }
                response = trns.getResponseMessage();
                te = trns.getException();
            }
            catch (Exception e) {
                trns.setComplete(true);
                te = e;
            }
            finally {
                this.ntimer.freeTransaction(trns);
            }
            if (retries > 0 && te instanceof NCommTimeoutException) {
                this.log.fine("retry");
                retry = true;
                --retries;
                ++this.stats.timeoutRetry;
            }
            if (retry || te == null) continue;
            ++this.stats.sendFail;
            throw te;
        } while (retry);
        return msg.modifyResponse(response);
    }

    public void sendMessage(NMessage msg) throws Exception {
        this.verify();
        if (this.log().isLoggable(Level.FINE)) {
            String adrSt = msg.getAddress() != null ? " to " + (Object)((Object)msg.getAddress()) : "";
            this.log.fine("sendMessage" + adrSt + " :\n" + msg.toTraceString() + "\n");
        }
        ++this.stats.sendMessage;
        this.sendFragments(msg);
    }

    private void sendFragments(NMessage msg) throws Exception {
        boolean more = true;
        msg.initFragmentation();
        while (more) {
            more = this.sendToLink(msg);
        }
    }

    private boolean sendToLink(NMessage msg) throws Exception {
        LinkMessage lmsg = this.lnkFac.getLinkMessage();
        boolean more = lmsg.setMessage(msg);
        this.linkLayer.sendMessage(lmsg);
        return more;
    }

    public void receiveMessage(LinkMessage lmsg) {
        this.receive.enqueue(lmsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReceiveMessage(LinkMessage lmsg) {
        try {
            NMessage ack;
            NMessage msg = this.msgFac.makeMessage(lmsg);
            if (msg == null) {
                return;
            }
            if (this.fragMgr != null && msg.isFragmentable()) {
                IFragmentable frag = (IFragmentable)((Object)msg);
                NMessage fragAck = frag.getFragmentAck();
                if (fragAck != null) {
                    this.sendToLink(fragAck);
                }
                if ((msg = this.fragMgr.mergeFragments(frag)) == null) {
                    return;
                }
            }
            if (this.log().isLoggable(Level.FINE)) {
                String adrSt = msg.getAddress() != null ? " from " + (Object)((Object)msg.getAddress()) : "";
                this.log().fine("receiveMessage" + adrSt + " :\n" + msg.toTraceString() + "\n");
            }
            if ((ack = msg.getAck()) != null) {
                this.sendToLink(ack);
            }
            if (msg.isResponse()) {
                ++this.stats.receiveResponse;
                this.processResponse(msg);
            } else {
                ++this.stats.receiveIncoming;
                this.processIncoming(msg);
            }
        }
        catch (Throwable e) {
            this.log().log(Level.SEVERE, "Exception in NComm.receiveMessage()", e);
            ++this.stats.receiveException;
            return;
        }
        finally {
            this.lnkFac.releaseLinkMessage(lmsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResponse(NMessage msg) {
        NCommTimer.Transaction trns = this.ntimer.getTransactionMatch(msg.getTag());
        if (trns == null) {
            this.log().severe("Receive response with no matching transaction from " + (Object)((Object)msg.getAddress()) + " :\n" + msg.toTraceString() + "\n");
            return;
        }
        NCommTimer.Transaction transaction = trns;
        synchronized (transaction) {
            try {
                if (trns.getComplete() || trns.getTimeout()) {
                    this.log().warning("Received response message with no matching transaction." + msg);
                    return;
                }
                switch (trns.getRequestMessage().validateResponse(msg)) {
                    case 4: {
                        this.ntimer.resetTimer(trns);
                        return;
                    }
                    case 1: {
                        trns.setException((Exception)((Object)new NCommException("Failed response")));
                        break;
                    }
                    case 2: {
                        trns.setResponseMessage(msg);
                        break;
                    }
                }
            }
            catch (Exception ex) {
                trns.setException(ex);
            }
            trns.receivedResponse();
        }
    }

    private void processIncoming(NMessage msg) {
        this.incoming.enqueue(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doProcessIncoming(NMessage msg) {
        boolean exclusive = false;
        Vector<ListenerData> vector = this.listeners;
        synchronized (vector) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ListenerData ld = this.listeners.elementAt(i);
                if (!ld.fltr.accept(msg)) continue;
                ld.listner.receiveMessage(msg);
                if (!ld.exclusive) continue;
                exclusive = true;
            }
        }
        if (!exclusive && this.defListener != null) {
            this.defListener.receiveMessage(msg);
        }
        if (!exclusive && this.defListener == null) {
            ++this.stats.noListener;
        }
    }

    @Override
    public void setDefaultListener(ICommListener listener) {
        this.defListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCommListener(ICommListener listener, ICommFilter filter, boolean exclusive) {
        Vector<ListenerData> vector = this.listeners;
        synchronized (vector) {
            if (this.findListener(listener, filter) < 0) {
                ListenerData ld = new ListenerData();
                ld.listner = listener;
                ld.fltr = filter;
                ld.exclusive = exclusive;
                this.listeners.add(ld);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCommListener(ICommListener listener, ICommFilter filter) {
        Vector<ListenerData> vector = this.listeners;
        synchronized (vector) {
            int ndx = this.findListener(listener, filter);
            while (ndx >= 0) {
                this.listeners.remove(ndx);
                ndx = this.findListener(listener, filter);
            }
        }
    }

    private int findListener(ICommListener listner, ICommFilter filter) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ListenerData ld = this.listeners.elementAt(i);
            if (ld.listner != listner || filter != null && ld.fltr != filter) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void spy(SpyWriter out) throws Exception {
        out.startProps("NComm");
        out.prop((Object)"serviceStarted", this.serviceStarted);
        if (this.defListener != null) {
            out.prop((Object)"defListener", (Object)this.defListener.getClass().getName());
        }
        if (this.lnkEx != null) {
            out.prop((Object)"link fault", (Object)this.lnkEx.getMessage());
            out.endProps();
            return;
        }
        out.endProps();
        SpyUtil.spy(out, "NCom Statistics", this.stats);
        this.ntimer.spy(out);
        this.linkLayer.spy(out);
        this.fragMgr.spy(out);
    }

    final Logger log() {
        if (this.log == null) {
            this.log = Logger.getLogger(this.comCfg.getResourcePrefix() + ".Comm");
        }
        return this.log;
    }

    private void verify() {
        if (!this.serviceStarted) {
            throw new BajaRuntimeException("service not started.");
        }
        if (this.lnkEx != null) {
            throw new BajaRuntimeException("link fault:", (Throwable)this.lnkEx);
        }
    }

    public static class Statistics {
        long startTime = Clock.millis();
        public long sendRequest = 0L;
        public long sendMessage = 0L;
        public long sendFail = 0L;
        public long timeoutRetry = 0L;
        public long receiveResponse = 0L;
        public long receiveIncoming = 0L;
        public long receiveException = 0L;
        public long noListener = 0L;

        public String getStartTime() {
            return BAbsTime.make((long)this.startTime).toLocalTime().toString(null);
        }
    }

    private static class ListenerData {
        ICommListener listner;
        ICommFilter fltr;
        boolean exclusive;

        private ListenerData() {
        }
    }
}

