/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndriver.comm;

import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.util.LinkedQueue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import javax.baja.sys.BajaRuntimeException;

public class LinkMessage
implements LinkedQueue.ILinkable {
    public Object address;
    protected byte[] buffer;
    private MyOutputStream outputStream;
    private MyInputStream inputStream;
    boolean freeBuf = false;
    private LinkMessage nextLinkMsg = null;

    public LinkMessage(int maxLength) {
        this.buffer = new byte[maxLength];
        this.outputStream = new MyOutputStream(this.buffer);
        this.inputStream = new MyInputStream(this.buffer, 0);
    }

    public boolean receive(InputStream in) throws Exception {
        throw new BajaRuntimeException("receive not implemented");
    }

    public boolean setMessage(NMessage msg) throws Exception {
        this.address = msg.getAddress();
        return msg.toOutputStream(this.outputStream);
    }

    public byte[] getByteArray() {
        return this.buffer;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public int getLength() {
        return this.outputStream.size();
    }

    public void setLength(int len) {
        this.inputStream.init(len);
    }

    public void initReceive(LinkMessage msgToSend) {
    }

    protected void doInit() {
    }

    void init() {
        Arrays.fill(this.buffer, (byte)0);
        this.outputStream.init();
        this.inputStream.init(0);
        this.doInit();
    }

    @Override
    public final LinkedQueue.ILinkable getNext() {
        return this.nextLinkMsg;
    }

    @Override
    public final void setNext(LinkedQueue.ILinkable nxt) {
        this.nextLinkMsg = (LinkMessage)nxt;
    }

    static class MyInputStream
    extends ByteArrayInputStream {
        MyInputStream(byte[] b, int msgLen) {
            super(b);
            this.init(msgLen);
        }

        private void init(int msgLen) {
            this.pos = 0;
            this.count = msgLen;
        }
    }

    static class MyOutputStream
    extends ByteArrayOutputStream {
        MyOutputStream(byte[] b) {
            this.buf = b;
            this.init();
        }

        private void init() {
            this.count = 0;
        }
    }
}

