/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.haystack;

import com.tridium.file.util.FindUtil;
import com.tridium.haystack.BHaystack4TagDictionary;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONTokener;
import com.tridium.tagdictionary.condition.BAlways;
import com.tridium.tagdictionary.condition.BBooleanFilter;
import com.tridium.tagdictionary.condition.BIsTypeCondition;
import com.tridium.tagdictionary.condition.BOr;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileSpace;
import javax.baja.file.types.text.BJsonFile;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BInteger;
import javax.baja.sys.BMarker;
import javax.baja.sys.BModuleDirectory;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Type;
import javax.baja.tagdictionary.BRelationInfo;
import javax.baja.tagdictionary.BRelationInfoList;
import javax.baja.tagdictionary.BSimpleTagInfo;
import javax.baja.tagdictionary.BTagGroupInfo;
import javax.baja.tagdictionary.BTagGroupInfoList;
import javax.baja.tagdictionary.BTagInfo;
import javax.baja.tagdictionary.BTagInfoList;
import javax.baja.tagdictionary.BTagRule;
import javax.baja.tagdictionary.BTagRuleCondition;
import javax.baja.tagdictionary.BTagRuleList;
import javax.baja.util.BTypeSpec;

public class Haystack4Importer {
    private static final String DEFS_FILENAME = "defs.json";
    private static final String PROTOS_FILENAME = "protos.json";
    private static final String CUSTOM_CONFIG_FILENAME = "haystack4NiagaraConfig.json";
    private static final String TRANSLATION_CONFIG_FILE = "module://haystack/com/tridium/haystack/data/HS4toN4.json";
    private static final HashMap<String, Type> tagTypeMap = new HashMap();
    private List<ConfigTagRule> configTagRules;
    private List<String> libPHIncludes;
    private static final String META = "meta";
    private static final String COLUMNS = "cols";
    private static final String ROWS = "rows";
    private static final String VERSION = "ver";
    private static final String NAME = "name";
    private static final String DEF = "def";
    private static final String IS = "is";
    private static final String LIBRARY = "lib";
    private static final String OF = "of";
    private static final String ID = "id";
    private static final String TAG_ON = "tagOn";
    private static final String VAL = "val";
    private static final String FEATURE = "feature";
    private static final String MARKER = "marker";
    private static final String REF = "ref";
    private static final String CHOICE = "choice";
    private static final String PROTO = "proto";
    private static final String CONFIG_TAG_RULES = "tagRules";
    private static final String CONFIG_TAG_RULE_CONDITION = "condition";
    private static final String CONFIG_IS_TYPE_CONDITION = "isType";
    private static final String CONFIG_TAG_RULE_TAG_TYPE = "tagType";
    private static final String LIB_PROJECT_HAYSTACK = "lib:ph";
    private static final String LIB_PH_INCLUDES = "libPHIncludes";
    private final BHaystack4TagDictionary dictionary;
    private final BTagInfoList tagInfos;
    private final BTagGroupInfoList tagGroupInfos;
    private final BRelationInfoList relationInfos;
    private final BTagRuleList tagRules;
    private final BOrd defsFolderOrd;
    private BJsonFile defsFile;
    private BJsonFile protosFile;
    private BJsonFile niagaraConfigsFile;
    private final SortedMap<String, Def> defMap = new TreeMap<String, Def>();
    private Def entityDef;
    private Def idDef;
    private Def geoPlaceDef;

    public Haystack4Importer(BOrd defsFolderOrd, int maxImportFileSize) {
        this(defsFolderOrd);
        this.dictionary.setMaxImportFileSize(maxImportFileSize);
    }

    public Haystack4Importer(BOrd defsFolderOrd) {
        this.defsFolderOrd = defsFolderOrd;
        this.dictionary = new BHaystack4TagDictionary();
        this.tagInfos = this.dictionary.getTagDefinitions();
        this.tagGroupInfos = this.dictionary.getTagGroupDefinitions();
        this.relationInfos = this.dictionary.getRelationDefinitions();
        this.tagRules = this.dictionary.getTagRules();
    }

    public BHaystack4TagDictionary doImport() {
        this.resolveImportArtifacts();
        this.loadHaystack4ToNiagaraConfigs();
        this.importDefs();
        this.addProtoTagGroups();
        return this.dictionary;
    }

    private void resolveImportArtifacts() {
        if (this.defsFolderOrd.equals((Object)BOrd.NULL)) {
            BHaystack4TagDictionary.LOGGER.log(Level.WARNING, "Tag import failed because dictionary property importDictionaryOrd is null.");
            throw new LocalizableRuntimeException("haystack", "importHaystack4.nullOrd");
        }
        try {
            BObject haystack4Defs = this.defsFolderOrd.resolve().get();
            if (!(haystack4Defs instanceof BDirectory)) {
                BHaystack4TagDictionary.LOGGER.log(Level.WARNING, "Tag import failed because dictionary property importDictionaryOrd is not a directory.");
                throw new LocalizableRuntimeException("haystack", "importHaystack4.notDirectory", new Object[]{this.defsFolderOrd.toString(null)});
            }
            BDirectory haystackArtifactDir = (BDirectory)haystack4Defs;
            try {
                this.niagaraConfigsFile = Haystack4Importer.findJsonFileInDirectory((BIDirectory)haystackArtifactDir, CUSTOM_CONFIG_FILENAME);
                if (this.niagaraConfigsFile == null) {
                    if (BHaystack4TagDictionary.LOGGER.isLoggable(Level.FINE)) {
                        BHaystack4TagDictionary.LOGGER.log(Level.FINE, "Could not find user's import config file; falling back to default");
                    }
                    this.niagaraConfigsFile = Haystack4Importer.resolveJsonFile(TRANSLATION_CONFIG_FILE);
                }
            }
            catch (Exception e) {
                if (BHaystack4TagDictionary.LOGGER.isLoggable(Level.FINE)) {
                    BHaystack4TagDictionary.LOGGER.log(Level.FINE, "Exception loading user's import config file; falling back to default", e);
                }
                this.niagaraConfigsFile = Haystack4Importer.resolveJsonFile(TRANSLATION_CONFIG_FILE);
            }
            this.defsFile = Haystack4Importer.findJsonFileInDirectory((BIDirectory)haystackArtifactDir, DEFS_FILENAME);
            this.protosFile = Haystack4Importer.findJsonFileInDirectory((BIDirectory)haystackArtifactDir, PROTOS_FILENAME);
            this.checkResolvedFile(this.niagaraConfigsFile, TRANSLATION_CONFIG_FILE);
            this.checkResolvedFile(this.defsFile, DEFS_FILENAME);
            this.checkResolvedFile(this.protosFile, PROTOS_FILENAME);
        }
        catch (UnresolvedException e) {
            throw new LocalizableRuntimeException("haystack", "importHaystack4.unresolvedFile", new Object[]{e.getLocalizedMessage()}, (Throwable)e);
        }
        this.dictionary.checkImportFileSize((BIFile)this.defsFile);
        this.dictionary.checkImportFileSize((BIFile)this.protosFile);
    }

    private void checkResolvedFile(BJsonFile jsonFile, String fileName) {
        if (jsonFile == null) {
            BHaystack4TagDictionary.LOGGER.warning("Tag import failed because the " + fileName + " file was not found.");
            throw new LocalizableRuntimeException("haystack", "importHaystack4.unresolvedFile", new Object[]{fileName});
        }
    }

    private static BJsonFile resolveJsonFile(String filePath) {
        BIFile file = (BIFile)BOrd.make((String)filePath).resolve().get();
        if (!(file instanceof BJsonFile)) {
            BHaystack4TagDictionary.LOGGER.warning("Tag import failed because the " + filePath + " file is not a JSON file.");
            throw new LocalizableRuntimeException("haystack", "importHaystack4.configNotJsonFile", new Object[]{filePath});
        }
        return (BJsonFile)file;
    }

    private static BJsonFile findJsonFileInDirectory(BIDirectory artifactDir, String fileName) {
        List files = null;
        if (artifactDir instanceof BDirectory) {
            files = FindUtil.files().recursively().ofType(BJsonFile.TYPE).from((BDirectory)artifactDir);
        } else if (artifactDir instanceof BModuleDirectory) {
            files = FindUtil.files().recursively().ofType(BJsonFile.TYPE).from((BIFileSpace)((BModuleDirectory)artifactDir).getFileSpace());
        } else if (artifactDir instanceof BFileSpace) {
            files = FindUtil.files().recursively().ofType(BJsonFile.TYPE).from((BIFileSpace)((BFileSpace)artifactDir));
        }
        if (files == null || files.size() == 0) {
            return null;
        }
        for (BIFile file : files) {
            if (!file.getFileName().equals(fileName)) continue;
            return (BJsonFile)file;
        }
        return null;
    }

    private void loadHaystack4ToNiagaraConfigs() {
        try (InputStream in = this.niagaraConfigsFile.getInputStream();){
            JSONTokener jsonTokener = new JSONTokener(in);
            JSONObject jsonObject = new JSONObject(jsonTokener);
            this.loadConfigTagRules(jsonObject.getJSONArray(CONFIG_TAG_RULES));
            JSONArray libPHIncludesArray = jsonObject.optJSONArray(LIB_PH_INCLUDES);
            if (libPHIncludesArray != null) {
                int length = libPHIncludesArray.length();
                this.libPHIncludes = new ArrayList<String>(length);
                for (int i = 0; i < length; ++i) {
                    this.libPHIncludes.add(libPHIncludesArray.getString(i));
                }
            }
        }
        catch (Exception e) {
            BHaystack4TagDictionary.LOGGER.log(Level.WARNING, "Error importing haystack 4 to Niagara configurations.", e);
            throw new LocalizableRuntimeException("haystack", "importHaystack4.niagaraConfigurations", new Object[]{this.niagaraConfigsFile.getFilePath()}, (Throwable)e);
        }
    }

    private void loadConfigTagRules(JSONArray configTagRuleArray) {
        this.configTagRules = new ArrayList<ConfigTagRule>();
        for (int i = 0; i < configTagRuleArray.length(); ++i) {
            JSONObject tagRuleEntry = configTagRuleArray.optJSONObject(i);
            if (tagRuleEntry == null) continue;
            String typeName = tagRuleEntry.getString(NAME);
            String condition = tagRuleEntry.optString(CONFIG_TAG_RULE_CONDITION);
            String isType = tagRuleEntry.optString(CONFIG_IS_TYPE_CONDITION);
            String tagType = tagRuleEntry.optString(CONFIG_TAG_RULE_TAG_TYPE);
            this.configTagRules.add(new ConfigTagRule(typeName, condition, isType, tagType));
        }
    }

    private void importDefs() {
        try (InputStream in = this.defsFile.getInputStream();){
            JSONTokener jsonTokener = new JSONTokener(in);
            JSONObject root = new JSONObject(jsonTokener);
            JSONObject meta = root.getJSONObject(META);
            String jsonVersion = meta.getString(VERSION);
            this.dictionary.setVersion(jsonVersion);
            Haystack4Importer.checkColumns(root.getJSONArray(COLUMNS));
            for (Object row : root.getJSONArray(ROWS)) {
                this.parseDefRow((JSONObject)row);
            }
        }
        catch (Exception e) {
            throw new LocalizableRuntimeException("haystack", "importHaystack4.parseDefJson", new Object[]{this.defsFolderOrd.toString(null)}, (Throwable)e);
        }
        this.processDefTyping();
        this.processChoices();
        this.findSpecialDefs();
        try {
            this.createDictionaryItems();
        }
        catch (Exception e) {
            throw new LocalizableRuntimeException("haystack", "importHaystack4.tagRuleJson", new Object[]{this.defsFolderOrd.toString(null)}, (Throwable)e);
        }
    }

    private static void checkColumns(JSONArray columns) {
        boolean[] hasColumns = new boolean[5];
        block14: for (int i = 0; i < columns.length(); ++i) {
            JSONObject column = columns.optJSONObject(i);
            if (column == null) continue;
            switch (column.getString(NAME)) {
                case "def": {
                    hasColumns[0] = true;
                    continue block14;
                }
                case "of": {
                    hasColumns[1] = true;
                    continue block14;
                }
                case "is": {
                    hasColumns[2] = true;
                    continue block14;
                }
                case "lib": {
                    hasColumns[3] = true;
                    continue block14;
                }
                case "tagOn": {
                    hasColumns[4] = true;
                    continue block14;
                }
            }
        }
        for (boolean hasColumn : hasColumns) {
            if (hasColumn) continue;
            BHaystack4TagDictionary.LOGGER.log(Level.WARNING, "Tag definition JSON file was not loaded because required column definitions were not found.");
            throw new LocalizableRuntimeException("haystack", "importHaystack4.missingColumn");
        }
    }

    private void parseDefRow(JSONObject row) {
        int tagOnsLength;
        List<String> superTypeNames;
        JSONObject def = row.optJSONObject(DEF);
        if (def == null) {
            throw new LocalizableRuntimeException("haystack", "importHaystack4.defsRowMissingDef", new Object[]{row.toString()});
        }
        String defName = def.getString(VAL);
        if (defName == null || defName.isEmpty()) {
            throw new LocalizableRuntimeException("haystack", "importHaystack4.defsRowDefIsEmpty", new Object[]{def.toString()});
        }
        if (defName.contains(":")) {
            return;
        }
        JSONArray superTypes = row.optJSONArray(IS);
        if (superTypes == null || superTypes.length() < 1) {
            if (!(VAL.equals(defName) || FEATURE.equals(defName) || MARKER.equals(defName))) {
                throw new LocalizableRuntimeException("haystack", "importHaystack4.defsRowMissingSuperTypes", new Object[]{defName});
            }
            superTypeNames = Collections.emptyList();
        } else {
            superTypeNames = Haystack4Importer.getSuperTypeNames(superTypes);
        }
        JSONObject of = row.optJSONObject(OF);
        String ofName = of == null ? null : of.getString(VAL);
        JSONObject lib = row.optJSONObject(LIBRARY);
        if (lib == null) {
            throw new LocalizableRuntimeException("haystack", "importHaystack4.defsRowMissingLib", new Object[]{defName});
        }
        String libName = lib.getString(VAL);
        List<String> tagOns = Collections.emptyList();
        JSONArray tagOnArray = row.optJSONArray(TAG_ON);
        int n = tagOnsLength = tagOnArray == null ? 0 : tagOnArray.length();
        if (tagOnsLength > 0) {
            tagOns = new ArrayList(tagOnsLength);
            for (Object tagOn : tagOnArray) {
                tagOns.add(((JSONObject)tagOn).getString(VAL));
            }
        }
        this.defMap.put(defName, new Def(defName, defName.contains("-"), superTypeNames, ofName, libName, tagOns));
    }

    private static List<String> getSuperTypeNames(JSONArray superTypes) {
        ArrayList<String> names = new ArrayList<String>(superTypes.length());
        for (Object superType : superTypes) {
            names.add(((JSONObject)superType).getString(VAL));
        }
        return names;
    }

    private void processDefTyping() {
        for (Def def : this.defMap.values()) {
            if (def.isRelation() || def.superTypes.isEmpty()) continue;
            Type tagType = null;
            for (String superType : def.superTypes) {
                Def superDef = (Def)this.defMap.get(superType);
                if (superDef == null) continue;
                superDef.addSubtype(def);
                if (superDef.name.equals(CHOICE)) {
                    def.isChoice = true;
                }
                if (def.isConjunct) continue;
                while (tagType == null && superDef != null) {
                    tagType = tagTypeMap.get(superDef.name);
                    if (tagType != null) continue;
                    superDef = this.getSuperDef(superDef);
                }
            }
            def.tagType = tagType;
        }
    }

    private Def getSuperDef(Def def) {
        if (def.superTypes.isEmpty()) {
            return null;
        }
        return (Def)this.defMap.get(def.superTypes.get(0));
    }

    private void findSpecialDefs() {
        this.entityDef = (Def)this.defMap.get("entity");
        this.idDef = (Def)this.defMap.get(ID);
        this.geoPlaceDef = (Def)this.defMap.get("geoPlace");
        if (this.entityDef == null || this.idDef == null || this.geoPlaceDef == null) {
            throw new LocalizableRuntimeException("haystack", "importHaystack4.defsMissingEntries");
        }
    }

    private void processChoices() {
        for (Def def : this.defMap.values()) {
            if (!def.isChoice) continue;
            if (def.of == null) {
                def.choices = def.getDescendants();
            } else {
                Def ofDef = (Def)this.defMap.get(def.of);
                if (ofDef == null) {
                    throw new LocalizableRuntimeException("haystack", "importHaystack4.choiceDef.missingOfDef", new Object[]{def.of, def.name});
                }
                def.choices = ofDef.getDescendants();
            }
            if (def.choices.isEmpty()) {
                throw new LocalizableRuntimeException("haystack", "importHaystack4.choiceDef.missingChoiceValues", new Object[]{def.name});
            }
            for (Def choice : def.choices) {
                choice.choiceName = Haystack4Importer.makeTagOrTagGroupName(choice);
            }
            def.choices.sort(Def::byChoiceName);
        }
    }

    private static BDynamicEnum makeChoiceDefault(Def def) {
        String[] choiceNames = (String[])def.choices.stream().map(choice -> choice.choiceName).toArray(String[]::new);
        return BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((String[])choiceNames));
    }

    private void addChoiceTagRules() {
        for (Def def : this.defMap.values()) {
            if (!def.isChoice) continue;
            for (Def choice : def.choices) {
                this.addChoiceTagRule(def, choice);
            }
        }
    }

    private void addChoiceTagRule(Def def, Def choice) {
        try {
            BTagRule tagRule = new BTagRule();
            tagRule.setCondition((BTagRuleCondition)new BBooleanFilter(this.dictionary.getNamespace() + ':' + def.name + " = \"" + choice.choiceName + '\"'));
            if (choice.isConjunct) {
                this.copyTagGroupInfo(choice.choiceName, tagRule.getTagGroupList());
            } else {
                this.copyTagInfo(choice.choiceName, tagRule.getTagList());
            }
            this.tagRules.add(def.name + '_' + choice.choiceName, (BValue)tagRule);
        }
        catch (Exception e) {
            throw new LocalizableRuntimeException("haystack", "importHaystack4.choiceDef.tagRuleError", new Object[]{choice.choiceName, def.name}, (Throwable)e);
        }
    }

    private void createDictionaryItems() {
        this.addTagsAndRelations();
        for (Def def : this.defMap.values()) {
            if (!def.isConjunct) continue;
            this.addConjunctTagGroup(def);
        }
        this.addDeclaredTagRules();
        this.addChoiceTagRules();
        this.addSubTypeTagRules();
        this.addNeqlizeExcludedTags();
    }

    private void addTagsAndRelations() {
        for (Def def : this.defMap.values()) {
            if (def.isConjunct) continue;
            if (def.isRelation()) {
                this.addRelation(def);
                this.tagInfos.add(def.name, (BValue)new BSimpleTagInfo((BIDataValue)BString.DEFAULT));
                continue;
            }
            if (def.isChoice) {
                BDynamicEnum choiceDefault = Haystack4Importer.makeChoiceDefault(def);
                this.tagInfos.add(def.name, (BValue)new BSimpleTagInfo((BIDataValue)choiceDefault));
                continue;
            }
            if (def.tagType == null) continue;
            if (this.isTagDefIncluded(def)) {
                this.tagInfos.add(def.name, (BValue)new BSimpleTagInfo((BIDataValue)def.tagType.getInstance()));
                continue;
            }
            if (!BHaystack4TagDictionary.LOGGER.isLoggable(Level.FINER)) continue;
            String tagType = def.tagType == null ? "null" : def.tagType.getTypeName();
            BHaystack4TagDictionary.LOGGER.log(Level.FINER, "Excluding def \"" + def.name + "\" with tag type \"" + tagType + "\".");
        }
    }

    private void addSubTypeTagRules() {
        for (Def def : this.defMap.values()) {
            BTagRule existing;
            if (def.isChoice || def.subtypes == null || this.tagInfos.get(def.name) == null) continue;
            ArrayList<String> subtypeNames = new ArrayList<String>(def.subtypes.size());
            for (Def subType : def.subtypes) {
                subtypeNames.add(Haystack4Importer.makeTagOrTagGroupName(subType));
            }
            if (BHaystack4TagDictionary.LOGGER.isLoggable(Level.FINER)) {
                BHaystack4TagDictionary.LOGGER.log(Level.FINER, "Creating subtype tag rule for \"" + def.name + "\" with subtypes \"" + Arrays.toString(subtypeNames.toArray()) + '\"');
            }
            if ((existing = (BTagRule)this.tagRules.get(def.name)) != null) {
                BTagRuleCondition existingCondition = existing.getCondition();
                if (existingCondition instanceof BAlways) continue;
                BOr newCondition = new BOr();
                newCondition.add("t?", existingCondition.newCopy());
                newCondition.add("t?", (BValue)this.makeOrFilter(subtypeNames));
                existing.setCondition((BTagRuleCondition)newCondition);
                continue;
            }
            BTagRule tagRule = new BTagRule();
            tagRule.setCondition(this.makeOrFilter(subtypeNames));
            this.copyTagInfo(def.name, tagRule.getTagList());
            this.tagRules.add(def.name, (BValue)tagRule);
        }
    }

    private void addDeclaredTagRules() {
        for (ConfigTagRule configTagRule : this.configTagRules) {
            Def def = (Def)this.defMap.get(configTagRule.name);
            if (def == null) {
                throw new LocalizableRuntimeException("haystack", "importHaystack4.configTagRule.missingDef", new Object[]{configTagRule.name});
            }
            try {
                BAlways condition;
                BTagRule tagRule = new BTagRule();
                switch (configTagRule.condition) {
                    case ALWAYS: {
                        condition = new BAlways();
                        break;
                    }
                    case IS_TYPE: {
                        condition = new BIsTypeCondition(configTagRule.isType);
                        break;
                    }
                    case TAG_ON: {
                        if (def.tagOns.isEmpty()) {
                            throw new LocalizableRuntimeException("haystack", "importHaystack4.configTagRule.emptyTagOns", new Object[]{configTagRule.name});
                        }
                        condition = this.makeOrFilter(def.tagOns);
                        break;
                    }
                    default: {
                        throw new LocalizableRuntimeException("haystack", "importHaystack4.configTagRule.unsupportedCondition", new Object[]{configTagRule.name});
                    }
                }
                tagRule.setCondition((BTagRuleCondition)condition);
                if (this.relationInfos.get(configTagRule.name) != null) {
                    tagRule.getRelationList().add(configTagRule.name, (BValue)((BRelationInfo)configTagRule.tagType.getInstance()));
                } else {
                    BTagInfo tagDefTagInfo = (BTagInfo)this.tagInfos.get(configTagRule.name);
                    if (tagDefTagInfo == null) {
                        throw new LocalizableRuntimeException("haystack", "importHaystack4.configTagRule.missingTagInfo", new Object[]{configTagRule.name});
                    }
                    BTagInfo tagRuleTagInfo = configTagRule.tagType != null ? (BTagInfo)configTagRule.tagType.getInstance() : (BTagInfo)tagDefTagInfo.newCopy();
                    tagRule.getTagList().add(configTagRule.name, (BValue)tagRuleTagInfo);
                }
                this.tagRules.add(configTagRule.name, (BValue)tagRule);
            }
            catch (Exception e) {
                throw new LocalizableRuntimeException("haystack", "importHaystack4.configTagRule.error", new Object[]{configTagRule.name, configTagRule.tagType.toString()}, (Throwable)e);
            }
        }
    }

    private BTagRuleCondition makeOrFilter(List<String> tagNames) {
        String namespace = this.dictionary.getNamespace();
        StringJoiner filter = new StringJoiner(" or " + namespace + ':', namespace + ':', "");
        for (String tagName : tagNames) {
            filter.add(tagName);
        }
        return new BBooleanFilter(filter.toString());
    }

    private void addNeqlizeExcludedTags() {
        String namespace = this.dictionary.getNamespace();
        int extraChars = namespace.length() + 1 + ", ".length();
        StringJoiner excludeJoiner = new StringJoiner(", ");
        StringBuilder excludeBuilder = new StringBuilder();
        for (Def def : this.defMap.values()) {
            if (!def.isChoice && !def.isRelation()) continue;
            if (excludeJoiner.length() + def.name.length() + extraChars > 35) {
                excludeBuilder.append(excludeJoiner).append(",\n");
                excludeJoiner = new StringJoiner(", ");
            }
            excludeJoiner.add(namespace + ':' + def.name);
        }
        excludeBuilder.append(excludeJoiner);
        this.dictionary.setNeqlizeExcludedTags(excludeBuilder.toString());
    }

    private void addRelation(Def def) {
        if (def.superTypes.size() > 1) {
            throw new LocalizableRuntimeException("haystack", "importHaystack4.relation.refHasTooManySuperTypes", new Object[]{def.name});
        }
        if (def == this.idDef) {
            return;
        }
        this.relationInfos.add(def.name, (BValue)new BRelationInfo());
    }

    private boolean isTagDefIncluded(Def def) {
        if (!def.lib.equals(LIB_PROJECT_HAYSTACK)) {
            return true;
        }
        if (def == this.entityDef || def == this.geoPlaceDef || this.libPHIncludes.contains(def.name)) {
            return true;
        }
        if (this.entityDef.getDescendants().contains(def)) {
            if (BHaystack4TagDictionary.LOGGER.isLoggable(Level.FINER)) {
                BHaystack4TagDictionary.LOGGER.log(Level.FINER, "  Including lib:ph def \"" + def.name + "\" because it is a sub-type of entity");
            }
            return true;
        }
        for (String tagOnName : def.tagOns) {
            Def tagOn = (Def)this.defMap.get(tagOnName);
            if (tagOn == null) {
                throw new LocalizableRuntimeException("haystack", "importHaystack4.missingTagOnDef", new Object[]{tagOnName, def.name});
            }
            if (!this.entityDef.isSameOrSupertype(tagOn) && !this.geoPlaceDef.isSameOrSupertype(tagOn)) continue;
            if (BHaystack4TagDictionary.LOGGER.isLoggable(Level.FINER)) {
                BHaystack4TagDictionary.LOGGER.log(Level.FINER, "  Including lib:ph def \"" + def.name + "\" because it is a tagOn " + tagOn.name + ", which is a sub-type of entity or geoPlace");
            }
            return true;
        }
        return false;
    }

    private void addConjunctTagGroup(Def def) {
        List<String> conjunctNames = Arrays.asList(def.name.split("-"));
        if (conjunctNames.isEmpty()) {
            throw new LocalizableRuntimeException("haystack", "importHaystack4.conjunctTagGroup.badFormat", new Object[]{def.name});
        }
        String tagGroupName = Haystack4Importer.makeTagGroupName(conjunctNames);
        try {
            BTagGroupInfo tagGroupInfo = new BTagGroupInfo();
            BTagInfoList tagGroupTagList = tagGroupInfo.getTagList();
            for (String tagName : conjunctNames) {
                this.copyTagInfo(tagName, tagGroupTagList);
            }
            this.tagGroupInfos.add(tagGroupName, (BValue)tagGroupInfo);
        }
        catch (Exception e) {
            throw new LocalizableRuntimeException("haystack", "importHaystack4.conjunctTagGroup.error", new Object[]{def.name}, (Throwable)e);
        }
    }

    private static String makeTagOrTagGroupName(Def def) {
        if (def.isConjunct) {
            if (!def.name.contains("-")) {
                throw new BajaRuntimeException("Conjunct must contain a dash");
            }
            return Haystack4Importer.makeTagGroupName(Arrays.asList(def.name.split("-")));
        }
        return def.name;
    }

    private static String makeTagGroupName(List<String> tagNames) {
        StringBuilder tagGroupName = new StringBuilder(tagNames.get(0));
        for (int i = 1; i < tagNames.size(); ++i) {
            tagGroupName.append(TextUtil.capitalize((String)tagNames.get(i)));
        }
        return tagGroupName.toString();
    }

    private void copyTagInfo(String name, BTagInfoList tagList) {
        BTagInfo tagInfo = (BTagInfo)this.tagInfos.get(name);
        if (tagInfo == null) {
            throw new LocalizableRuntimeException("haystack", "importHaystack4.missingTagInfo", new Object[]{name});
        }
        tagList.add(name, tagInfo.newCopy(true));
    }

    private void copyTagGroupInfo(String name, BTagGroupInfoList tagGroupList) {
        BTagGroupInfo tagGroupInfo = (BTagGroupInfo)this.tagGroupInfos.get(name);
        if (tagGroupInfo == null) {
            throw new LocalizableRuntimeException("haystack", "importHaystack4.missingTagGroupInfo", new Object[]{name});
        }
        tagGroupList.add(name, tagGroupInfo.newCopy(true));
    }

    private void parseProtoRow(JSONObject row, SortedMap<String, BTagGroupInfo> protoTagGroups) {
        String proto = row.optString(PROTO);
        if (proto == null || proto.isEmpty()) {
            throw new LocalizableRuntimeException("haystack", "importHaystack4.protosRowMissingProto", new Object[]{row.toString()});
        }
        String[] protoNames = proto.split(" ");
        ArrayList<String> tagNames = new ArrayList<String>(protoNames.length);
        for (String protoName : protoNames) {
            if (protoName.contains(":")) continue;
            tagNames.add(protoName);
        }
        if (tagNames.isEmpty()) {
            throw new LocalizableRuntimeException("haystack", "importHaystack4.protoTagGroup.badFormat", new Object[]{row.toString()});
        }
        String tagGroupName = Haystack4Importer.makeTagGroupName(tagNames);
        if (this.tagInfos.get(tagGroupName) != null || this.tagGroupInfos.get(tagGroupName) != null) {
            if (BHaystack4TagDictionary.LOGGER.isLoggable(Level.FINE)) {
                BHaystack4TagDictionary.LOGGER.log(Level.FINE, "Duplicate item for proto \"" + proto + "\" was found in the dictionary tags or tag groups.");
            }
            return;
        }
        try {
            BTagGroupInfo tagGroupInfo = new BTagGroupInfo();
            BTagInfoList tagGroupTagList = tagGroupInfo.getTagList();
            for (String tagName : tagNames) {
                this.copyTagInfo(tagName, tagGroupTagList);
            }
            protoTagGroups.put(tagGroupName, tagGroupInfo);
        }
        catch (Exception e) {
            throw new LocalizableRuntimeException("haystack", "importHaystack4.protoTagGroup.error", new Object[]{proto}, (Throwable)e);
        }
    }

    private void addProtoTagGroups() {
        try (InputStream in = this.protosFile.getInputStream();){
            JSONTokener jsonTokener = new JSONTokener(in);
            JSONObject root = new JSONObject(jsonTokener);
            TreeMap<String, BTagGroupInfo> protoTagGroups = new TreeMap<String, BTagGroupInfo>();
            for (Object row : root.getJSONArray(ROWS)) {
                this.parseProtoRow((JSONObject)row, protoTagGroups);
            }
            for (Map.Entry entry : protoTagGroups.entrySet()) {
                this.tagGroupInfos.add((String)entry.getKey(), (BValue)entry.getValue());
            }
        }
        catch (Exception e) {
            throw new LocalizableRuntimeException("haystack", "importHaystack4.parseProtosJson", new Object[]{this.defsFolderOrd.toString(null)}, (Throwable)e);
        }
    }

    static {
        tagTypeMap.put(MARKER, BMarker.TYPE);
        tagTypeMap.put("bool", BBoolean.TYPE);
        tagTypeMap.put("number", BDouble.TYPE);
        tagTypeMap.put("int", BInteger.TYPE);
        tagTypeMap.put("str", BString.TYPE);
        tagTypeMap.put("uri", BString.TYPE);
        tagTypeMap.put("date", BAbsTime.TYPE);
        tagTypeMap.put("dateTime", BAbsTime.TYPE);
        tagTypeMap.put("time", BAbsTime.TYPE);
        tagTypeMap.put("coord", BString.TYPE);
        tagTypeMap.put("scalar", BString.TYPE);
    }

    private static class Def {
        public final String name;
        public final boolean isConjunct;
        public boolean isChoice;
        public String choiceName;
        public final List<String> superTypes;
        public final String of;
        public final String lib;
        public final List<String> tagOns;
        public List<Def> subtypes;
        public List<Def> choices = Collections.emptyList();
        public Type tagType;
        private List<Def> descendants;

        public Def(String name, boolean isConjunct, List<String> superTypes, String of, String lib, List<String> tagOns) {
            this.name = name;
            this.isConjunct = isConjunct;
            this.superTypes = superTypes;
            this.of = of;
            this.lib = lib;
            this.tagOns = tagOns;
        }

        public String getName() {
            return this.name;
        }

        public boolean isRelation() {
            return !this.superTypes.isEmpty() && this.superTypes.get(0).equals(Haystack4Importer.REF);
        }

        public boolean isTag() {
            return this.tagType != null;
        }

        public void addSubtype(Def def) {
            if (this.subtypes == null) {
                this.subtypes = new ArrayList<Def>();
            }
            this.subtypes.add(def);
        }

        public List<Def> getDescendants() {
            if (this.descendants == null) {
                this.descendants = Def.findDescendants(this);
            }
            return this.descendants;
        }

        private static List<Def> findDescendants(Def def) {
            if (def.subtypes == null) {
                return Collections.emptyList();
            }
            ArrayList<Def> descendants = new ArrayList<Def>();
            for (Def subtype : def.subtypes) {
                descendants.add(subtype);
                descendants.addAll(Def.findDescendants(subtype));
            }
            return descendants;
        }

        public boolean isSameOrSupertype(Def def) {
            return def == this || this.getDescendants().contains(def);
        }

        public int byChoiceName(Def def) {
            return this.choiceName.compareTo(def.choiceName);
        }

        public String toString() {
            return "Def{name='" + this.name + "'}";
        }
    }

    private static enum ImpliedTagRuleCondition {
        ALWAYS,
        IS_TYPE,
        TAG_ON;

    }

    private static class ConfigTagRule {
        public final String name;
        public final ImpliedTagRuleCondition condition;
        public final BTypeSpec isType;
        public final Type tagType;

        public ConfigTagRule(String name, String condition, String isType, String tagType) {
            this.name = name;
            this.condition = ImpliedTagRuleCondition.IS_TYPE.name().equals(condition) ? ImpliedTagRuleCondition.IS_TYPE : (ImpliedTagRuleCondition.TAG_ON.name().equals(condition) ? ImpliedTagRuleCondition.TAG_ON : ImpliedTagRuleCondition.ALWAYS);
            try {
                this.isType = !isType.isEmpty() ? BTypeSpec.make((String)isType) : null;
                this.tagType = !tagType.isEmpty() ? BTypeSpec.make((String)tagType).getResolvedType() : null;
            }
            catch (Exception e) {
                throw new LocalizableRuntimeException("haystack", "importHaystack4.tagRuleError", new Object[]{name, tagType}, (Throwable)e);
            }
        }
    }
}

