/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.haystack;

import java.util.Collection;
import java.util.Optional;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BNullProxyExt;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelation;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.BasicRelation;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tagdictionary.BRelationInfo;

@NiagaraType
public abstract class BContainmentRelation
extends BRelationInfo {
    @Generated
    public static final Type TYPE = Sys.loadType(BContainmentRelation.class);
    private Id equipId;
    private Id equipRefId;
    private Id siteId;
    private Id siteRefId;
    private Id spaceId;
    private Id spaceRefId;
    private Id systemId;
    private Id systemRefId;

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected static BRelation getDirectRelation(BComponent component, Id id) {
        for (BRelation relation : component.getComponentRelations()) {
            if (!relation.getId().equals((Object)id)) continue;
            return relation;
        }
        return null;
    }

    protected static boolean hasDirectRelation(BComponent component, Id id) {
        return BContainmentRelation.getDirectRelation(component, id) != null;
    }

    protected final BComponent getImpliedEquip(BControlPoint point) {
        if (point.getProxyExt() instanceof BNullProxyExt) {
            return null;
        }
        for (BComponent parent = (BComponent)point.getParent(); parent != null; parent = (BComponent)parent.getParent()) {
            if (!this.hasEquipTag((Entity)parent)) continue;
            return parent.asComponent();
        }
        return null;
    }

    protected final boolean hasEquipTag(Entity entity) {
        return entity.tags().contains(this.getEquipId());
    }

    protected final Id getEquipId() {
        return this.isRunning() && this.equipId != null ? this.equipId : (this.equipId = this.makeId("equip"));
    }

    protected final Id getEquipRefId() {
        return this.isRunning() && this.equipRefId != null ? this.equipRefId : (this.equipRefId = this.makeId("equipRef"));
    }

    protected final Entity getEquip(Entity entity) {
        Optional equipRef = entity.relations().get(this.getEquipRefId(), 2);
        if (!equipRef.isPresent()) {
            return null;
        }
        Entity equip = ((Relation)equipRef.get()).getEndpoint();
        if (this.hasEquipTag(equip)) {
            return equip;
        }
        return null;
    }

    protected final BComponent getPointEquip(BControlPoint point) {
        BRelation equipRef = BContainmentRelation.getDirectRelation((BComponent)point, this.getEquipRefId());
        if (equipRef != null) {
            return (BComponent)equipRef.getEndpoint();
        }
        return this.getImpliedEquip(point);
    }

    protected final void addEquipContainmentRelations(Entity equip, Id id, Collection<Relation> relations) {
        for (Relation equipRef : equip.relations().getAll(this.getEquipRefId(), 1)) {
            Entity endpoint = equipRef.getEndpoint();
            if (this.hasEquipTag(endpoint)) {
                relations.add((Relation)new BasicRelation(id, endpoint, true));
                this.addEquipContainmentRelations(endpoint, id, relations);
                continue;
            }
            if (!(endpoint instanceof BControlPoint)) continue;
            relations.add((Relation)new BasicRelation(id, endpoint, true));
        }
    }

    protected final boolean hasSiteTag(Entity entity) {
        return entity.tags().contains(this.getSiteId());
    }

    protected final Id getSiteId() {
        return this.isRunning() && this.siteId != null ? this.siteId : (this.siteId = this.makeId("site"));
    }

    protected final Id getSiteRefId() {
        return this.isRunning() && this.siteRefId != null ? this.siteRefId : (this.siteRefId = this.makeId("siteRef"));
    }

    protected final Entity getSite(Entity entity) {
        Optional siteRef = entity.relations().get(this.getSiteRefId(), 2);
        if (!siteRef.isPresent()) {
            return null;
        }
        Entity site = ((Relation)siteRef.get()).getEndpoint();
        if (this.hasSiteTag(site)) {
            return site;
        }
        return null;
    }

    protected final boolean hasSpaceTag(Entity entity) {
        return entity.tags().contains(this.getSpaceId());
    }

    protected final Id getSpaceId() {
        return this.isRunning() && this.spaceId != null ? this.spaceId : (this.spaceId = this.makeId("space"));
    }

    protected final Id getSpaceRefId() {
        return this.isRunning() && this.spaceRefId != null ? this.spaceRefId : (this.spaceRefId = this.makeId("spaceRef"));
    }

    protected final Entity getSpace(Entity entity) {
        Optional spaceRef = entity.relations().get(this.getSpaceRefId(), 2);
        if (!spaceRef.isPresent()) {
            return null;
        }
        Entity site = ((Relation)spaceRef.get()).getEndpoint();
        if (this.hasSpaceTag(site)) {
            return site;
        }
        return null;
    }

    protected final boolean hasSystemTag(Entity entity) {
        return entity.tags().contains(this.getSystemId());
    }

    protected final Id getSystemId() {
        return this.isRunning() && this.systemId != null ? this.systemId : (this.systemId = this.makeId("system"));
    }

    protected final Id getSystemRefId() {
        return this.isRunning() && this.systemRefId != null ? this.systemRefId : (this.systemRefId = this.makeId("systemRef"));
    }

    protected final Entity getSystem(Entity entity) {
        Optional systemRef = entity.relations().get(this.getSystemRefId(), 2);
        if (!systemRef.isPresent()) {
            return null;
        }
        Entity system = ((Relation)systemRef.get()).getEndpoint();
        if (this.hasSystemTag(system)) {
            return system;
        }
        return null;
    }

    protected final Id makeId(String tagName) {
        return Id.newId((String)this.getRelationId().getDictionary(), (String)tagName);
    }

    public final void relationRenamed() {
        super.relationRenamed();
        this.equipId = this.makeId("equip");
        this.equipRefId = this.makeId("equipRef");
        this.siteId = this.makeId("site");
        this.siteRefId = this.makeId("siteRef");
        this.spaceId = this.makeId("space");
        this.spaceRefId = this.makeId("spaceRef");
        this.systemId = this.makeId("system");
        this.systemRefId = this.makeId("systemRef");
    }
}

