/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.server;

import com.tridium.modbusCore.BModbusDevice;
import com.tridium.modbusCore.ModbusErrorCodes;
import com.tridium.modbusCore.ModbusException;
import com.tridium.modbusCore.messages.ModbusMessageConst;
import com.tridium.modbusCore.server.BModbusServerNetwork;
import com.tridium.modbusCore.server.datatypes.BModbusRegisterRangeEntry;
import com.tridium.modbusCore.server.datatypes.BModbusRegisterRangeTable;
import com.tridium.modbusCore.server.datatypes.BModbusServerStringRecord;
import com.tridium.modbusCore.server.point.BModbusServerPointDeviceExt;
import java.util.ArrayList;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.IntHashMap;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="validCoilsRange", type="BModbusRegisterRangeTable", defaultValue="new BModbusRegisterRangeTable(new BModbusRegisterRangeEntry(), lex.getText(\"device.strings.defaultRange\"))"), @NiagaraProperty(name="validStatusRange", type="BModbusRegisterRangeTable", defaultValue="new BModbusRegisterRangeTable(new BModbusRegisterRangeEntry(), lex.getText(\"device.strings.defaultRange\"))"), @NiagaraProperty(name="validHoldingRegistersRange", type="BModbusRegisterRangeTable", defaultValue="new BModbusRegisterRangeTable(new BModbusRegisterRangeEntry(), lex.getText(\"device.strings.defaultRange\"))"), @NiagaraProperty(name="validInputRegistersRange", type="BModbusRegisterRangeTable", defaultValue="new BModbusRegisterRangeTable(new BModbusRegisterRangeEntry(), lex.getText(\"device.strings.defaultRange\"))"), @NiagaraProperty(name="points", type="BModbusServerPointDeviceExt", defaultValue="new BModbusServerPointDeviceExt()")})
public abstract class BModbusServerDevice
extends BModbusDevice
implements ModbusMessageConst,
ModbusErrorCodes {
    public static Lexicon lex = Lexicon.make((String)"modbusCore");
    @Generated
    public static final Property validCoilsRange = BModbusServerDevice.newProperty((int)0, (BValue)new BModbusRegisterRangeTable(new BModbusRegisterRangeEntry(), lex.getText("device.strings.defaultRange")), null);
    @Generated
    public static final Property validStatusRange = BModbusServerDevice.newProperty((int)0, (BValue)new BModbusRegisterRangeTable(new BModbusRegisterRangeEntry(), lex.getText("device.strings.defaultRange")), null);
    @Generated
    public static final Property validHoldingRegistersRange = BModbusServerDevice.newProperty((int)0, (BValue)new BModbusRegisterRangeTable(new BModbusRegisterRangeEntry(), lex.getText("device.strings.defaultRange")), null);
    @Generated
    public static final Property validInputRegistersRange = BModbusServerDevice.newProperty((int)0, (BValue)new BModbusRegisterRangeTable(new BModbusRegisterRangeEntry(), lex.getText("device.strings.defaultRange")), null);
    @Generated
    public static final Property points = BModbusServerDevice.newProperty((int)0, (BValue)new BModbusServerPointDeviceExt(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BModbusServerDevice.class);
    private int prevDeviceAddress;
    private BModbusServerNetwork serverNetwork;
    private boolean isDeviceStarted = false;
    private static final BIcon icon = BIcon.std((String)"deviceLocal.png");
    private IntHashMap inputRegisterByteArray = null;
    private IntHashMap holdingRegisterByteArray = null;
    private IntHashMap coilStatusBitSet = null;
    private IntHashMap inputStatusBitSet = null;

    @Generated
    public BModbusRegisterRangeTable getValidCoilsRange() {
        return (BModbusRegisterRangeTable)this.get(validCoilsRange);
    }

    @Generated
    public void setValidCoilsRange(BModbusRegisterRangeTable v) {
        this.set(validCoilsRange, (BValue)v, null);
    }

    @Generated
    public BModbusRegisterRangeTable getValidStatusRange() {
        return (BModbusRegisterRangeTable)this.get(validStatusRange);
    }

    @Generated
    public void setValidStatusRange(BModbusRegisterRangeTable v) {
        this.set(validStatusRange, (BValue)v, null);
    }

    @Generated
    public BModbusRegisterRangeTable getValidHoldingRegistersRange() {
        return (BModbusRegisterRangeTable)this.get(validHoldingRegistersRange);
    }

    @Generated
    public void setValidHoldingRegistersRange(BModbusRegisterRangeTable v) {
        this.set(validHoldingRegistersRange, (BValue)v, null);
    }

    @Generated
    public BModbusRegisterRangeTable getValidInputRegistersRange() {
        return (BModbusRegisterRangeTable)this.get(validInputRegistersRange);
    }

    @Generated
    public void setValidInputRegistersRange(BModbusRegisterRangeTable v) {
        this.set(validInputRegistersRange, (BValue)v, null);
    }

    @Generated
    public BModbusServerPointDeviceExt getPoints() {
        return (BModbusServerPointDeviceExt)this.get(points);
    }

    @Generated
    public void setPoints(BModbusServerPointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.coilStatusBitSet = this.initCoilMap();
        this.inputStatusBitSet = this.initStatusMap();
        this.holdingRegisterByteArray = this.initHoldingRegisterMap();
        this.inputRegisterByteArray = this.initInputRegisterMap();
        this.setStatusForDuplicateAddress();
        this.isDeviceStarted = true;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(validCoilsRange)) {
            if (this.coilStatusBitSet == null) {
                return;
            }
            Integer[] addresses = this.getValidCoilsRange().getValidAddressArray();
            int hashSize = addresses.length;
            if (hashSize <= 0) {
                hashSize = 1;
            }
            IntHashMap temp = new IntHashMap(hashSize);
            for (int i = 0; i < addresses.length; ++i) {
                Object value = this.coilStatusBitSet.get(addresses[i].intValue());
                if (value != null) {
                    temp.put(addresses[i].intValue(), value);
                    continue;
                }
                temp.put(addresses[i].intValue(), (Object)false);
            }
            this.coilStatusBitSet = temp;
            this.getValidCoilsRange().setPersistedData(this.coilStatusBitSet, false);
        } else if (property.equals(validStatusRange)) {
            if (this.inputStatusBitSet == null) {
                return;
            }
            Integer[] addresses = this.getValidStatusRange().getValidAddressArray();
            int hashSize = addresses.length;
            if (hashSize <= 0) {
                hashSize = 1;
            }
            IntHashMap temp = new IntHashMap(hashSize);
            for (int i = 0; i < addresses.length; ++i) {
                Object value = this.inputStatusBitSet.get(addresses[i].intValue());
                if (value != null) {
                    temp.put(addresses[i].intValue(), value);
                    continue;
                }
                temp.put(addresses[i].intValue(), (Object)false);
            }
            this.inputStatusBitSet = temp;
        } else if (property.equals(validHoldingRegistersRange)) {
            if (this.holdingRegisterByteArray == null) {
                return;
            }
            Integer[] addresses = this.getValidHoldingRegistersRange().getValidAddressArray();
            int hashSize = addresses.length * 2;
            if (hashSize <= 0) {
                hashSize = 1;
            }
            IntHashMap temp = new IntHashMap(hashSize);
            for (int i = 0; i < addresses.length; ++i) {
                Object value = this.holdingRegisterByteArray.get(addresses[i] * 2);
                if (value != null) {
                    temp.put(addresses[i] * 2, value);
                } else {
                    temp.put(addresses[i] * 2, (Object)0);
                }
                value = this.holdingRegisterByteArray.get(addresses[i] * 2 + 1);
                if (value != null) {
                    temp.put(addresses[i] * 2 + 1, value);
                    continue;
                }
                temp.put(addresses[i] * 2 + 1, (Object)0);
            }
            this.holdingRegisterByteArray = temp;
            this.getValidHoldingRegistersRange().setPersistedData(this.holdingRegisterByteArray, true);
        } else if (property.equals(validInputRegistersRange)) {
            if (this.inputRegisterByteArray == null) {
                return;
            }
            Integer[] addresses = this.getValidInputRegistersRange().getValidAddressArray();
            int hashSize = addresses.length * 2;
            if (hashSize <= 0) {
                hashSize = 1;
            }
            IntHashMap temp = new IntHashMap(hashSize);
            for (int i = 0; i < addresses.length; ++i) {
                Object value = this.inputRegisterByteArray.get(addresses[i] * 2);
                if (value != null) {
                    temp.put(addresses[i] * 2, value);
                } else {
                    temp.put(addresses[i] * 2, (Object)0);
                }
                value = this.inputRegisterByteArray.get(addresses[i] * 2 + 1);
                if (value != null) {
                    temp.put(addresses[i] * 2 + 1, value);
                    continue;
                }
                temp.put(addresses[i] * 2 + 1, (Object)0);
            }
            this.inputRegisterByteArray = temp;
        }
        if (property.equals(deviceAddress) && this.isDeviceStarted) {
            this.serverNetwork.removeDeviceAddress(this.prevDeviceAddress);
            this.setStatusForDuplicateAddress();
        }
    }

    private IntHashMap initCoilMap() {
        BModbusRegisterRangeEntry[] registerRangeEntries;
        Integer[] addresses = this.getValidCoilsRange().getValidAddressArray();
        int hashSize = addresses.length;
        if (hashSize <= 0) {
            hashSize = 1;
        }
        IntHashMap temp = new IntHashMap(hashSize);
        for (BModbusRegisterRangeEntry rangeEntry : registerRangeEntries = this.getValidCoilsRange().getEnabledModbusRegisterRangeList()) {
            int rangeSize = rangeEntry.getSize();
            byte[] persistedData = rangeEntry.getPersistedData();
            if (persistedData == null) {
                persistedData = new byte[rangeSize];
                for (int i = 0; i < persistedData.length; ++i) {
                    persistedData[i] = 0;
                }
            }
            int startingAddress = rangeEntry.getStartingAddressOffset() - 1;
            for (int i = 0; i < rangeEntry.getSize(); ++i) {
                temp.put(startingAddress++, (Object)(persistedData[i] != 0 ? 1 : 0));
            }
            rangeEntry.setPersistedData(persistedData);
        }
        return temp;
    }

    private IntHashMap initStatusMap() {
        Integer[] addresses = this.getValidStatusRange().getValidAddressArray();
        int hashSize = addresses.length;
        if (hashSize <= 0) {
            hashSize = 1;
        }
        IntHashMap temp = new IntHashMap(hashSize);
        for (int i = 0; i < addresses.length; ++i) {
            temp.put(addresses[i].intValue(), (Object)false);
        }
        return temp;
    }

    private IntHashMap initHoldingRegisterMap() {
        BModbusRegisterRangeEntry[] registerRangeEntries;
        Integer[] addresses = this.getValidHoldingRegistersRange().getValidAddressArray();
        int hashSize = addresses.length * 2;
        if (hashSize <= 0) {
            hashSize = 1;
        }
        IntHashMap temp = new IntHashMap(hashSize);
        for (BModbusRegisterRangeEntry rangeEntry : registerRangeEntries = this.getValidHoldingRegistersRange().getEnabledModbusRegisterRangeList()) {
            int rangeSize = rangeEntry.getSize();
            byte[] persistedData = rangeEntry.getPersistedData();
            if (persistedData == null) {
                persistedData = new byte[rangeSize * 2];
                for (int i = 0; i < persistedData.length; ++i) {
                    persistedData[i] = 0;
                }
            }
            int startingAddress = rangeEntry.getStartingAddressOffset() - 1;
            for (int i = 0; i < rangeEntry.getSize(); ++i) {
                temp.put(startingAddress * 2, (Object)persistedData[i * 2]);
                temp.put(startingAddress * 2 + 1, (Object)persistedData[i * 2 + 1]);
                ++startingAddress;
            }
            rangeEntry.setPersistedData(persistedData);
        }
        return temp;
    }

    private IntHashMap initInputRegisterMap() {
        Integer[] addresses = this.getValidInputRegistersRange().getValidAddressArray();
        int hashSize = addresses.length * 2;
        if (hashSize <= 0) {
            hashSize = 1;
        }
        IntHashMap temp = new IntHashMap(hashSize);
        for (int i = 0; i < addresses.length; ++i) {
            temp.put(addresses[i] * 2, (Object)0);
            temp.put(addresses[i] * 2 + 1, (Object)0);
        }
        return temp;
    }

    public String toString(Context context) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("[" + this.getDeviceAddress() + "]");
        return sb.toString();
    }

    public void doPing() {
        if (this.isDisabled() || this.isFault()) {
            return;
        }
        if (this.modbusNet() == null) {
            this.pingFail("No modbus network found");
            return;
        }
        if (this.modbusNet().getModbusLog().isTraceOn()) {
            this.modbusNet().getModbusLog().trace("ping(): ModbusServerDevice " + this.getName() + "[" + this.getDeviceAddress() + "] is up");
        }
        this.pingOk();
    }

    public boolean isHoldingRegisterAddressValid(int address, int numRegisters) {
        for (int i = address * 2; i < (address + numRegisters) * 2; ++i) {
            if (this.holdingRegisterByteArray.get(i) != null) continue;
            return false;
        }
        return true;
    }

    public byte[] getHoldingRegisterValues(int address, int numRegisters) throws ModbusException {
        int i;
        byte[] registerData = new byte[numRegisters * 2];
        for (i = address * 2; i < (address + numRegisters) * 2; ++i) {
            if (this.holdingRegisterByteArray.get(i) != null) continue;
            throw new ModbusException(103);
        }
        for (i = 0; i < numRegisters * 2; ++i) {
            registerData[i] = (Byte)this.holdingRegisterByteArray.get(address * 2 + i);
        }
        return registerData;
    }

    public void setHoldingRegisterValues(int address, byte[] data) throws ModbusException {
        for (int i = 0; i < data.length; ++i) {
            if (this.holdingRegisterByteArray.get(address * 2 + i) == null) {
                throw new ModbusException(103);
            }
            this.holdingRegisterByteArray.put(address * 2 + i, (Object)data[i]);
            this.getValidHoldingRegistersRange().setPersistedData(this.holdingRegisterByteArray, true);
        }
    }

    public boolean isInputRegisterAddressValid(int address, int numRegisters) {
        for (int i = address * 2; i < (address + numRegisters) * 2; ++i) {
            if (this.inputRegisterByteArray.get(i) != null) continue;
            return false;
        }
        return true;
    }

    public byte[] getInputRegisterValues(int address, int numRegisters) throws ModbusException {
        int i;
        byte[] registerData = new byte[numRegisters * 2];
        for (i = address * 2; i < (address + numRegisters) * 2; ++i) {
            if (this.inputRegisterByteArray.get(i) != null) continue;
            throw new ModbusException(103);
        }
        for (i = 0; i < numRegisters * 2; ++i) {
            registerData[i] = (Byte)this.inputRegisterByteArray.get(address * 2 + i);
        }
        return registerData;
    }

    public void setInputRegisterValues(int address, byte[] data) throws ModbusException {
        for (int i = 0; i < data.length; ++i) {
            if (this.inputRegisterByteArray.get(address * 2 + i) == null) {
                throw new ModbusException(103);
            }
            this.inputRegisterByteArray.put(address * 2 + i, (Object)data[i]);
        }
    }

    public boolean isCoilAddressValid(int address, int numRegisters) {
        for (int i = address; i < address + numRegisters; ++i) {
            if (this.coilStatusBitSet.get(i) != null) continue;
            return false;
        }
        return true;
    }

    public byte[] getCoilStatusValues(int address, int numRegisters) throws ModbusException {
        int byteCount = numRegisters / 8;
        if (numRegisters % 8 != 0) {
            ++byteCount;
        }
        byte[] registerData = new byte[byteCount];
        for (int i = address; i < address + numRegisters; ++i) {
            if (this.coilStatusBitSet.get(i) != null) continue;
            throw new ModbusException(103);
        }
        int bitIndex = 0;
        int byteIndex = 0;
        for (int i = 0; i < numRegisters; ++i) {
            int dataMask = 1 << bitIndex;
            registerData[byteIndex] = (Boolean)this.coilStatusBitSet.get(address + i) != false ? (byte)(registerData[byteIndex] | dataMask) : (byte)(registerData[byteIndex] & ~dataMask);
            if (++bitIndex != 8) continue;
            bitIndex = 0;
            ++byteIndex;
        }
        return registerData;
    }

    public void setCoilStatusValue(int address, boolean value) throws ModbusException {
        if (this.coilStatusBitSet.get(address) == null) {
            throw new ModbusException(103);
        }
        this.coilStatusBitSet.put(address, (Object)value);
        this.getValidCoilsRange().setPersistedData(this.coilStatusBitSet, false);
    }

    public void setCoilStatusValue(int address, int numberCoils, byte[] data) throws ModbusException {
        block5: {
            try {
                int bitIndex = 0;
                int byteIndex = 0;
                for (int i = 0; i < numberCoils; ++i) {
                    int dataMask = 1 << bitIndex;
                    this.setCoilStatusValue(address, (data[byteIndex] & dataMask) != 0);
                    ++address;
                    if (++bitIndex < 8) continue;
                    bitIndex = 0;
                    ++byteIndex;
                }
                this.getValidCoilsRange().setPersistedData(this.coilStatusBitSet, false);
            }
            catch (ModbusException e) {
                if (this.modbusNet() != null && this.modbusNet().getModbusLog().isTraceOn()) {
                    this.modbusNet().getModbusLog().trace(this.getName() + ".setCoilStatusValue() caught Exception: ", (Throwable)((Object)e));
                }
                throw e;
            }
            catch (Exception e) {
                if (this.modbusNet() == null) break block5;
                this.modbusNet().getModbusLog().error(this.getName() + ".setCoilStatusValue() caught Exception: ", (Throwable)e);
            }
        }
    }

    public boolean isStatusAddressValid(int address, int numRegisters) {
        for (int i = address; i < address + numRegisters; ++i) {
            if (this.inputStatusBitSet.get(i) != null) continue;
            return false;
        }
        return true;
    }

    public byte[] getInputStatusValues(int address, int numRegisters) throws ModbusException {
        int byteCount = numRegisters / 8;
        if (numRegisters % 8 != 0) {
            ++byteCount;
        }
        byte[] registerData = new byte[byteCount];
        for (int i = address; i < address + numRegisters; ++i) {
            if (this.inputStatusBitSet.get(i) != null) continue;
            throw new ModbusException(103);
        }
        int bitIndex = 0;
        int byteIndex = 0;
        for (int i = 0; i < numRegisters; ++i) {
            int dataMask = 1 << bitIndex;
            registerData[byteIndex] = (Boolean)this.inputStatusBitSet.get(address + i) != false ? (byte)(registerData[byteIndex] | dataMask) : (byte)(registerData[byteIndex] & ~dataMask);
            if (++bitIndex != 8) continue;
            bitIndex = 0;
            ++byteIndex;
        }
        return registerData;
    }

    public void setInputStatusValue(int address, boolean value) throws ModbusException {
        if (this.inputStatusBitSet.get(address) == null) {
            throw new ModbusException(103);
        }
        this.inputStatusBitSet.put(address, (Object)value);
    }

    public byte[] getFileRecordData(int fileNum, int startingRec, int recLength) throws ModbusException {
        BModbusServerStringRecord[] childStringRecords = this.getStringFileRecords();
        if (childStringRecords == null) {
            throw new ModbusException(103);
        }
        for (int i = 0; i < childStringRecords.length; ++i) {
            if (childStringRecords[i] == null || childStringRecords[i].getFileNumber() != fileNum || !childStringRecords[i].containsRecords(startingRec, recLength)) continue;
            return childStringRecords[i].getBytes(startingRec, recLength);
        }
        throw new ModbusException(103);
    }

    public byte[] setFileRecordData(int fileNum, int startingRec, int recLength, byte[] data) throws ModbusException {
        BModbusServerStringRecord[] childStringRecords = this.getStringFileRecords();
        if (childStringRecords == null) {
            throw new ModbusException(103);
        }
        for (int i = 0; i < childStringRecords.length; ++i) {
            if (childStringRecords[i] == null || childStringRecords[i].getFileNumber() != fileNum || !childStringRecords[i].containsRecords(startingRec, recLength)) continue;
            return childStringRecords[i].setBytes(data, startingRec, recLength);
        }
        throw new ModbusException(103);
    }

    private BModbusServerStringRecord[] getStringFileRecords() {
        ArrayList list = new ArrayList();
        this.getFileRecords((BComponent)this, BModbusServerStringRecord.TYPE, list);
        return list.toArray(new BModbusServerStringRecord[0]);
    }

    private void getFileRecords(BComponent comp, Type fileType, ArrayList list) {
        SlotCursor cursor = comp.loadSlots().getProperties();
        while (cursor.nextComponent()) {
            BComponent kid = cursor.get().asComponent();
            if (kid.getType().is(fileType)) {
                list.add(kid);
            }
            this.getFileRecords(kid, fileType, list);
        }
    }

    @Override
    public BPointDeviceExt getPointDeviceExt() {
        return this.getPoints();
    }

    @Override
    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"CoilRegisterMap", 2);
        this.writeIntHashMap(out, this.coilStatusBitSet);
        out.startProps();
        out.trTitle((Object)"inputStatusRegisterMap", 2);
        this.writeIntHashMap(out, this.inputStatusBitSet);
        out.startProps();
        out.trTitle((Object)"holdingRegisterMap", 2);
        this.writeIntHashMap(out, this.holdingRegisterByteArray);
        out.startProps();
        out.trTitle((Object)"inputRegisterMap", 2);
        this.writeIntHashMap(out, this.inputRegisterByteArray);
    }

    private void writeIntHashMap(SpyWriter out, IntHashMap map) {
        IntHashMap.Iterator iterator = map.iterator();
        while (iterator.hasNext()) {
            Object value = iterator.next();
            if (value instanceof Byte) {
                int lowByte = ((Byte)value).intValue() & 0xFF;
                int regAddr = iterator.key() / 2;
                int hiByte = ((Byte)iterator.next()).intValue() & 0xFF;
                int intValue = (hiByte << 8) + lowByte;
                String s = String.format("%04x", intValue);
                out.prop((Object)regAddr, (Object)("0x" + s));
                continue;
            }
            if (!(value instanceof Boolean)) continue;
            out.prop((Object)iterator.key(), value);
        }
        out.endProps();
    }

    private void setStatusForDuplicateAddress() {
        this.serverNetwork = (BModbusServerNetwork)this.getNetwork();
        if (this.serverNetwork.isUniqueDeviceAddress(this.getDeviceAddress())) {
            this.serverNetwork.addDeviceAddress(this.getDeviceAddress());
            this.prevDeviceAddress = this.getDeviceAddress();
            if (this.getStatus() == BStatus.fault && this.getFaultCause().contains("Duplicate Device Address")) {
                this.setStatus(BStatus.DEFAULT);
                this.setFaultCause("");
            }
        } else {
            this.setStatus(BStatus.fault);
            this.setFaultCause("Duplicate Device Address");
        }
    }

    public BIcon getIcon() {
        return icon;
    }
}

