/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.datatypes;

import com.tridium.modbusCore.datatypes.BModbusFileRecord;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BBlob;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="writeOnInputChange", type="boolean", defaultValue="false"), @NiagaraProperty(name="padding", type="boolean", defaultValue="false", facets={@Facet(value="BFacets.make(BFacets.TRUE_TEXT, BString.make(\"Pad with nulls\"), BFacets.FALSE_TEXT, BString.make(\"Pad with spaces\"))")}), @NiagaraProperty(name="input", type="String", defaultValue="", flags=8, facets={@Facet(value="BFacets.make(BFacets.MULTI_LINE, BBoolean.TRUE)")}), @NiagaraProperty(name="output", type="String", defaultValue="", flags=267, facets={@Facet(value="BFacets.make(BFacets.MULTI_LINE, BBoolean.TRUE)")})})
@NiagaraAction(name="write", flags=24)
@NiagaraTopic(name="writeSuccessful", flags=8)
public abstract class BModbusStringRecord
extends BModbusFileRecord {
    @Generated
    public static final Property writeOnInputChange = BModbusStringRecord.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property padding = BModbusStringRecord.newProperty((int)0, (boolean)false, (BFacets)BFacets.make((String)"trueText", (BIDataValue)BString.make((String)"Pad with nulls"), (String)"falseText", (BIDataValue)BString.make((String)"Pad with spaces")));
    @Generated
    public static final Property input = BModbusStringRecord.newProperty((int)8, (String)"", (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property output = BModbusStringRecord.newProperty((int)267, (String)"", (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Action write = BModbusStringRecord.newAction((int)24, null);
    @Generated
    public static final Topic writeSuccessful = BModbusStringRecord.newTopic((int)8, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BModbusStringRecord.class);

    @Generated
    public boolean getWriteOnInputChange() {
        return this.getBoolean(writeOnInputChange);
    }

    @Generated
    public void setWriteOnInputChange(boolean v) {
        this.setBoolean(writeOnInputChange, v, null);
    }

    @Generated
    public boolean getPadding() {
        return this.getBoolean(padding);
    }

    @Generated
    public void setPadding(boolean v) {
        this.setBoolean(padding, v, null);
    }

    @Generated
    public String getInput() {
        return this.getString(input);
    }

    @Generated
    public void setInput(String v) {
        this.setString(input, v, null);
    }

    @Generated
    public String getOutput() {
        return this.getString(output);
    }

    @Generated
    public void setOutput(String v) {
        this.setString(output, v, null);
    }

    @Generated
    public void write() {
        this.invoke(write, null, null);
    }

    @Generated
    public void fireWriteSuccessful(BValue event) {
        this.fire(writeSuccessful, event, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(input) && this.getWriteOnInputChange()) {
            this.write();
        }
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        if (action.equals(write)) {
            return this.getNetwork().postAsync((Runnable)new Invocation((BComponent)this, action, arg, cx));
        }
        return super.post(action, arg, cx);
    }

    public abstract void doWrite();

    protected void setOutputBytes(byte[] fileData) {
        if (fileData == null) {
            this.setData(BBlob.DEFAULT);
            this.setOutput("");
        } else {
            this.setData(BBlob.make((byte[])fileData));
            this.setOutput(new String(fileData).trim());
        }
    }

    protected byte[] getInputBytes(int recLength, String padding) {
        return BModbusStringRecord.getStringBytes(this.getInput(), recLength, padding);
    }

    protected static byte[] getStringBytes(String str, int recLength, String padding) {
        byte[] result = new byte[recLength * 2];
        int inputLength = 0;
        if (str != null) {
            byte[] inputBytes = str.getBytes();
            inputLength = inputBytes.length;
            if (inputLength >= result.length) {
                System.arraycopy(inputBytes, 0, result, 0, result.length);
                return result;
            }
            System.arraycopy(inputBytes, 0, result, 0, inputLength);
        }
        byte[] padBytes = null;
        padBytes = padding == null ? new byte[]{0} : padding.getBytes();
        if (padBytes != null && padBytes.length > 0) {
            int index = inputLength;
            block0: while (index < result.length) {
                for (int i = 0; i < padBytes.length; ++i) {
                    result[index] = padBytes[i];
                    if (++index >= result.length) continue block0;
                }
            }
        }
        return result;
    }

    protected static byte[] padBytes(byte[] inBytes, int recLength, String padding) {
        byte[] result = new byte[recLength * 2];
        int inputLength = 0;
        if (inBytes != null) {
            inputLength = inBytes.length;
            if (inputLength >= result.length) {
                System.arraycopy(inBytes, 0, result, 0, result.length);
                return result;
            }
            System.arraycopy(inBytes, 0, result, 0, inputLength);
        }
        byte[] padBytes = null;
        padBytes = padding == null ? new byte[]{0} : padding.getBytes();
        if (padBytes != null && padBytes.length > 0) {
            int index = inputLength;
            block0: while (index < result.length) {
                for (int i = 0; i < padBytes.length; ++i) {
                    result[index] = padBytes[i];
                    if (++index >= result.length) continue block0;
                }
            }
        }
        return result;
    }
}

