/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.client.point;

import com.tridium.modbusCore.ModbusException;
import com.tridium.modbusCore.client.BModbusClientDevice;
import com.tridium.modbusCore.client.datatypes.BDevicePollConfigEntry;
import com.tridium.modbusCore.client.point.BModbusClientProxyExt;
import com.tridium.modbusCore.datatypes.BFlexAddress;
import com.tridium.modbusCore.enums.BRegisterTypeEnum;
import com.tridium.modbusCore.enums.BRegisterTypesEnum;
import com.tridium.modbusCore.messages.ModbusReadRequest;
import com.tridium.modbusCore.messages.ModbusResponse;
import com.tridium.modbusCore.point.BIModbusStringProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="numberRegisters", type="int", defaultValue="1", facets={@Facet(value="BFacets.makeInt(null, 1, Integer.MAX_VALUE)")})
public class BModbusClientStringProxyExt
extends BModbusClientProxyExt
implements BIModbusStringProxyExt {
    @Generated
    public static final Property numberRegisters = BModbusClientStringProxyExt.newProperty((int)0, (int)1, (BFacets)BFacets.makeInt(null, (int)1, (int)Integer.MAX_VALUE));
    @Generated
    public static final Type TYPE = Sys.loadType(BModbusClientStringProxyExt.class);

    @Override
    @Generated
    public int getNumberRegisters() {
        return this.getInt(numberRegisters);
    }

    @Override
    @Generated
    public void setNumberRegisters(int v) {
        this.setInt(numberRegisters, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BReadWriteMode getMode() {
        return BReadWriteMode.readonly;
    }

    @Override
    public void read() {
        if (this.configFault) {
            return;
        }
        BModbusClientDevice device = (BModbusClientDevice)this.getDevice();
        int address = device.getDeviceAddress();
        int pointAddress = this.getAbsoluteAddress().getDataAddress();
        int size = this.getNumberRegisters();
        int code = 3;
        ModbusReadRequest req = new ModbusReadRequest(device.modbusNet().getModbusMode(), device, address, code, pointAddress, size);
        ModbusResponse rsp = (ModbusResponse)device.sendModbusMessage(req);
        if (rsp == null) {
            rsp = new ModbusResponse(device.modbusNet().getModbusMode(), device);
            rsp.exceptionCode = 9;
        }
        this.setOutValues(rsp);
    }

    public void setOutValues(ModbusResponse rec) {
        if (!rec.isError()) {
            this.setStringOutValues(rec);
        } else {
            this.readFail(rec.getExceptionString());
        }
    }

    private void setStringOutValues(ModbusResponse rec) {
        String stringValue;
        try {
            stringValue = rec.getString(this.getNumberRegisters());
        }
        catch (IllegalArgumentException e) {
            this.readFail("error parsing String value (" + e + ")");
            return;
        }
        this.readOk((BStatusValue)new BStatusString(stringValue));
    }

    @Override
    public BRegisterTypesEnum determineRegisterType() {
        return BRegisterTypesEnum.holdingRegister;
    }

    @Override
    public BEnum getRegisterType() {
        return BRegisterTypeEnum.holding;
    }

    @Override
    public int determineNumRegisters() {
        return this.getNumberRegisters();
    }

    @Override
    public boolean isValidAddress(BFlexAddress addr) {
        if (addr.isModbusFormat() && addr.isModbusAnalogAddress()) {
            return addr.isModbusHoldingAddress();
        }
        return addr.isValid();
    }

    @Override
    public void devicePoll(BDevicePollConfigEntry entry) {
        block3: {
            if (this.configFault || this.isUnoperational()) {
                return;
            }
            BModbusClientDevice device = (BModbusClientDevice)this.getDevice();
            int numRegisters = this.getNumberRegisters();
            ModbusResponse rsp = new ModbusResponse(device.modbusNet().getModbusMode(), device);
            int pointAddress = this.getAbsoluteAddress().getDataAddress();
            try {
                rsp.data = device.getHoldingRegisterValues(pointAddress, numRegisters, entry);
                rsp.exceptionCode = device.getHoldingRegistersReadStatus(pointAddress, numRegisters, entry).getErrorCode();
                rsp.byteCount = (byte)rsp.data.length;
                rsp.numberPoints = numRegisters;
                this.setOutValues(rsp);
            }
            catch (ModbusException e) {
                if (!this.modbusNet().getModbusLog().isTraceOn()) break block3;
                this.modbusNet().getModbusLog().trace(this.getParent().getName() + ">>> devicePoll error", (Throwable)((Object)e));
            }
        }
    }

    @Override
    public void changed(Property prop, Context context) {
        if (!this.isRunning()) {
            super.changed(prop, context);
            return;
        }
        if (prop.equals(numberRegisters)) {
            this.setStale(true, null);
            if (this.getDevice() != null) {
                this.adjustPollSubscription();
            }
        } else {
            super.changed(prop, context);
        }
    }
}

