/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.client.datatypes;

import com.tridium.modbusCore.BModbusDevice;
import com.tridium.modbusCore.BModbusNetwork;
import com.tridium.modbusCore.client.BModbusClientDevice;
import com.tridium.modbusCore.client.datatypes.BCommStatus;
import com.tridium.modbusCore.datatypes.BModbusStringRecord;
import com.tridium.modbusCore.messages.ModbusReadFileRequest;
import com.tridium.modbusCore.messages.ModbusResponse;
import com.tridium.modbusCore.messages.ModbusWriteFileRequest;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="lastSuccessfulWrite", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=67), @NiagaraProperty(name="lastFailedWrite", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=67), @NiagaraProperty(name="writeStatus", type="BCommStatus", defaultValue="new BCommStatus(ModbusMessageConst.OK_NOT_ACTIVE)", flags=67), @NiagaraProperty(name="lastSuccessfulRead", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=67), @NiagaraProperty(name="lastFailedRead", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=67), @NiagaraProperty(name="readStatus", type="BCommStatus", defaultValue="new BCommStatus(ModbusMessageConst.OK_NOT_ACTIVE)", flags=67)})
@NiagaraAction(name="read", flags=24)
@NiagaraTopic(name="readSuccessful", flags=8)
public class BModbusClientStringRecord
extends BModbusStringRecord {
    @Generated
    public static final Property lastSuccessfulWrite = BModbusClientStringRecord.newProperty((int)67, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property lastFailedWrite = BModbusClientStringRecord.newProperty((int)67, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property writeStatus = BModbusClientStringRecord.newProperty((int)67, (BValue)new BCommStatus(-2), null);
    @Generated
    public static final Property lastSuccessfulRead = BModbusClientStringRecord.newProperty((int)67, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property lastFailedRead = BModbusClientStringRecord.newProperty((int)67, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property readStatus = BModbusClientStringRecord.newProperty((int)67, (BValue)new BCommStatus(-2), null);
    @Generated
    public static final Action read = BModbusClientStringRecord.newAction((int)24, null);
    @Generated
    public static final Topic readSuccessful = BModbusClientStringRecord.newTopic((int)8, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BModbusClientStringRecord.class);

    @Generated
    public BAbsTime getLastSuccessfulWrite() {
        return (BAbsTime)this.get(lastSuccessfulWrite);
    }

    @Generated
    public void setLastSuccessfulWrite(BAbsTime v) {
        this.set(lastSuccessfulWrite, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastFailedWrite() {
        return (BAbsTime)this.get(lastFailedWrite);
    }

    @Generated
    public void setLastFailedWrite(BAbsTime v) {
        this.set(lastFailedWrite, (BValue)v, null);
    }

    @Generated
    public BCommStatus getWriteStatus() {
        return (BCommStatus)this.get(writeStatus);
    }

    @Generated
    public void setWriteStatus(BCommStatus v) {
        this.set(writeStatus, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastSuccessfulRead() {
        return (BAbsTime)this.get(lastSuccessfulRead);
    }

    @Generated
    public void setLastSuccessfulRead(BAbsTime v) {
        this.set(lastSuccessfulRead, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastFailedRead() {
        return (BAbsTime)this.get(lastFailedRead);
    }

    @Generated
    public void setLastFailedRead(BAbsTime v) {
        this.set(lastFailedRead, (BValue)v, null);
    }

    @Generated
    public BCommStatus getReadStatus() {
        return (BCommStatus)this.get(readStatus);
    }

    @Generated
    public void setReadStatus(BCommStatus v) {
        this.set(readStatus, (BValue)v, null);
    }

    @Generated
    public void read() {
        this.invoke(read, null, null);
    }

    @Generated
    public void fireReadSuccessful(BValue event) {
        this.fire(readSuccessful, event, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BModbusClientStringRecord() {
        this.setFlags((Slot)data, 259);
    }

    @Override
    public IFuture post(Action action, BValue arg, Context cx) {
        if (action.equals(read)) {
            return this.getNetwork().postAsync((Runnable)new Invocation((BComponent)this, action, arg, cx));
        }
        return super.post(action, arg, cx);
    }

    @Override
    public void doWrite() {
        BModbusDevice device = this.getDevice();
        if (device == null || device.isFault()) {
            BCommStatus tmp = new BCommStatus(-7);
            this.getWriteStatus().setErrorCode(tmp.getErrorCode());
            this.getWriteStatus().setErrorDescription(tmp.getErrorDescription());
            return;
        }
        if (device.isDown()) {
            BCommStatus tmp = new BCommStatus(-6);
            this.getWriteStatus().setErrorCode(tmp.getErrorCode());
            this.getWriteStatus().setErrorDescription(tmp.getErrorDescription());
            return;
        }
        if (device.isDisabled()) {
            BCommStatus tmp = new BCommStatus(-8);
            this.getWriteStatus().setErrorCode(tmp.getErrorCode());
            this.getWriteStatus().setErrorDescription(tmp.getErrorDescription());
            return;
        }
        if (device instanceof BModbusClientDevice) {
            this.writeRecords((BModbusClientDevice)device);
        }
    }

    private void writeRecords(BModbusClientDevice device) {
        BModbusNetwork network = this.getNetwork();
        byte[] inputBytes = this.getInputBytes(this.getRecordLength(), this.getPadding() ? null : " ");
        int startIdx = 0;
        int lastIdx = inputBytes.length - 1;
        int endIdx = Math.min(lastIdx, 237);
        int startRecNum = this.getStartingRecordNumber();
        byte[] response = null;
        while (endIdx <= lastIdx) {
            ModbusWriteFileRequest req = new ModbusWriteFileRequest(network.getModbusMode(), device, device.getDeviceAddress(), this.getFileNumber(), startRecNum, (endIdx - startIdx + 1) / 2, inputBytes, startIdx, endIdx);
            ModbusResponse resp = (ModbusResponse)device.sendModbusMessage(req);
            if (resp == null) {
                resp = new ModbusResponse(network.getModbusMode(), device);
                resp.exceptionCode = 9;
            }
            if (resp.isError() && resp.exceptionCode != 5) {
                BCommStatus tmp = new BCommStatus(resp.exceptionCode);
                this.getWriteStatus().setErrorCode(tmp.getErrorCode());
                this.getWriteStatus().setErrorDescription(tmp.getErrorDescription());
                this.setLastFailedWrite(Clock.time());
                return;
            }
            response = BModbusClientStringRecord.appendBytes(response, resp.data);
            if (endIdx >= lastIdx) break;
            startRecNum += (endIdx - startIdx + 1) / 2;
            startIdx = endIdx;
            endIdx = Math.min(lastIdx, endIdx + 237);
        }
        BCommStatus tmp = new BCommStatus(0);
        this.getWriteStatus().setErrorCode(tmp.getErrorCode());
        this.getWriteStatus().setErrorDescription(tmp.getErrorDescription());
        this.setLastSuccessfulWrite(Clock.time());
        this.setOutputBytes(response);
        this.fireWriteSuccessful(null);
    }

    public void doRead() {
        BModbusDevice device = this.getDevice();
        if (device == null || device.isFault()) {
            BCommStatus tmp = new BCommStatus(-7);
            this.getReadStatus().setErrorCode(tmp.getErrorCode());
            this.getReadStatus().setErrorDescription(tmp.getErrorDescription());
            return;
        }
        if (device.isDown()) {
            BCommStatus tmp = new BCommStatus(-6);
            this.getReadStatus().setErrorCode(tmp.getErrorCode());
            this.getReadStatus().setErrorDescription(tmp.getErrorDescription());
            return;
        }
        if (device.isDisabled()) {
            BCommStatus tmp = new BCommStatus(-8);
            this.getReadStatus().setErrorCode(tmp.getErrorCode());
            this.getReadStatus().setErrorDescription(tmp.getErrorDescription());
            return;
        }
        if (device instanceof BModbusClientDevice) {
            this.readRecords((BModbusClientDevice)device);
        }
    }

    private void readRecords(BModbusClientDevice device) {
        BModbusNetwork network = this.getNetwork();
        int startIdx = this.getStartingRecordNumber();
        int remainingLength = this.getRecordLength();
        int recLength = Math.min(remainingLength, 119);
        byte[] response = null;
        while (recLength > 0) {
            ModbusReadFileRequest req = new ModbusReadFileRequest(network.getModbusMode(), device, device.getDeviceAddress(), this.getFileNumber(), startIdx, recLength);
            ModbusResponse resp = (ModbusResponse)device.sendModbusMessage(req);
            if (resp == null) {
                resp = new ModbusResponse(network.getModbusMode(), device);
                resp.exceptionCode = 9;
            }
            if (resp.isError() && resp.exceptionCode != 5) {
                BCommStatus tmp = new BCommStatus(resp.exceptionCode);
                this.getReadStatus().setErrorCode(tmp.getErrorCode());
                this.getReadStatus().setErrorDescription(tmp.getErrorDescription());
                this.setLastFailedRead(Clock.time());
                return;
            }
            response = BModbusClientStringRecord.appendBytes(response, resp.data);
            startIdx += recLength;
            recLength = Math.min(remainingLength -= recLength, 119);
        }
        BCommStatus tmp = new BCommStatus(0);
        this.getReadStatus().setErrorCode(tmp.getErrorCode());
        this.getReadStatus().setErrorDescription(tmp.getErrorDescription());
        this.setLastSuccessfulRead(Clock.time());
        this.setOutputBytes(response);
        this.fireReadSuccessful(null);
    }

    private static byte[] appendBytes(byte[] data1, byte[] data2) {
        if (data1 == null && data2 == null) {
            return null;
        }
        int data1Length = 0;
        if (data1 != null) {
            data1Length = data1.length;
        }
        int data2Length = 0;
        if (data2 != null) {
            data2Length = data2.length;
        }
        byte[] result = new byte[data1Length + data2Length];
        if (data1Length > 0) {
            System.arraycopy(data1, 0, result, 0, data1Length);
        }
        if (data2Length > 0) {
            System.arraycopy(data2, 0, result, data1Length, data2Length);
        }
        return result;
    }
}

