/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.client.datatypes;

import com.tridium.basicdriver.MessageListener;
import com.tridium.basicdriver.message.Message;
import com.tridium.modbusCore.client.BModbusClientDevice;
import com.tridium.modbusCore.client.datatypes.BCommStatus;
import com.tridium.modbusCore.client.datatypes.BModbusClientPresetComponent;
import com.tridium.modbusCore.client.datatypes.BModbusClientPresetRegister;
import com.tridium.modbusCore.datatypes.BFlexAddress;
import com.tridium.modbusCore.enums.BDataByteOrderEnum;
import com.tridium.modbusCore.enums.BDataTypeEnum;
import com.tridium.modbusCore.messages.ModbusResponse;
import com.tridium.modbusCore.messages.ModbusWriteRequest;
import com.tridium.modbusCore.util.ByteConverterUtil;
import com.tridium.modbusCore.util.DataTypeUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.ICoalesceable;

@NiagaraType
@NiagaraProperty(name="dataType", type="BDataTypeEnum", defaultValue="BDataTypeEnum.integerType")
@NiagaraAction(name="addPresetRegisterValue", parameterType="BModbusClientPresetRegister", defaultValue="new BModbusClientPresetRegister()")
public class BModbusClientPresetRegisters
extends BModbusClientPresetComponent
implements MessageListener {
    @Generated
    public static final Property dataType = BModbusClientPresetRegisters.newProperty((int)0, (BValue)BDataTypeEnum.integerType, null);
    @Generated
    public static final Action addPresetRegisterValue = BModbusClientPresetRegisters.newAction((int)0, (BValue)new BModbusClientPresetRegister(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BModbusClientPresetRegisters.class);

    @Generated
    public BDataTypeEnum getDataType() {
        return (BDataTypeEnum)this.get(dataType);
    }

    @Generated
    public void setDataType(BDataTypeEnum v) {
        this.set(dataType, (BValue)v, null);
    }

    @Generated
    public void addPresetRegisterValue(BModbusClientPresetRegister parameter) {
        this.invoke(addPresetRegisterValue, (BValue)parameter, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void writePresetValues() {
        byte[] dataOut;
        ByteArrayOutputStream oStream = new ByteArrayOutputStream();
        int address = this.getDevice().getDeviceAddress();
        int baseAddress = this.getAbsoluteStartingAddress().getDataAddress();
        boolean isPresetMultiple = this.getDevice().isPresetMultiple();
        BModbusClientPresetRegister[] kids = (BModbusClientPresetRegister[])this.getChildren(BModbusClientPresetRegister.class);
        if (kids == null || kids.length <= 0) {
            return;
        }
        for (int i = 0; i < kids.length; ++i) {
            BModbusClientPresetRegister kid = kids[i];
            double value = kid.getValue().getDouble();
            dataOut = this.isDataTypeInteger() ? this.setIntegerByteArray((float)value) : (this.isDataTypeLong() ? this.setLongByteArray((float)value) : (this.isDataType64BitLong() ? ByteConverterUtil.to8ByteLongArray(value, this.getDevice().getLong64BitDataByteOrder(), this.isDataTypeSigned()) : (this.isDataTypeDouble() ? ByteConverterUtil.to8ByteDoubleArray(value, this.getDevice().getDouble64BitDataByteOrder()) : this.setFloatByteArray((float)value))));
            if (!isPresetMultiple) {
                int count = DataTypeUtil.getRegisterCount(this.getDataType());
                int pointAddress = baseAddress + i * count;
                int code = 6;
                ModbusWriteRequest req = new ModbusWriteRequest(this.getNetwork().getModbusMode(), this.getDevice(), address, code, pointAddress, 1, dataOut);
                if (count > 1) {
                    this.getNetwork().postWrite(new ModbusWriteFloatRequest(kid, req, dataOut, i == kids.length - 1));
                    continue;
                }
                kid.setLastChild(i == kids.length - 1);
                this.getNetwork().postWrite(new BModbusClientPresetComponent.ModbusClientWriteRequest(this, req, kid));
                continue;
            }
            try {
                oStream.write(dataOut);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (isPresetMultiple) {
            int count = kids.length;
            int pointAddress = baseAddress;
            if (this.isDataTypeLong() || this.isDataTypeFloat()) {
                count *= 2;
            }
            int code = 16;
            dataOut = oStream.toByteArray();
            ModbusWriteRequest req = new ModbusWriteRequest(this.getNetwork().getModbusMode(), this.getDevice(), address, code, pointAddress, count, dataOut);
            this.getNetwork().postWrite(new BModbusClientPresetComponent.ModbusClientWriteRequest(this, req, this));
        }
    }

    @Override
    protected Property getBaseAddressProperty() {
        return BModbusClientDevice.holdingRegisterBaseAddress;
    }

    @Override
    protected boolean isValidAddress(BFlexAddress address) {
        if (!address.isModbusFormat()) {
            return address.isValid();
        }
        if (address.isModbusAnalogAddress()) {
            return address.isModbusHoldingAddress();
        }
        return false;
    }

    public void doAddPresetRegisterValue(BModbusClientPresetRegister param) {
        this.add(null, (BValue)param);
        BComponentSpace space = this.getComponentSpace();
        if (space != null) {
            space.update((BComponent)this, 0);
        }
    }

    public void processMessage(Message response) {
        int exceptionCode = 0;
        exceptionCode = response == null ? 9 : ((ModbusResponse)response).exceptionCode;
        this.setStatusFault(exceptionCode != 0 && exceptionCode != -2 && exceptionCode != 5);
        BCommStatus tmp = new BCommStatus(exceptionCode);
        BAbsTime timestamp = Clock.time();
        SlotCursor c = this.getProperties();
        while (c.next(BModbusClientPresetRegister.class)) {
            BModbusClientPresetRegister kid = (BModbusClientPresetRegister)c.get();
            kid.getWriteStatus().setErrorCode(tmp.getErrorCode());
            kid.getWriteStatus().setErrorDescription(tmp.getErrorDescription());
            if (exceptionCode != 0 && exceptionCode != 5) {
                kid.setLastFailedWrite(timestamp);
                continue;
            }
            kid.setLastSuccessfulWrite(timestamp);
        }
        if (exceptionCode == 0 || exceptionCode == 5) {
            this.fireWriteSuccessful(null);
            if (this.getNetwork().getModbusLog().isTraceOn()) {
                this.getNetwork().getModbusLog().trace(this.getName() + " write successful.");
            }
        } else if (this.getNetwork().getModbusLog().isTraceOn()) {
            this.getNetwork().getModbusLog().trace(this.getName() + " write unsuccessful.");
        }
    }

    public void computeStatus(boolean fireSuccessful) {
        SlotCursor c = this.getProperties();
        while (c.next(BModbusClientPresetRegister.class)) {
            BModbusClientPresetRegister kid = (BModbusClientPresetRegister)c.get();
            int errorCode = kid.getWriteStatus().getErrorCode();
            if (errorCode == 0 || errorCode == -2 || errorCode == 5) continue;
            this.setStatusFault(true);
            if (fireSuccessful && this.getNetwork().getModbusLog().isTraceOn()) {
                this.getNetwork().getModbusLog().trace(this.getName() + " write unsuccessful.");
            }
            return;
        }
        this.setStatusFault(false);
        if (fireSuccessful) {
            this.fireWriteSuccessful(null);
            if (this.getNetwork().getModbusLog().isTraceOn()) {
                this.getNetwork().getModbusLog().trace(this.getName() + " write successful.");
            }
        }
    }

    private boolean isDataTypeInteger() {
        return DataTypeUtil.is16BitInteger(this.getDataType());
    }

    private boolean isDataTypeLong() {
        return DataTypeUtil.is32BitLong(this.getDataType());
    }

    private boolean isDataType64BitLong() {
        return DataTypeUtil.is64BitLong(this.getDataType());
    }

    private boolean isDataTypeDouble() {
        return DataTypeUtil.isDouble(this.getDataType());
    }

    private boolean isDataTypeFloat() {
        return DataTypeUtil.isFloat(this.getDataType());
    }

    private boolean isDataTypeSigned() {
        return DataTypeUtil.isSigned(this.getDataType());
    }

    private byte[] setIntegerByteArray(float fValue) {
        return ByteConverterUtil.to2ByteIntArray(fValue, this.isDataTypeSigned());
    }

    private byte[] setLongByteArray(float fValue) {
        BDataByteOrderEnum byteOrder = this.getDevice().getLongDataByteOrder();
        return ByteConverterUtil.to4ByteLongArray(fValue, byteOrder, true);
    }

    private byte[] setFloatByteArray(float fValue) {
        BDataByteOrderEnum byteOrder = this.getDevice().getFloatDataByteOrder();
        return ByteConverterUtil.to4ByteFloatArray(fValue, byteOrder);
    }

    private class ModbusWriteFloatRequest
    implements Runnable,
    ICoalesceable {
        private int hashCode;
        private BModbusClientPresetRegister source;
        private ModbusWriteRequest req;
        private byte[] dataOut;
        private boolean lastChild;

        public ModbusWriteFloatRequest(BModbusClientPresetRegister source, ModbusWriteRequest req, byte[] dataOut, boolean lastChild) {
            this.hashCode = source.hashCode();
            this.source = source;
            this.req = req;
            this.dataOut = dataOut;
            this.lastChild = lastChild;
        }

        @Override
        public void run() {
            this.source.setLastChild(false);
            this.source.processMessage(BModbusClientPresetRegisters.this.getDevice().sendModbusMessage(this.req));
            if (this.source.getWriteStatus().getErrorCode() != 0 && this.source.getWriteStatus().getErrorCode() != 5) {
                return;
            }
            this.dataOut[0] = this.dataOut[2];
            this.dataOut[1] = this.dataOut[3];
            ++this.req.startAddress;
            this.req.data = this.dataOut;
            this.source.setLastChild(this.lastChild);
            this.source.processMessage(BModbusClientPresetRegisters.this.getDevice().sendModbusMessage(this.req));
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (object instanceof ModbusWriteFloatRequest) {
                ModbusWriteFloatRequest o = (ModbusWriteFloatRequest)object;
                return this.source == o.source;
            }
            return false;
        }

        public Object getCoalesceKey() {
            return this;
        }

        public ICoalesceable coalesce(ICoalesceable c) {
            return c;
        }
    }
}

