/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore;

import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.modbusCore.BModbusDevice;
import com.tridium.modbusCore.enums.BDataByteOrder64BitEnum;
import com.tridium.modbusCore.enums.BDataByteOrderEnum;
import com.tridium.modbusCore.enums.BModbusDataModeEnum;
import com.tridium.modbusCore.server.BModbusServerNetwork;
import javax.baja.driver.BDevice;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="floatByteOrder", type="BDataByteOrderEnum", defaultValue="BDataByteOrderEnum.order3210"), @NiagaraProperty(name="longByteOrder", type="BDataByteOrderEnum", defaultValue="BDataByteOrderEnum.order3210"), @NiagaraProperty(name="double64BitByteOrder", type="BDataByteOrder64BitEnum", defaultValue="BDataByteOrder64BitEnum.order76543210"), @NiagaraProperty(name="long64BitByteOrder", type="BDataByteOrder64BitEnum", defaultValue="BDataByteOrder64BitEnum.order76543210")})
public abstract class BModbusNetwork
extends BBasicNetwork {
    @Generated
    public static final Property floatByteOrder = BModbusNetwork.newProperty((int)0, (BValue)BDataByteOrderEnum.order3210, null);
    @Generated
    public static final Property longByteOrder = BModbusNetwork.newProperty((int)0, (BValue)BDataByteOrderEnum.order3210, null);
    @Generated
    public static final Property double64BitByteOrder = BModbusNetwork.newProperty((int)0, (BValue)BDataByteOrder64BitEnum.order76543210, null);
    @Generated
    public static final Property long64BitByteOrder = BModbusNetwork.newProperty((int)0, (BValue)BDataByteOrder64BitEnum.order76543210, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BModbusNetwork.class);
    protected Subscriber subscriber;
    protected Log modbusLog = null;
    private long totalCrcErrors = 0L;
    private long totalLrcErrors = 0L;
    private long totalTransactionIdErrors = 0L;
    private long totalPartialRxMsgs = 0L;

    @Generated
    public BDataByteOrderEnum getFloatByteOrder() {
        return (BDataByteOrderEnum)this.get(floatByteOrder);
    }

    @Generated
    public void setFloatByteOrder(BDataByteOrderEnum v) {
        this.set(floatByteOrder, (BValue)v, null);
    }

    @Generated
    public BDataByteOrderEnum getLongByteOrder() {
        return (BDataByteOrderEnum)this.get(longByteOrder);
    }

    @Generated
    public void setLongByteOrder(BDataByteOrderEnum v) {
        this.set(longByteOrder, (BValue)v, null);
    }

    @Generated
    public BDataByteOrder64BitEnum getDouble64BitByteOrder() {
        return (BDataByteOrder64BitEnum)this.get(double64BitByteOrder);
    }

    @Generated
    public void setDouble64BitByteOrder(BDataByteOrder64BitEnum v) {
        this.set(double64BitByteOrder, (BValue)v, null);
    }

    @Generated
    public BDataByteOrder64BitEnum getLong64BitByteOrder() {
        return (BDataByteOrder64BitEnum)this.get(long64BitByteOrder);
    }

    @Generated
    public void setLong64BitByteOrder(BDataByteOrder64BitEnum v) {
        this.set(long64BitByteOrder, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BModbusNetwork() {
        this.setFlags((Slot)upload, 4);
        this.setFlags((Slot)download, 4);
    }

    public void serviceStarted() throws Exception {
        super.serviceStarted();
        this.subscriber = new NameSubscriber(this);
        this.subscriber.subscribe((BComponent)this.getParent());
    }

    public void serviceStopped() throws Exception {
        this.subscriber.unsubscribeAll();
        this.subscriber = null;
        super.serviceStopped();
    }

    public abstract int getModbusMode();

    public Log getModbusLog() {
        String modbusLogName = this.getName();
        if (!SlotPath.isValidName((String)modbusLogName)) {
            modbusLogName = SlotPath.escape((String)modbusLogName);
        }
        return Log.getLog((String)modbusLogName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateLog() {
        String modbusLogName = this.getName();
        if (!SlotPath.isValidName((String)modbusLogName)) {
            modbusLogName = SlotPath.escape((String)modbusLogName);
        }
        Log newLog = Log.getLog((String)modbusLogName);
        if (this.modbusLog == null) {
            this.modbusLog = this.getModbusLog();
        }
        Log log = this.modbusLog;
        synchronized (log) {
            if (this.modbusLog != null) {
                int severity = this.modbusLog.getSeverity();
                if (!newLog.getLogName().equals(this.modbusLog.getLogName())) {
                    Log.deleteLog((String)this.modbusLog.getLogName());
                }
                newLog.setSeverity(severity);
            }
            this.modbusLog = newLog;
        }
    }

    protected void processNameSubscriberEvent(BComponentEvent event) {
        try {
            if (event.getId() == 3 && event.getSlot().equals((Object)this.getPropertyInParent())) {
                this.updateLog();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Subscriber getNameSubscriber() {
        return this.subscriber;
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"ModbusNetwork", 2);
        out.prop((Object)"Total CRC Errors", (Object)this.totalCrcErrors);
        out.prop((Object)"Total LRC Errors", (Object)this.totalLrcErrors);
        out.prop((Object)"Total Transaction ID Errors", (Object)this.totalTransactionIdErrors);
        out.prop((Object)"Total Partial Rx Msgs", (Object)this.totalPartialRxMsgs);
        out.endProps();
        BDevice[] devices = this.getDevices();
        if (devices != null && devices.length != 0) {
            boolean isServer = this instanceof BModbusServerNetwork;
            out.startTable(true);
            if (isServer) {
                out.trTitle((Object)"Device Info", 4);
                out.w((Object)"<tr>").th((Object)"Device").th((Object)"Address").th((Object)"Mode").th((Object)"Messages").w((Object)"</tr>\n");
            } else {
                out.trTitle((Object)"Device Transaction Info (Retries not counted)", 7);
                out.w((Object)"<tr>").th((Object)"Device").th((Object)"Address").th((Object)"Mode").th((Object)"Request").th((Object)"NoResponse").th((Object)"CRC/LRC").th((Object)"TransactionId").w((Object)"</tr>\n");
            }
            for (int i = 0; i < devices.length; ++i) {
                BModbusDevice device = (BModbusDevice)devices[i];
                int dataMode = device.getModbusMode();
                if (isServer) {
                    out.tr((Object)SlotPath.unescape((String)device.getName()), (Object)("" + device.getDeviceAddress()), (Object)("" + (dataMode == 2 ? "TCP" : BModbusDataModeEnum.make(dataMode))), (Object)("" + device.getTotalMessages()));
                    continue;
                }
                boolean useLRC = dataMode == 0;
                long crcLrcErrors = useLRC ? device.getTotalLrcErrors() : device.getTotalCrcErrors();
                out.tr((Object)SlotPath.unescape((String)device.getName()), (Object)("" + device.getDeviceAddress()), (Object)("" + (dataMode == 2 ? "TCP" : BModbusDataModeEnum.make(dataMode))), (Object)("" + device.getTotalMessages()), (Object)("" + device.getTotalTimeouts()), (Object)("" + crcLrcErrors), (Object)("" + device.getTotalTransactionIdErrors()));
            }
            out.endTable();
        }
    }

    public final void incrementCrcErrors() {
        ++this.totalCrcErrors;
    }

    public final void incrementLrcErrors() {
        ++this.totalLrcErrors;
    }

    public final void incrementTransactionIdErrors() {
        ++this.totalTransactionIdErrors;
    }

    public final void incrementPartialRxMsgs() {
        ++this.totalPartialRxMsgs;
    }

    public final long getPartialRxMsgs() {
        return this.totalPartialRxMsgs;
    }

    public final long getTotalCrcErrors() {
        return this.totalCrcErrors;
    }

    public final long geTotalLrcErrors() {
        return this.totalLrcErrors;
    }

    public final long geTotalTransactionIdErrors() {
        return this.totalTransactionIdErrors;
    }

    private class NameSubscriber
    extends Subscriber {
        private BModbusNetwork net;

        public NameSubscriber(BModbusNetwork net) {
            this.net = net;
        }

        public void event(BComponentEvent event) {
            this.net.processNameSubscriberEvent(event);
        }
    }
}

