/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.backup.hx;

import com.tridium.backup.BBackupRecord;
import com.tridium.sys.station.BStationSaveJob;
import com.tridium.sys.station.Station;
import com.tridium.util.TimeFormat;
import javax.baja.backup.BBackupService;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.ViewQuery;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.session.CsrfException;
import javax.baja.session.INiagaraSuperSession;
import javax.baja.session.SessionUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconModule;

@NiagaraType(agent={@AgentOn(types={"backup:BackupManager"}, requiredPermissions="W")})
@NiagaraSingleton
public class BHxBackupManager
extends BHxView {
    @Generated
    public static final BHxBackupManager INSTANCE = new BHxBackupManager();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxBackupManager.class);
    public static final LexiconModule lexicon = LexiconModule.make(BHxBackupManager.class);
    static final BImage icon = BImage.make((String)"module://icons/x16/backup.png");
    public static final String CSRF_TOKEN_NAME = "csrfToken";

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxBackupManager() {
    }

    public void write(HxOp op) throws Exception {
        ViewQuery vq = op.getViewQuery();
        if (vq == null || vq.getParameter("startBackup", null) == null) {
            this.doWrite(new BackupOperation(), op);
        } else {
            this.doBackup(new BackupOperation(), op);
        }
    }

    private void doWrite(IBackupOperation backupOp, HxOp hxOp) throws Exception {
        String csrfToken = backupOp.getCsrfToken();
        HtmlWriter out = hxOp.getHtmlWriter();
        hxOp.setDynamic();
        out.w((Object)"<div ").attr("id", hxOp.scope("content")).println(">");
        backupOp.writeBackupTable(hxOp);
        BOrd downloadOrd = hxOp.getOrdWithoutViewQuery();
        out.w((Object)"<div class='hx-AbstractManager-toolbar' style='margin-top: 10px;'>");
        out.println("<input class='ux-btn' type=button name='" + hxOp.scope("backup") + "' value='" + HxUtil.safe((String)lexicon.getText("backup.label", (Context)hxOp)) + "' onclick='hx.hyperlink(\"" + hxOp.toUri(downloadOrd) + "%7Cview:backup:BackupManager?startBackup=true;fullScreen=true;csrfToken=" + csrfToken + "\");' />");
        out.w((Object)"</div>");
        out.println("</div>");
    }

    private void doBackup(IBackupOperation backupOp, HxOp hxOp) throws Exception {
        backupOp.checkCsrfToken(hxOp.getViewQuery().getParameter(CSRF_TOKEN_NAME, null));
        BBackupService service = (BBackupService)Sys.getService((Type)BBackupService.TYPE);
        String stationName = Sys.getStation().getStationName();
        String timestamp = TimeFormat.format((BAbsTime)Clock.time(), (String)"YYMMDD_HHmm");
        String name = "backup_" + stationName + '_' + timestamp + ".dist";
        BStationSaveJob job = new BStationSaveJob();
        Station.saveSync((BJob)job);
        hxOp.setRaw();
        hxOp.setContentType("application/x-zip-compressed");
        hxOp.getResponse().setHeader("Content-Disposition", "attachment;filename=" + name);
        service.zip(null, hxOp.getOutputStream(), true, (Context)hxOp);
        BBackupRecord rec = new BBackupRecord();
        rec.setTimestamp(BAbsTime.make());
        rec.setHost(hxOp.getRequest().getRemoteHost());
        rec.setPath("hx:" + name);
        rec.setUser(hxOp.getUser().toString());
        rec.append(service);
    }

    public static final class BackupOperation
    implements IBackupOperation {
        @Override
        public String getCsrfToken() {
            INiagaraSuperSession session = SessionUtil.getCurrentNiagaraSuperSession();
            return session.getCsrfToken();
        }

        @Override
        public void checkCsrfToken(String token) throws CsrfException {
            INiagaraSuperSession session = SessionUtil.getCurrentNiagaraSuperSession();
            if (session == null) {
                throw new SecurityException("invalid session");
            }
            session.verifyCsrfToken(token);
        }

        @Override
        public void writeBackupTable(HxOp hxOp) throws Exception {
            BBackupService service = (BBackupService)Sys.getService((Type)BBackupService.TYPE);
            BBackupRecord[] recs = BBackupRecord.list((BBackupService)service);
            HtmlWriter out = hxOp.getHtmlWriter();
            out.w((Object)"<div class='controlShadow-bg tableViewHeader'>");
            out.w((Object)"<span style='float:right'>").safe((Object)(recs.length + " " + lexicon.getText("backups", (Context)hxOp))).w((Object)"</span>");
            out.safe((Object)lexicon.getText("backups", (Context)hxOp));
            out.w((Object)"</div>");
            out.w((Object)"<table class='ux-table' style='width: 100%'>");
            out.w((Object)"<thead class='ux-table-head'>");
            out.w((Object)"<tr>");
            out.w((Object)"<th>").safe((Object)BBackupRecord.timestamp.getDefaultDisplayName((Context)hxOp)).w((Object)"</th>");
            out.w((Object)"<th>").safe((Object)BBackupRecord.host.getDefaultDisplayName((Context)hxOp)).w((Object)"</th>");
            out.w((Object)"<th>").safe((Object)BBackupRecord.path.getDefaultDisplayName((Context)hxOp)).w((Object)"</th>");
            out.w((Object)"<th>").safe((Object)BBackupRecord.user.getDefaultDisplayName((Context)hxOp)).w((Object)"</th>");
            out.w((Object)"</tr>");
            out.w((Object)"</thead>");
            out.w((Object)"<tbody>");
            for (BBackupRecord rec : recs) {
                out.w((Object)"<tr class='ux-table-row'>");
                out.w((Object)"<td>");
                HxUtil.makeImageJS((BImage)icon, (HxOp)hxOp);
                out.safe((Object)String.valueOf(rec.getTimestamp().toString((Context)hxOp)));
                out.w((Object)"</td>");
                out.w((Object)"<td>").safe((Object)rec.getHost()).w((Object)"</td>");
                out.w((Object)"<td>").safe((Object)rec.getPath()).w((Object)"</td>");
                out.w((Object)"<td>").safe((Object)rec.getUser()).w((Object)"</td>");
                out.w((Object)"</tr>");
            }
            out.w((Object)"</tbody>");
            out.w((Object)"</table>");
        }
    }

    public static interface IBackupOperation {
        public String getCsrfToken();

        public void checkCsrfToken(String var1);

        public void writeBackupTable(HxOp var1) throws Exception;
    }
}

