/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.converters;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import javax.baja.converters.BEnumToSimpleMap;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BDouble;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeNotFoundException;

@NiagaraType
public final class BNumericToSimpleMap
extends BSimple {
    public static final BNumericToSimpleMap NULL;
    public static final BNumericToSimpleMap DEFAULT;
    public static final Type TYPE;
    private Item[] items;
    BSimple def;
    private String string;

    public static BNumericToSimpleMap make(BSimple def) {
        return BNumericToSimpleMap.make(new double[0], new double[0], new BSimple[0], def);
    }

    public static BNumericToSimpleMap make(double[] mins, double[] maxs, BSimple[] values, BSimple def) {
        if (mins.length != maxs.length || maxs.length != values.length) {
            throw new IllegalArgumentException();
        }
        if (mins.length == 0 && def == null) {
            return NULL;
        }
        Item[] items = new Item[mins.length];
        for (int i = 0; i < items.length; ++i) {
            items[i] = new Item(mins[i], maxs[i], values[i]);
        }
        return new BNumericToSimpleMap(items, def);
    }

    public static BNumericToSimpleMap make(String s) {
        if (s.equals("null")) {
            return NULL;
        }
        try {
            int space = s.indexOf(32);
            Type type = Sys.getType((String)s.substring(0, space));
            BSimple proto = (BSimple)type.getInstance();
            BSimple def = null;
            String[] tokens = BEnumToSimpleMap.tokenizeItems(s.substring(space + 1));
            Array items = new Array(Item.class);
            for (String tok : tokens) {
                int eq = tok.indexOf(61);
                String key = tok.substring(0, eq);
                String valueStr = tok.substring(eq + 1);
                BSimple value = (BSimple)proto.decodeFromString(valueStr);
                if (key.equals("default")) {
                    def = value;
                    continue;
                }
                int colon = key.indexOf(58);
                double min = BDouble.decode((String)key.substring(0, colon));
                double max = BDouble.decode((String)key.substring(colon + 1));
                items.add((Object)new Item(min, max, value));
            }
            return new BNumericToSimpleMap((Item[])items.trim(), def);
        }
        catch (TypeNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(s);
        }
    }

    private BNumericToSimpleMap(Item[] items, BSimple def) {
        this.items = items;
        this.def = def;
    }

    public BSimple get(double num) {
        for (Item item : this.items) {
            if (!(item.min <= num) || !(num <= item.max)) continue;
            return item.value;
        }
        return this.def;
    }

    public Type getValueType() {
        if (this.def != null) {
            return this.def.getType();
        }
        return this.items[0].value.getType();
    }

    public BSimple getDefault() {
        return this.def;
    }

    public double[] getMinimums() {
        double[] arr = new double[this.items.length];
        for (int i = 0; i < this.items.length; ++i) {
            arr[i] = this.items[i].min;
        }
        return arr;
    }

    public double[] getMaximums() {
        double[] arr = new double[this.items.length];
        for (int i = 0; i < this.items.length; ++i) {
            arr[i] = this.items[i].max;
        }
        return arr;
    }

    public BSimple[] getValues() {
        BSimple[] arr = new BSimple[this.items.length];
        for (int i = 0; i < this.items.length; ++i) {
            arr[i] = this.items[i].value;
        }
        return arr;
    }

    public boolean isNull() {
        return this.items.length == 0;
    }

    public int hashCode() {
        int hash = this.def != null ? this.def.hashCode() : 0;
        for (Item item : this.items) {
            hash = 31 * hash + item.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BNumericToSimpleMap) {
            BNumericToSimpleMap x = (BNumericToSimpleMap)((Object)obj);
            if (this.items.length != x.items.length) {
                return false;
            }
            for (int i = 0; i < this.items.length; ++i) {
                if (this.items[i].equals(x.items[i])) continue;
                return false;
            }
            if (this.def == null) {
                return x.def == null;
            }
            if (x.def == null) {
                return false;
            }
            return this.def.equals((Object)x.def);
        }
        return false;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput in) throws IOException {
        return BNumericToSimpleMap.make(in.readUTF());
    }

    public String encodeToString() throws IOException {
        if (this.string == null) {
            if (this.items.length == 0 && this.def == null) {
                this.string = "null";
                return "null";
            }
            StringBuilder s = new StringBuilder();
            s.append(this.getValueType()).append(' ');
            for (Item item : this.items) {
                s.append(BDouble.encode((double)item.min));
                s.append(':');
                s.append(BDouble.encode((double)item.max));
                s.append('=');
                String value = item.value.encodeToString();
                value = TextUtil.replace((String)value, (String)";", (String)";;");
                s.append(value).append(';');
            }
            if (this.def != null) {
                String defstr = this.def.encodeToString();
                defstr = TextUtil.replace((String)defstr, (String)";", (String)";;");
                s.append("default=").append(defstr).append(';');
            }
            this.string = s.toString();
        }
        return this.string;
    }

    public BObject decodeFromString(String s) throws IOException {
        return BNumericToSimpleMap.make(s);
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 205: {
                this.setBaseOrd(a);
                return null;
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private void setBaseOrd(Object baseOrd) {
        if (this.def != null) {
            this.def.fw(205, baseOrd, null, null, null);
        }
        for (Item item : this.items) {
            item.value.fw(205, baseOrd, null, null, null);
        }
    }

    public Type getType() {
        return TYPE;
    }

    static {
        DEFAULT = NULL = new BNumericToSimpleMap(new Item[0], null);
        TYPE = Sys.loadType(BNumericToSimpleMap.class);
    }

    static class Item {
        double min;
        double max;
        BSimple value;

        Item(double min, double max, BSimple value) {
            this.min = min;
            this.max = max;
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Item)) {
                return false;
            }
            Item x = (Item)obj;
            return BDouble.equals((double)this.min, (double)x.min) && BDouble.equals((double)this.max, (double)x.max) && this.value.equals((Object)x.value);
        }

        public int hashCode() {
            return Objects.hash(this.min, this.max, this.value);
        }
    }
}

