/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program.module;

import com.tridium.program.BProgram;
import java.util.Collections;
import java.util.HashSet;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.ModuleInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;
import javax.baja.util.BNameMap;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="moduleName", type="String", defaultValue="", flags=8, facets={@Facet(value="BFacets.make(\"mustBeSlotName\", true)")}), @NiagaraProperty(name="description", type="String", defaultValue="", facets={@Facet(name="BFacets.MAX", value="100")}), @NiagaraProperty(name="vendor", type="String", defaultValue=""), @NiagaraProperty(name="vendorVersion", type="String", defaultValue="BProgramModule.DEFAULT_VENDOR_VERSION", facets={@Facet(name="BIValidator.VALIDATOR_FACET", value="\"baja:VersionValidator\"")}), @NiagaraProperty(name="dependencies", type="BNameMap", defaultValue="BNameMap.DEFAULT", flags=4), @NiagaraProperty(name="programs", type="BFolder", defaultValue="new BFolder()", flags=4), @NiagaraProperty(name="permissions", type="BFolder", defaultValue="new BFolder()", flags=4)})
public final class BProgramModule
extends BComponent {
    @Generated
    public static final Property moduleName = BProgramModule.newProperty((int)8, (String)"", (BFacets)BFacets.make((String)"mustBeSlotName", (boolean)true));
    @Generated
    public static final Property description = BProgramModule.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"max", (int)100));
    @Generated
    public static final Property vendor = BProgramModule.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property vendorVersion = BProgramModule.newProperty((int)0, (String)"0", (BFacets)BFacets.make((String)"validator", (String)"baja:VersionValidator"));
    @Generated
    public static final Property dependencies = BProgramModule.newProperty((int)4, (BValue)BNameMap.DEFAULT, null);
    @Generated
    public static final Property programs = BProgramModule.newProperty((int)4, (BValue)new BFolder(), null);
    @Generated
    public static final Property permissions = BProgramModule.newProperty((int)4, (BValue)new BFolder(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BProgramModule.class);
    private static final String DEFAULT_VENDOR_VERSION = "0";
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"module.png"), (BIcon)BIcon.std((String)"badges/script.png"));

    @Generated
    public String getModuleName() {
        return this.getString(moduleName);
    }

    @Generated
    public void setModuleName(String v) {
        this.setString(moduleName, v, null);
    }

    @Generated
    public String getDescription() {
        return this.getString(description);
    }

    @Generated
    public void setDescription(String v) {
        this.setString(description, v, null);
    }

    @Generated
    public String getVendor() {
        return this.getString(vendor);
    }

    @Generated
    public void setVendor(String v) {
        this.setString(vendor, v, null);
    }

    @Generated
    public String getVendorVersion() {
        return this.getString(vendorVersion);
    }

    @Generated
    public void setVendorVersion(String v) {
        this.setString(vendorVersion, v, null);
    }

    @Generated
    public BNameMap getDependencies() {
        return (BNameMap)this.get(dependencies);
    }

    @Generated
    public void setDependencies(BNameMap v) {
        this.set(dependencies, (BValue)v, null);
    }

    @Generated
    public BFolder getPrograms() {
        return (BFolder)this.get(programs);
    }

    @Generated
    public void setPrograms(BFolder v) {
        this.set(programs, (BValue)v, null);
    }

    @Generated
    public BFolder getPermissions() {
        return (BFolder)this.get(permissions);
    }

    @Generated
    public void setPermissions(BFolder v) {
        this.set(permissions, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BNameMap rationalizeDependencies(BProgramModule module) {
        String[] gone;
        BProgram[] programs;
        HashSet set = new HashSet();
        BNameMap depends = module.getDependencies();
        String[] currentNames = depends.list();
        Collections.addAll(set, currentNames);
        for (BProgram program : programs = module.listPrograms()) {
            String[] progDepends;
            for (String moduleName : progDepends = TextUtil.split((String)program.getCode().getDependencies(), (char)';')) {
                if (depends.get(moduleName) == null) {
                    if (!BProgram.isSpecialModule(moduleName)) {
                        try {
                            ModuleInfo mInfo = Sys.getRegistry().moduleForDependency(moduleName);
                            depends = BNameMap.make((BNameMap)depends, (String)moduleName, (String)mInfo.getVendorVersion().toString(2));
                        }
                        catch (ModuleNotFoundException moduleNotFoundException) {}
                    } else {
                        depends = BNameMap.make((BNameMap)depends, (String)moduleName, (String)Sys.getRegistry().getModule("baja", RuntimeProfile.rt).getVendorVersion().toString(2));
                    }
                }
                set.remove(moduleName);
            }
        }
        for (String aGone : gone = set.toArray(new String[0])) {
            depends = BNameMap.remove((BNameMap)depends, (String)aGone);
        }
        return depends;
    }

    public RuntimeProfile getRuntimeProfile() {
        BNameMap depends = this.getDependencies();
        RuntimeProfile moduleProfile = RuntimeProfile.rt;
        for (String name : depends.list()) {
            try {
                ModuleInfo mInfo = Sys.getRegistry().moduleForDependency(name);
                RuntimeProfile runtime = mInfo.getRuntimeProfile();
                if (runtime.compareTo((Enum)moduleProfile) <= 0) continue;
                moduleProfile = runtime;
            }
            catch (ModuleNotFoundException moduleNotFoundException) {
                // empty catch block
            }
        }
        return moduleProfile;
    }

    public BProgram[] listPrograms() {
        return (BProgram[])this.getPrograms().getChildren(BProgram.class);
    }

    public String getPreferredSymbol() {
        return this.getModuleName();
    }

    public BIcon getIcon() {
        return icon;
    }
}

