/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program.batch;

import com.tridium.program.batch.BBatchRoutine;
import java.io.PrintWriter;
import java.util.Optional;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelation;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tag.TagGroupInfo;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperty(name="newTags", type="BComponent", defaultValue="new BComponent()")
public class BAddTagBatchRoutine
extends BBatchRoutine {
    @Generated
    public static final Property newTags = BAddTagBatchRoutine.newProperty((int)0, (BValue)new BComponent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAddTagBatchRoutine.class);
    private static final Id TAG_GROUP_RELATION = Id.newId((String)"n:tagGroup");

    @Generated
    public BComponent getNewTags() {
        return (BComponent)this.get(newTags);
    }

    @Generated
    public void setNewTags(BComponent v) {
        this.set(newTags, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BAddTagBatchRoutine make(BComponent tags) {
        BAddTagBatchRoutine routine = new BAddTagBatchRoutine();
        routine.setNewTags(tags);
        return routine;
    }

    @Override
    public void run(BComponent component, PrintWriter log, Lexicon lex, Context cx) {
        BComponent tags = this.getNewTags();
        for (Property property : tags.getProperties()) {
            String name = property.getName();
            BValue value = tags.get(property).newCopy();
            int flags = tags.getFlags((Slot)property);
            if (value instanceof BRelation && ((BRelation)value).getId().equals((Object)TAG_GROUP_RELATION)) {
                BRelation relation = (BRelation)value;
                BObject endpoint = relation.getEndpointOrd().get((BObject)component);
                if (endpoint instanceof Entity && endpoint instanceof TagGroupInfo) {
                    Optional existing = component.relations().get(TAG_GROUP_RELATION, (Entity)endpoint);
                    if (!existing.isPresent()) {
                        component.relations().add((Relation)relation);
                        log.println(lex.getText("batchEditor.log.addTagGroup") + ' ' + component.getSlotPathOrd() + '.' + SlotPath.unescape((String)name));
                        continue;
                    }
                    log.println(lex.getText("batchEditor.log.addTagGroup") + ' ' + lex.getText("batchEditor.log.skippingAlreadyPresent") + ' ' + component.getSlotPathOrd() + '.' + SlotPath.unescape((String)name));
                    continue;
                }
                log.println(lex.getText("batchEditor.log.addTagGroup") + ' ' + lex.getText("batchEditor.log.skippingInvalid") + ' ' + component.getSlotPathOrd() + '.' + SlotPath.unescape((String)name));
                continue;
            }
            if (component.getProperty(name) != null) {
                if (Flags.isReadonly((BComplex)component, (Slot)component.getProperty(name))) {
                    log.println(lex.getText("batchEditor.log.setTag") + ' ' + lex.getText("batchEditor.log.skippingReadonly") + ' ' + component.getSlotPathOrd() + '.' + SlotPath.unescape((String)name));
                    return;
                }
                if (component.get(name).getType() != value.getType()) {
                    return;
                }
                component.set(name, value);
                log.println(lex.getText("batchEditor.log.setTag") + ' ' + component.getSlotPathOrd() + '.' + SlotPath.unescape((String)name) + " -> " + value);
                continue;
            }
            component.add(name, value, flags, cx);
            log.println(lex.getText("batchEditor.log.addTag") + ' ' + component.getSlotPathOrd() + '.' + SlotPath.unescape((String)name) + " -> " + value);
        }
    }
}

