/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program;

import com.tridium.nre.util.NreRuntime;
import com.tridium.program.ProgramBase;
import com.tridium.program.Robot;
import com.tridium.sys.Nre;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.StringTokenizer;
import javax.baja.naming.BOrd;
import javax.baja.security.AuditEvent;
import javax.baja.security.Auditor;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;

public final class ProgramRuntime
extends NreRuntime {
    private static ProgramRuntime PROGRAM_RUNTIME = new ProgramRuntime(Runtime.getRuntime());

    private ProgramRuntime(Runtime runtime) {
        this.setRuntime(runtime);
    }

    public static ProgramRuntime getRuntime() {
        return PROGRAM_RUNTIME;
    }

    public Process exec(Object caller, String cmd) throws IOException {
        return this.exec(caller, cmd, null, null);
    }

    public Process exec(Object caller, String cmd, String[] envp) throws IOException {
        return this.exec(caller, cmd, envp, null);
    }

    public Process exec(Object caller, String cmd, String[] envp, File dir) throws IOException {
        StringTokenizer tok = new StringTokenizer(cmd);
        String[] cmdParts = new String[tok.countTokens()];
        int idx = 0;
        while (tok.hasMoreTokens()) {
            cmdParts[idx] = tok.nextToken();
            ++idx;
        }
        return this.exec(caller, cmdParts, envp, dir);
    }

    public Process exec(Object caller, String[] cmdArray) throws IOException {
        return this.exec(caller, cmdArray, null, null);
    }

    public Process exec(Object caller, String[] cmdArray, String[] envp) throws IOException {
        return this.exec(caller, cmdArray, envp, null);
    }

    public Process exec(Object caller, String[] cmdArray, String[] envp, File dir) throws IOException {
        Auditor auditor;
        Process p;
        if (!this.allowBajaRuntimeExec()) {
            throw new RuntimeException("ProgramRuntime.exec() not allowed");
        }
        if (caller == null) {
            throw new RuntimeException("ProgramBase/Robot reqired for ProgramRuntime.exec()");
        }
        String target = "ProgramBase {not mounted}";
        if (caller instanceof ProgramBase) {
            BComponent program = ((ProgramBase)caller).getComponent();
            if (program != null && program.getSlotPath() != null) {
                target = program.getSlotPath().getBody();
            }
        } else if (caller instanceof Robot) {
            target = "Robot";
        } else {
            throw new RuntimeException("ProgramRuntime.exec() caller must be ProgramObject or Robot");
        }
        try {
            p = AccessController.doPrivileged(() -> this.exec(cmdArray, envp, dir));
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e);
        }
        if (p != null && (auditor = Nre.auditor) != null) {
            StringBuilder buf = new StringBuilder("ProgramRuntime.exec():");
            for (String aCmdArray : cmdArray) {
                buf.append(" ").append(aCmdArray);
            }
            if (envp != null) {
                buf.append(" with");
                for (String anEnvp : envp) {
                    buf.append(anEnvp).append(", ");
                }
            }
            if (dir != null) {
                buf.append(" from ").append(dir);
            }
            auditor.audit(new AuditEvent("Invoked", target, buf.toString(), "", "", ""));
        }
        return p;
    }

    private boolean allowBajaRuntimeExec() {
        try {
            BComponent progSvc = BOrd.make((String)"service:program:ProgramService").get().asComponent();
            return ((BBoolean)progSvc.get("allowProgramRuntimeExec")).getBoolean();
        }
        catch (Exception e) {
            return false;
        }
    }
}

