/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program;

import com.tridium.crypto.core.cert.CertificateNotTrustedException;
import com.tridium.program.BRobotCode;
import com.tridium.program.BRobotResult;
import com.tridium.program.Robot;
import com.tridium.program.batch.BBatchRoutine;
import com.tridium.program.batch.BRenameBatchRoutine;
import com.tridium.util.ThrowableUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.cert.Certificate;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.PermissionException;
import javax.baja.sys.Action;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="compactProfile", type="String", defaultValue="compact3"), @NiagaraProperty(name="allowProgramRuntimeExec", type="boolean", defaultValue="false", flags=4)})
@NiagaraActions(value={@NiagaraAction(name="runRobot", parameterType="BRobotCode", defaultValue="new BRobotCode()", returnType="BRobotResult"), @NiagaraAction(name="runBatchRoutine", parameterType="BBatchRoutine", defaultValue="new BRenameBatchRoutine()", returnType="BString", flags=4)})
public class BProgramService
extends BComponent
implements BIService,
BIRestrictedComponent {
    @Generated
    public static final Property compactProfile = BProgramService.newProperty((int)0, (String)"compact3", null);
    @Generated
    public static final Property allowProgramRuntimeExec = BProgramService.newProperty((int)4, (boolean)false, null);
    @Generated
    public static final Action runRobot = BProgramService.newAction((int)0, (BValue)new BRobotCode(), null);
    @Generated
    public static final Action runBatchRoutine = BProgramService.newAction((int)4, (BValue)new BRenameBatchRoutine(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BProgramService.class);
    private static final BIcon icon = BIcon.std((String)"navOnly/programService.png");

    @Generated
    public String getCompactProfile() {
        return this.getString(compactProfile);
    }

    @Generated
    public void setCompactProfile(String v) {
        this.setString(compactProfile, v, null);
    }

    @Generated
    public boolean getAllowProgramRuntimeExec() {
        return this.getBoolean(allowProgramRuntimeExec);
    }

    @Generated
    public void setAllowProgramRuntimeExec(boolean v) {
        this.setBoolean(allowProgramRuntimeExec, v, null);
    }

    @Generated
    public BRobotResult runRobot(BRobotCode parameter) {
        return (BRobotResult)this.invoke(runRobot, (BValue)parameter, null);
    }

    @Generated
    public BString runBatchRoutine(BBatchRoutine parameter) {
        return (BString)this.invoke(runBatchRoutine, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public void serviceStarted() {
    }

    public void serviceStopped() {
    }

    public final void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkParentForRestrictedComponent((BComponent)parent, (BIRestrictedComponent)this);
    }

    public BRobotResult doRunRobot(BRobotCode code, Context cx) throws Exception {
        try {
            if (cx != null && cx.getUser() != null && !cx.getUser().getPermissions().isSuperUser()) {
                throw new PermissionException("Run Robot not allowed by this user.");
            }
            Robot robot = (Robot)code.newInstance();
            try {
                robot.context = cx;
                robot.run();
            }
            catch (Exception e) {
                e.printStackTrace(robot.log);
            }
            return robot.toResult();
        }
        catch (Throwable e) {
            String s = "Failed: runRobot\n" + ThrowableUtil.dumpToString((Throwable)e);
            BRobotResult result = new BRobotResult(s, false);
            if (e instanceof LocalizableException) {
                result.setFailCause(((LocalizableException)e).getLexiconKey());
            } else {
                result.setFailCause(e.getMessage());
            }
            if (e.getCause() instanceof CertificateNotTrustedException) {
                CertificateNotTrustedException cnte = (CertificateNotTrustedException)e.getCause();
                Certificate cert = cnte.getCertificate();
                byte[] certBytes = cert.getEncoded();
                result.setUntrustedCertificate(BBlob.make((byte[])certBytes));
            }
            return result;
        }
    }

    public BString doRunBatchRoutine(BBatchRoutine routine, Context cx) {
        StringWriter writer = new StringWriter();
        PrintWriter log = new PrintWriter(writer);
        try {
            routine.runAll((BObject)this, log, cx);
        }
        catch (Exception e) {
            e.printStackTrace(log);
        }
        log.flush();
        return BString.make((String)writer.toString());
    }

    public BIcon getIcon() {
        return icon;
    }
}

