/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.clientCertAuth;

import com.tridium.security.ClientCertAuthPermission;
import java.security.AccessControlException;
import java.security.Permission;
import java.security.cert.X509Certificate;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;

public final class ClientCertAuthenticationInfo
implements HttpSessionBindingListener {
    private final String username;
    private final X509Certificate clientCertificate;

    private ClientCertAuthenticationInfo(String username, X509Certificate clientCertificate) {
        this.username = username;
        this.clientCertificate = clientCertificate;
    }

    public static ClientCertAuthenticationInfo make(String username, X509Certificate clientCertificate) {
        ClientCertAuthPermission clientCertAuthPermission = new ClientCertAuthPermission("addAuthnInfo");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)clientCertAuthPermission);
        }
        return new ClientCertAuthenticationInfo(username, clientCertificate);
    }

    public String getUsername() {
        return this.username;
    }

    public X509Certificate getClientCertificate() {
        return this.clientCertificate;
    }

    public void valueBound(HttpSessionBindingEvent event) {
        try {
            ClientCertAuthPermission clientCertAuthPermission = new ClientCertAuthPermission("addAuthnInfo");
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission((Permission)clientCertAuthPermission);
            }
        }
        catch (AccessControlException e) {
            event.getSession().removeAttribute(event.getName());
            throw e;
        }
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
    }
}

