/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.clientCertAuth;

import com.tridium.clientCertAuth.ClientCertAuthUtils;
import com.tridium.clientCertAuth.ClientCertAuthenticationInfo;
import com.tridium.clientCertAuth.ClientCertCallback;
import com.tridium.fox.message.FoxMessage;
import java.io.IOException;
import java.net.Socket;
import java.security.AccessController;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.logging.Level;
import javax.baja.fox.authn.BFoxCallbackHandler;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;

@NiagaraType(agent={@AgentOn(types={"clientCertAuth:ClientCertAuthScheme"})})
public class BFoxClientCertCallbackHandler
extends BFoxCallbackHandler {
    @Generated
    public static final Type TYPE = Sys.loadType(BFoxClientCertCallbackHandler.class);
    private String username = null;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public String getUsername() {
        return this.username;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks == null || callbacks.length == 0) {
            throw new IOException("invalid callback array provided");
        }
        for (Callback callback : callbacks) {
            if (callback instanceof ClientCertCallback) {
                Socket socket = this.session.getSocket();
                if (!(socket instanceof SSLSocket)) continue;
                SSLSocket sslSocket = (SSLSocket)socket;
                SSLSession sslSession = sslSocket.getSession();
                Certificate[] certs = sslSession.getPeerCertificates();
                try {
                    this.session.setState("FoxClientCertCallbackHandler receive login");
                    FoxMessage login = this.session.receiveTuning("login");
                    this.username = login.getString("username", null);
                }
                catch (Exception e) {
                    ClientCertAuthUtils.log(Level.WARNING, "Could not acquire username from client", (Throwable)e);
                    throw new IOException("Could not acquire username.");
                }
                X509Certificate[] xcerts = (X509Certificate[])Arrays.copyOf(certs, certs.length, X509Certificate[].class);
                ClientCertAuthenticationInfo authenticationInfo = AccessController.doPrivileged(() -> ClientCertAuthenticationInfo.make(this.username, xcerts[0]));
                ((ClientCertCallback)callback).setAuthenticationInfo(authenticationInfo);
                continue;
            }
            throw new UnsupportedCallbackException(callback, "unrecognized callback");
        }
    }
}

