/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.webeditors.ux.servlets;

import com.tridium.box.json.BsonDecoderPlugin;
import java.util.ArrayList;
import java.util.List;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.PermissionException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconModule;

@NiagaraType
public class BResolveServerSideRpc
extends BObject {
    @Generated
    public static final Type TYPE = Sys.loadType(BResolveServerSideRpc.class);
    private static final LexiconModule LEX = LexiconModule.make((String)"webEditors");

    @Generated
    public Type getType() {
        return TYPE;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static List<String> resolveServerSideToString(List<String> bsonComplexes, String clientFacetsBson, Context cx) throws Exception {
        Context mergedContext;
        ArrayList<String> results = new ArrayList<String>();
        if (clientFacetsBson != null) {
            BFacets clientFacets = (BFacets)BsonDecoderPlugin.unmarshal((String)clientFacetsBson, (Context)cx);
            mergedContext = new BasicContext(cx, clientFacets);
        } else {
            mergedContext = cx;
        }
        for (String bsonComplex : bsonComplexes) {
            BValue value = BsonDecoderPlugin.unmarshal((String)bsonComplex, (Context)cx);
            results.add(value.toString(mergedContext));
        }
        return results;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static boolean isParentLegal(String parentBson, String bsonValue, String parentOrd, Context cx) throws Exception {
        BComponent parent;
        if (parentOrd != null && !parentOrd.isEmpty()) {
            OrdTarget target = BOrd.make((String)parentOrd).resolve(null, cx);
            if (!target.canRead()) {
                throw new PermissionException(LEX.getText("resolveServerSideRpc.error.noOperatorRead", cx, new Object[]{parentOrd}));
            }
            parent = target.get().asComponent();
        } else {
            parent = BsonDecoderPlugin.unmarshal((String)parentBson, (Context)cx).asComponent();
        }
        BValue value = BsonDecoderPlugin.unmarshal((String)bsonValue, (Context)cx);
        return !value.isComponent() || value.asComponent().isParentLegal(parent);
    }
}

