/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.control.trigger;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.control.trigger.TriggerScheduler;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;

@NiagaraType
public final class BManualTriggerMode
extends BTriggerMode {
    public static final BManualTriggerMode DEFAULT = new BManualTriggerMode();
    public static final Type TYPE = Sys.loadType(BManualTriggerMode.class);
    private static LexiconText dispName = LexiconText.make((String)"control", (String)"trigger.manual");

    private BManualTriggerMode() {
    }

    public static BManualTriggerMode make() {
        return DEFAULT;
    }

    @Override
    public String getDisplayName(Context cx) {
        return dispName.getText(cx);
    }

    @Override
    public TriggerScheduler makeScheduler(BTimeTrigger trigger) {
        return new ManualTriggerScheduler(trigger);
    }

    public int hashCode() {
        return System.identityHashCode((Object)this);
    }

    public boolean equals(Object o) {
        return o instanceof BManualTriggerMode;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeBoolean(true);
    }

    public BObject decode(DataInput in) throws IOException {
        in.readBoolean();
        return DEFAULT;
    }

    public String encodeToString() {
        return "manual";
    }

    public BObject decodeFromString(String s) throws IOException {
        return DEFAULT;
    }

    public String toString(Context cx) {
        return this.getDisplayName(cx);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    private class ManualTriggerScheduler
    extends TriggerScheduler {
        public ManualTriggerScheduler(BTimeTrigger trigger) {
            super(trigger);
        }

        @Override
        public void start() {
        }

        @Override
        public void stop() {
        }

        @Override
        public boolean isTriggerTime(BAbsTime time) {
            return false;
        }

        @Override
        public BAbsTime getNextTriggerTime(BAbsTime after, BAbsTime previous) {
            return BAbsTime.END_OF_TIME;
        }

        @Override
        BAbsTime getScheduledTriggerTime() {
            return BAbsTime.END_OF_TIME;
        }
    }
}

