/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.control.ext;

import javax.baja.control.BNumericPoint;
import javax.baja.control.BPointExtension;
import javax.baja.control.enums.BTotalizationInterval;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="totalFacets", type="BFacets", defaultValue="BFacets.makeNumeric()"), @NiagaraProperty(name="propagateFlags", type="BStatus", defaultValue="BStatus.make(BStatus.FAULT | BStatus.DOWN | BStatus.DISABLED | BStatus.STALE)"), @NiagaraProperty(name="invalidValueFlags", type="BStatus", defaultValue="BStatus.make(BStatus.FAULT | BStatus.DOWN | BStatus.DISABLED)"), @NiagaraProperty(name="total", type="BStatusNumeric", defaultValue="new BStatusNumeric(0)", flags=1), @NiagaraProperty(name="timeOfTotalReset", type="BAbsTime", defaultValue="BAbsTime.make()", flags=1), @NiagaraProperty(name="totalizationInterval", type="BTotalizationInterval", defaultValue="BTotalizationInterval.minutely")})
@NiagaraActions(value={@NiagaraAction(name="timerExpired"), @NiagaraAction(name="resetTotal")})
public class BNumericTotalizerExt
extends BPointExtension {
    @Generated
    public static final Property totalFacets = BNumericTotalizerExt.newProperty((int)0, (BValue)BFacets.makeNumeric(), null);
    @Generated
    public static final Property propagateFlags = BNumericTotalizerExt.newProperty((int)0, (BValue)BStatus.make((int)23), null);
    @Generated
    public static final Property invalidValueFlags = BNumericTotalizerExt.newProperty((int)0, (BValue)BStatus.make((int)7), null);
    @Generated
    public static final Property total = BNumericTotalizerExt.newProperty((int)1, (BValue)new BStatusNumeric(0.0), null);
    @Generated
    public static final Property timeOfTotalReset = BNumericTotalizerExt.newProperty((int)1, (BValue)BAbsTime.make(), null);
    @Generated
    public static final Property totalizationInterval = BNumericTotalizerExt.newProperty((int)0, (BValue)BTotalizationInterval.minutely, null);
    @Generated
    public static final Action timerExpired = BNumericTotalizerExt.newAction((int)0, null);
    @Generated
    public static final Action resetTotal = BNumericTotalizerExt.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNumericTotalizerExt.class);
    private Clock.Ticket ticket;
    private long lastExecuteTime;
    private BStatus lastStatus = BStatus.ok;

    @Generated
    public BFacets getTotalFacets() {
        return (BFacets)this.get(totalFacets);
    }

    @Generated
    public void setTotalFacets(BFacets v) {
        this.set(totalFacets, (BValue)v, null);
    }

    @Generated
    public BStatus getPropagateFlags() {
        return (BStatus)this.get(propagateFlags);
    }

    @Generated
    public void setPropagateFlags(BStatus v) {
        this.set(propagateFlags, (BValue)v, null);
    }

    @Generated
    public BStatus getInvalidValueFlags() {
        return (BStatus)this.get(invalidValueFlags);
    }

    @Generated
    public void setInvalidValueFlags(BStatus v) {
        this.set(invalidValueFlags, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getTotal() {
        return (BStatusNumeric)this.get(total);
    }

    @Generated
    public void setTotal(BStatusNumeric v) {
        this.set(total, (BValue)v, null);
    }

    @Generated
    public BAbsTime getTimeOfTotalReset() {
        return (BAbsTime)this.get(timeOfTotalReset);
    }

    @Generated
    public void setTimeOfTotalReset(BAbsTime v) {
        this.set(timeOfTotalReset, (BValue)v, null);
    }

    @Generated
    public BTotalizationInterval getTotalizationInterval() {
        return (BTotalizationInterval)this.get(totalizationInterval);
    }

    @Generated
    public void setTotalizationInterval(BTotalizationInterval v) {
        this.set(totalizationInterval, (BValue)v, null);
    }

    @Generated
    public void timerExpired() {
        this.invoke(timerExpired, null, null);
    }

    @Generated
    public void resetTotal() {
        this.invoke(resetTotal, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)total)) {
            return this.getTotalFacets();
        }
        return super.getSlotFacets(slot);
    }

    @Override
    public boolean requiresPointSubscription() {
        return true;
    }

    @Override
    public boolean isParentLegal(BComponent parent) {
        if (!super.isParentLegal(parent)) {
            return false;
        }
        return parent instanceof BNumericPoint;
    }

    public void started() throws Exception {
        super.started();
        this.lastExecuteTime = Clock.ticks();
        this.ticket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.makeSeconds((int)10), (Action)timerExpired, null);
    }

    public void stopped() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
    }

    public void doTimerExpired() {
        this.onExecute(this.getParentPoint().getOutStatusValue(), null);
    }

    @Override
    public void onExecute(BStatusValue o, Context cx) {
        BStatusNumeric out = (BStatusNumeric)o;
        BStatus status = out.getStatus();
        double value = out.getValue();
        long now = Clock.ticks();
        double interval = this.getTotalizationInterval().equals((Object)BTotalizationInterval.minutely) ? 60000.0 : 3600000.0;
        if ((status.getBits() & this.getInvalidValueFlags().getBits()) == 0 && !Double.isNaN(value) && (this.lastStatus.getBits() & this.getInvalidValueFlags().getBits()) == 0) {
            double thisTotal = value * (double)(now - this.lastExecuteTime) / interval;
            this.getTotal().setValue(this.getTotal().getValue() + thisTotal);
        }
        if (Double.isNaN(value)) {
            this.getTotal().setStatus(BStatus.make((int)(2 | status.getBits() & this.getPropagateFlags().getBits())));
        } else {
            this.getTotal().setStatus(BStatus.make((int)(status.getBits() & this.getPropagateFlags().getBits())));
        }
        this.lastStatus = out.getStatus();
        this.lastExecuteTime = now;
    }

    public void changed(Property property, Context context) {
        if (this.isRunning() && property.equals(totalizationInterval)) {
            this.doResetTotal();
        }
        super.changed(property, context);
    }

    public void doResetTotal() {
        this.getTotal().setValue(0.0);
        this.setTimeOfTotalReset(BAbsTime.now());
    }
}

