/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.control;

import javax.baja.control.BControlPoint;
import javax.baja.control.enums.BPriorityLevel;
import javax.baja.control.util.BOverride;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;

abstract class WritableSupport {
    BControlPoint point;
    Clock.Ticket overrideTimer;

    WritableSupport(BControlPoint point) {
        this.point = point;
    }

    abstract Property in1();

    abstract Property in2();

    abstract Property in3();

    abstract Property in4();

    abstract Property in5();

    abstract Property in6();

    abstract Property in7();

    abstract Property in8();

    abstract Property in9();

    abstract Property in10();

    abstract Property in11();

    abstract Property in12();

    abstract Property in13();

    abstract Property in14();

    abstract Property in15();

    abstract Property in16();

    abstract void setValue(BStatusValue var1, BStatusValue var2);

    abstract BStatusValue getFallback();

    abstract void setOverrideExpiration(BAbsTime var1);

    abstract BAbsTime getOverrideExpiration();

    void started() {
        BAbsTime overrideExpiration = this.getOverrideExpiration();
        if (overrideExpiration.getMillis() == 0L) {
            return;
        }
        BAbsTime now = BAbsTime.now();
        if (overrideExpiration.isAfter(now)) {
            BRelTime duration = now.delta(overrideExpiration);
            if (this.overrideTimer != null) {
                this.overrideTimer.cancel();
            }
            this.overrideTimer = Clock.schedule((BComponent)this.point, (BRelTime)duration, (Action)this.point.getAction("auto"), null);
        } else {
            this.auto();
        }
    }

    BPriorityLevel getActiveLevel() {
        return BPriorityLevel.make(this.point.getStatus().geti("activeLevel", 17));
    }

    boolean isInput(Slot slot) {
        return slot.isFrozen() && slot.getName().startsWith("in");
    }

    BStatusValue getLevel(int level) {
        switch (level) {
            case 1: {
                return (BStatusValue)this.point.get(this.in1());
            }
            case 2: {
                return (BStatusValue)this.point.get(this.in2());
            }
            case 3: {
                return (BStatusValue)this.point.get(this.in3());
            }
            case 4: {
                return (BStatusValue)this.point.get(this.in4());
            }
            case 5: {
                return (BStatusValue)this.point.get(this.in5());
            }
            case 6: {
                return (BStatusValue)this.point.get(this.in6());
            }
            case 7: {
                return (BStatusValue)this.point.get(this.in7());
            }
            case 8: {
                return (BStatusValue)this.point.get(this.in8());
            }
            case 9: {
                return (BStatusValue)this.point.get(this.in9());
            }
            case 10: {
                return (BStatusValue)this.point.get(this.in10());
            }
            case 11: {
                return (BStatusValue)this.point.get(this.in11());
            }
            case 12: {
                return (BStatusValue)this.point.get(this.in12());
            }
            case 13: {
                return (BStatusValue)this.point.get(this.in13());
            }
            case 14: {
                return (BStatusValue)this.point.get(this.in14());
            }
            case 15: {
                return (BStatusValue)this.point.get(this.in15());
            }
            case 16: {
                return (BStatusValue)this.point.get(this.in16());
            }
        }
        throw new IllegalArgumentException();
    }

    void changed(Property prop) {
        BStatusValue sv;
        BStatus s;
        if (this.isInput((Slot)prop) && (s = (sv = (BStatusValue)this.point.get(prop)).getStatus()).get("activeLevel") != null) {
            sv.setStatus(BStatus.make((int)s.getBits(), (BFacets)((BFacets)BFacets.makeRemove((BFacets)s.getFacets(), (String)"activeLevel").intern())));
        }
    }

    void onExecute(BStatusValue out, Context cx) {
        BStatusValue active = null;
        int activeLevel = 17;
        for (int level = 1; level <= 16; ++level) {
            BStatusValue in = this.getLevel(level);
            if (!in.getStatus().isValid()) continue;
            active = in;
            activeLevel = level;
            break;
        }
        if (active == null) {
            BStatusValue fallback = this.getFallback();
            out.copyFrom((BComplex)fallback);
            out.setStatus("activeLevel", (BIDataValue)BDynamicEnum.make((BEnum)BPriorityLevel.fallback));
        } else {
            this.setValue(active, out);
            int status = 0;
            if (activeLevel == 1 || activeLevel == 8) {
                status |= 0x20;
            }
            out.setStatus(status);
            out.setStatus("activeLevel", (BIDataValue)BDynamicEnum.make((BEnum)BPriorityLevel.make(activeLevel)));
        }
    }

    void emergencyOverride(BSimple v) {
        this.notifyProxyExtForActionInvoked();
        BStatusValue x = (BStatusValue)this.point.get(this.in1());
        x.setValueValue((BValue)v);
        x.setStatus(BStatus.ok);
    }

    void emergencyAuto() {
        this.notifyProxyExtForActionInvoked();
        BStatusValue x = (BStatusValue)this.point.get(this.in1());
        x.setStatus(BStatus.nullStatus);
    }

    void override(BOverride override) {
        long desiredDurationMillis;
        this.notifyProxyExtForActionInvoked();
        BStatusValue x = (BStatusValue)this.point.get(this.in8());
        BValue value = override.get("value");
        x.setValueValue(value);
        x.setStatus(BStatus.ok);
        if (this.overrideTimer != null) {
            this.overrideTimer.cancel();
        }
        BRelTime duration = override.getDuration();
        BRelTime maxDuration = this.getMaxOverrideDuration();
        long maxDurationMillis = maxDuration.getMillis();
        if (maxDurationMillis > 0L && ((desiredDurationMillis = duration.getMillis()) <= 0L || desiredDurationMillis > maxDurationMillis)) {
            duration = maxDuration;
        }
        if (duration.getMillis() > 0L) {
            this.setOverrideExpiration(BAbsTime.make((long)(Clock.millis() + duration.getMillis())));
            this.overrideTimer = Clock.schedule((BComponent)this.point, (BRelTime)duration, (Action)this.point.getAction("auto"), null);
        } else {
            this.setOverrideExpiration(BAbsTime.NULL);
        }
    }

    void auto() {
        this.notifyProxyExtForActionInvoked();
        BStatusValue x = (BStatusValue)this.point.get(this.in8());
        x.setStatus(BStatus.nullStatus);
        if (this.overrideTimer != null) {
            this.overrideTimer.cancel();
        }
        this.overrideTimer = null;
        this.setOverrideExpiration(BAbsTime.NULL);
    }

    void set(BSimple v) {
        this.notifyProxyExtForActionInvoked();
        BStatusValue x = this.getFallback();
        x.setValueValue((BValue)v);
        x.setStatus(BStatus.ok);
    }

    void notifyProxyExtForActionInvoked() {
        try {
            this.point.getProxyExt().writablePointActionInvoked();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    BRelTime getMaxOverrideDuration() {
        BRelTime maxDuration = BRelTime.DEFAULT;
        try {
            BFacets facets;
            BObject obj;
            if (!this.point.isRunning()) {
                this.point.loadSlots();
                this.point.lease();
            }
            if ((obj = (facets = this.point.getFacets()).get("maxOverrideDuration")) instanceof BRelTime) {
                maxDuration = (BRelTime)obj;
            } else {
                BStation station = (BStation)BOrd.make((String)"station:|slot:/").get((BObject)this.point);
                if (!station.isRunning()) {
                    station.loadSlots();
                    station.lease();
                }
                facets = (BFacets)station.get("sysInfo");
                maxDuration = (BRelTime)facets.get("maxOverrideDuration", (BObject)maxDuration);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return maxDuration;
    }
}

