/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.control;

import com.tridium.sys.schema.NProperty;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentList;
import javax.baja.control.BPointExtension;
import javax.baja.control.WritableSupport;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.control.ext.BNullProxyExt;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BSpace;
import javax.baja.status.BIStatusValue;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sync.BProxyComponentSpace;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="facets", type="BFacets", defaultValue="BFacets.DEFAULT"), @NiagaraProperty(name="proxyExt", type="BAbstractProxyExt", defaultValue="new BNullProxyExt()")})
@NiagaraAction(name="execute", flags=20)
public abstract class BControlPoint
extends BComponent
implements BIStatusValue {
    @Generated
    public static final Property facets = BControlPoint.newProperty((int)0, (BValue)BFacets.DEFAULT, null);
    @Generated
    public static final Property proxyExt = BControlPoint.newProperty((int)0, (BValue)new BNullProxyExt(), null);
    @Generated
    public static final Action execute = BControlPoint.newAction((int)20, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BControlPoint.class);
    public static final Logger log = Logger.getLogger("control");
    private static final Context setOutContext = new BasicContext();
    static final Context noExecuteContext = new BasicContext();
    private BStatusValue working;
    private long totalExecuteTime;
    private long totalExecuteCount;

    @Generated
    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    @Generated
    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    @Generated
    public BAbstractProxyExt getProxyExt() {
        return (BAbstractProxyExt)this.get(proxyExt);
    }

    @Generated
    public void setProxyExt(BAbstractProxyExt v) {
        this.set(proxyExt, (BValue)v, null);
    }

    @Generated
    public void execute() {
        this.invoke(execute, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final BStatusValue getStatusValue() {
        return this.getOutStatusValue();
    }

    public final BFacets getStatusValueFacets() {
        return this.getFacets();
    }

    public final BStatus getStatus() {
        return this.getOutStatusValue().getStatus();
    }

    public final String getValueWithFacets(Context cx) {
        return this.getStatusValue().getValueValue().toString((Context)new BasicContext(cx, this.getFacets()));
    }

    public abstract BStatusValue getOutStatusValue();

    public final Property getOutProperty() {
        return this.getOutStatusValue().getPropertyInParent();
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot == this.getOutProperty()) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    public boolean isWritablePoint() {
        return false;
    }

    public final void doExecute() {
        long t1 = Clock.nanoTicks();
        if (this.working == null) {
            this.working = (BStatusValue)this.getOutProperty().getDefaultValue();
        } else {
            this.working.copyFrom((BComplex)((BStatusValue)((NProperty)this.getOutProperty()).value));
        }
        this.onExecute(this.working, null);
        this.executeExtensions(this.working, null);
        BStatusValue out = this.getOutStatusValue();
        if (!out.equivalent((Object)this.working)) {
            out.copyFrom((BComplex)this.working, setOutContext);
        }
        long t2 = Clock.nanoTicks();
        this.totalExecuteTime += t2 - t1;
        ++this.totalExecuteCount;
    }

    public abstract void onExecute(BStatusValue var1, Context var2);

    public final BPointExtension[] getExtensions() {
        BPointExtension[] temp = new BPointExtension[this.getSlotCount()];
        int count = 0;
        SlotCursor c = this.getProperties();
        while (c.nextComponent()) {
            BValue kid = c.get();
            if (!(kid instanceof BPointExtension)) continue;
            temp[count++] = (BPointExtension)kid;
        }
        BPointExtension[] result = new BPointExtension[count];
        System.arraycopy(temp, 0, result, 0, count);
        return result;
    }

    public boolean getExtensionsRequireSubscription() {
        SlotCursor c = this.getProperties();
        while (c.nextComponent()) {
            BValue kid = c.get();
            if (!(kid instanceof BPointExtension) || !((BPointExtension)kid).requiresPointSubscription()) continue;
            return true;
        }
        return false;
    }

    public void checkExtensionsRequireSubscription() {
        if (!this.isRunning()) {
            return;
        }
        this.setPermanentlySubscribed(this.getExtensionsRequireSubscription());
    }

    public void executeExtensions(BStatusValue out, Context cx) {
        SlotCursor c = this.getProperties();
        while (c.nextComponent()) {
            BValue child = c.get();
            if (!(child instanceof BPointExtension)) continue;
            BPointExtension ext = (BPointExtension)child;
            try {
                ext.onExecute(out, cx);
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, "Extension failed onExecute(): " + ext.toPathString(), e);
            }
        }
    }

    private void pointFacetsChanged() {
        SlotCursor c = this.getProperties();
        while (c.nextComponent()) {
            BValue child = c.get();
            if (!(child instanceof BPointExtension)) continue;
            BPointExtension ext = (BPointExtension)child;
            ext.pointFacetsChanged();
        }
    }

    protected LinkCheck doCheckLink(BComponent source, Slot sourceSlot, Slot targetSlot, Context cx) {
        SlotCursor c = this.getProperties();
        while (c.nextComponent()) {
            LinkCheck check;
            BValue child = c.get();
            if (!(child instanceof BPointExtension) || (check = ((BPointExtension)child).doCheckParentLink(source, sourceSlot, targetSlot, cx)).isValid()) continue;
            return check;
        }
        return LinkCheck.makeValid();
    }

    public final boolean isChildLegal(BComponent newChild) {
        if (newChild instanceof BPointExtension) {
            BSpace space = this.getSpace();
            if (space == null || !(space instanceof BProxyComponentSpace)) {
                SlotCursor c = this.getProperties();
                while (c.nextComponent()) {
                    BValue child = c.get();
                    if (!(child instanceof BPointExtension) || ((BPointExtension)child).isSiblingLegal(newChild)) continue;
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    public String toString(Context context) {
        return this.propertyValueToString(this.getOutProperty(), context);
    }

    public AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        list.toBottom("webChart:ChartWidget");
        return list;
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 2: {
                this.fwChanged((Property)a, (Context)b);
                break;
            }
            case 3: {
                this.fwAdded((Property)a, (Context)b);
                break;
            }
            case 4: {
                this.fwRemoved((Property)a, (BValue)b, (Context)c);
                break;
            }
            case 7: {
                this.fwParented((Property)a, (BValue)b, (Context)c);
                break;
            }
            case 8: {
                this.fwUnparented((Property)a, (BValue)b, (Context)c);
                break;
            }
            case 11: {
                this.fwStarted();
                break;
            }
            case 13: {
                this.doExecute();
                break;
            }
            case 17: {
                this.fwSubscribed();
                break;
            }
            case 18: {
                this.fwUnsubscribed();
                break;
            }
            case 22: {
                return this.totalExecuteTime;
            }
            case 31: {
                return this.totalExecuteCount;
            }
            case 32: {
                this.totalExecuteCount = 0L;
                this.totalExecuteTime = 0L;
                break;
            }
            case 34: {
                this.fwCheckActionInvocation((Action)a, (BValue)b, (Context)c);
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private void fwStarted() {
        this.getProxyExt().checkStatusValueTypes();
        this.checkExtensionsRequireSubscription();
    }

    private void fwAdded(Property prop, Context context) {
        if (!this.isRunning()) {
            return;
        }
        this.checkExtensionsRequireSubscription();
        this.execute();
    }

    private void fwRemoved(Property prop, BValue value, Context context) {
        if (!this.isRunning()) {
            return;
        }
        this.checkExtensionsRequireSubscription();
        this.execute();
    }

    private void fwParented(Property prop, BValue newChild, Context context) {
        if (!this.isRunning()) {
            return;
        }
        this.getProxyExt().checkStatusValueTypes();
    }

    private void fwUnparented(Property prop, BValue oldChild, Context context) {
        if (!this.isRunning()) {
            return;
        }
        this.getProxyExt().checkStatusValueTypes();
    }

    private void fwChanged(Property prop, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (prop == this.getOutProperty()) {
            if (context != setOutContext) {
                log.log(Level.WARNING, "ControlPoint.out set explicitly: " + this.getType() + ": " + this.toPathString(), new Exception());
            }
        } else {
            if (prop.equals(facets)) {
                this.pointFacetsChanged();
            }
            if (context != noExecuteContext) {
                this.execute();
            }
        }
        if (this.writableSupport() != null) {
            this.writableSupport().changed(prop);
        }
    }

    private void fwSubscribed() {
        if (!this.isRunning()) {
            return;
        }
        this.getProxyExt().pointSubscribed();
    }

    private void fwUnsubscribed() {
        if (!this.isRunning()) {
            return;
        }
        this.getProxyExt().pointUnsubscribed();
    }

    void fwCheckActionInvocation(Action action, BValue arg, Context context) {
    }

    WritableSupport writableSupport() {
        return null;
    }
}

