/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.hx.px;

import com.tridium.agent.BILoadablePxView;
import com.tridium.hx.px.BHxHtmlPxView;
import com.tridium.hx.px.HxPxCache;
import com.tridium.hx.stub.StubHxOp;
import com.tridium.hx.util.BenchmarkCommand;
import com.tridium.hx.warmup.BHxPxWarmup;
import com.tridium.nre.diagnostics.DiagnosticUtil;
import com.tridium.web.WebProcessException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.agent.BAbstractPxView;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.RectGeom;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.util.LexiconModule;
import javax.baja.web.CsrfUtil;
import javax.baja.web.WebOp;
import javax.baja.workbench.CannotSaveException;
import javax.servlet.http.HttpServletRequest;

@NiagaraType(agent={@AgentOn(types={"baja:AbstractPxView", "file:PxFile"}, requiredPermissions="r")})
@NiagaraSingleton
public class BHxPxView
extends BHxView {
    @Generated
    public static final BHxPxView INSTANCE = new BHxPxView();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxPxView.class);
    private static AgentFilter filter = AgentFilter.is((String)"hx:HxPxView");
    public static final Logger log = Logger.getLogger("hx.px");
    public static final Logger DIAGNOSTICS_log = Logger.getLogger("diagnostics.hx.px");
    private static final String HX_PX_LOADING = "x-niagara-hx-px-loading";
    private BAbstractPxView pxView;
    private static LexiconModule LEX = LexiconModule.make((String)"bajaui");

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BHxPxView() {
    }

    public BHxPxView(BAbstractPxView pxView) {
        this.pxView = pxView;
    }

    protected void doWrite(BWidget root, HxOp op) throws Exception {
    }

    protected void doUpdate(BWidget root, HxOp op) throws Exception {
    }

    protected boolean doProcess(BWidget root, HxOp op) throws Exception {
        return false;
    }

    protected BObject doSave(BWidget root, HxOp op) throws Exception {
        return null;
    }

    @Override
    public void doPost(WebOp c) throws Exception {
        if (c.getRequest().getHeader(HX_PX_LOADING) != null) {
            BILoadablePxView loadablePxView;
            try {
                CsrfUtil.verifyCsrfToken((HttpServletRequest)c.getRequest());
            }
            catch (Exception e) {
                c.getResponse().sendError(403, e.getMessage());
            }
            boolean responseSent = false;
            if (this.pxView instanceof BILoadablePxView && ((loadablePxView = (BILoadablePxView)this.pxView).isPxViewLoading() || loadablePxView.isPxViewModified(BAbsTime.END_OF_TIME))) {
                responseSent = true;
                c.getResponse().setStatus(204);
            }
            if (!responseSent) {
                c.getResponse().setStatus(200);
            }
        } else {
            super.doPost(c);
        }
    }

    @Override
    public final void write(HxOp op) throws Exception {
        BComponentSpace space;
        long millis;
        long l = millis = DIAGNOSTICS_log.isLoggable(Level.FINE) ? DiagnosticUtil.nanoTime() : 0L;
        if (!(op instanceof StubHxOp)) {
            BHxPxWarmup.webActivity();
        }
        if (this.pxView instanceof BILoadablePxView) {
            BILoadablePxView loadablePx = (BILoadablePxView)this.pxView;
            if (!loadablePx.isPxViewLoading() && loadablePx.isPxViewModified(BAbsTime.END_OF_TIME)) {
                loadablePx.reloadPxView();
            }
            if (loadablePx.isPxViewLoading()) {
                op.addJavaScript(BOrd.make((String)"module://hx/com/tridium/hx/px/hxPx.js"));
                op.addOnload("px.showLoadingUntilPostOk(\"x-niagara-hx-px-loading\", \"true\", 2000);");
                return;
            }
        }
        op.setDynamic();
        try {
            space = HxPxCache.get((OrdTarget)op, this.pxView, true, op);
        }
        catch (UnresolvedException ue) {
            throw new WebProcessException(404, ue.getMessage());
        }
        BWidget root = (BWidget)space.getRootComponent();
        Object out = op.getHtmlWriter();
        out.w((Object)"<input type='hidden' name='").w((Object)op.scope("y")).w((Object)"'/>");
        out.w((Object)"<input type='hidden' name='").w((Object)op.scope("x")).w((Object)"'/>");
        out.w((Object)"<input type='hidden' name='").w((Object)op.scope("button")).w((Object)"'/>");
        out.w((Object)"<input type='hidden' name='").w((Object)op.scope("shiftModifier")).w((Object)"'/>");
        out.w((Object)"<input type='hidden' name='").w((Object)op.scope("ctlModifier")).w((Object)"'/>");
        out.w((Object)"<input type='hidden' name='").w((Object)op.scope("altModifier")).w((Object)"'/>");
        out.w((Object)"<input type='hidden' name='").w((Object)op.scope("metaModifier")).w((Object)"'/>");
        out = new StringBuilder();
        ((StringBuilder)out).append("window.hxPxInit = function() {");
        ((StringBuilder)out).append("var hxPx = document.getElementById(\"").append(op.scope("hxPx")).append("\");");
        ((StringBuilder)out).append("if(hxPx!=null) {");
        ((StringBuilder)out).append("hx.addFormElementToPoll(\"").append(op.scope("content.top")).append("\");");
        ((StringBuilder)out).append("hx.addFormElementToPoll(\"").append(op.scope("content.left")).append("\");");
        ((StringBuilder)out).append("hx.addFormElementToPoll(\"").append(op.scope("content.width")).append("\");");
        ((StringBuilder)out).append("hx.addFormElementToPoll(\"").append(op.scope("content.height")).append("\");");
        ((StringBuilder)out).append("hxPxSizing();");
        if (op.getRequest().getSession().getAttribute("contentGeom") == null || !BHxHtmlPxView.USE_SESSION_GEOM) {
            ((StringBuilder)out).append("hx.ensureFirstPoll(").append(BenchmarkCommand.isActive()).append(");");
        }
        ((StringBuilder)out).append("}");
        ((StringBuilder)out).append("};");
        ((StringBuilder)out).append("window.hxPxSizing = function() {");
        ((StringBuilder)out).append("var hxPx = document.getElementById(\"").append(op.scope("hxPx")).append("\");");
        ((StringBuilder)out).append("if(hxPx){");
        ((StringBuilder)out).append("hx.setFormValue(\"").append(op.scope("content.top")).append("\", ").append("hx.getElementBounds(hxPx)[1]);");
        ((StringBuilder)out).append("hx.setFormValue(\"").append(op.scope("content.left")).append("\", ").append("hx.getElementBounds(hxPx)[0]);");
        ((StringBuilder)out).append("if(hxPx.parentNode.childNodes.length==2){");
        ((StringBuilder)out).append("hx.setFormValue(\"").append(op.scope("content.width")).append("\", ").append("hxPx.parentNode.offsetWidth);");
        ((StringBuilder)out).append("hx.setFormValue(\"").append(op.scope("content.height")).append("\", ").append("hxPx.parentNode.offsetHeight);");
        ((StringBuilder)out).append("}");
        ((StringBuilder)out).append("setTimeout(hxPxSizing, 2500);");
        ((StringBuilder)out).append("}};");
        op.addGlobal(((StringBuilder)out).toString());
        this.getImpl(op).doWrite(root, op);
        op.addOnload("hxPxInit();");
        if (DIAGNOSTICS_log.isLoggable(Level.FINE)) {
            DiagnosticUtil.complete((long)millis, (String)"BHxPxView.write");
        }
    }

    @Override
    public final void update(HxOp op) throws Exception {
        long millis = DIAGNOSTICS_log.isLoggable(Level.FINE) ? DiagnosticUtil.nanoTime() : 0L;
        BComponentSpace space = HxPxCache.get((OrdTarget)op, this.pxView, true, op);
        BWidget root = (BWidget)space.getRootComponent();
        this.getImpl(op).doUpdate(root, op);
        if (DIAGNOSTICS_log.isLoggable(Level.FINE)) {
            DiagnosticUtil.complete((long)millis, (String)"BHxPxView.update");
        }
    }

    @Override
    public final boolean process(HxOp op) throws Exception {
        if (super.process(op)) {
            return true;
        }
        BComponentSpace space = HxPxCache.get((OrdTarget)op, this.pxView, false, op);
        BWidget root = (BWidget)space.getRootComponent();
        return this.getImpl(op).doProcess(root, op);
    }

    @Override
    public final BObject save(HxOp op) throws Exception {
        BComponentSpace space = HxPxCache.get((OrdTarget)op, this.pxView, false, op);
        BWidget root = (BWidget)space.getRootComponent();
        try {
            return this.getImpl(op).doSave(root, op);
        }
        catch (Exception e) {
            String msg = LEX.getText("plugin.save.error", (Context)op);
            throw new CannotSaveException(msg, (Throwable)e);
        }
    }

    private BHxPxView getImpl(HxOp op) {
        AgentList agents = op.getProfile().getAgents((Context)op).filter(filter);
        return (BHxPxView)agents.getDefault().getInstance();
    }

    public IRectGeom getContentGeom(HxOp op) {
        IRectGeom rect = BHxHtmlPxView.USE_SESSION_GEOM ? (IRectGeom)op.getRequest().getSession().getAttribute("contentGeom") : (IRectGeom)op.getRequest().getAttribute("contentGeom");
        if (op.getRequest().getHeader("Screen-Width") != null) {
            int width = (int)Double.parseDouble(op.getRequest().getHeader("Screen-Width"));
            int height = (int)Double.parseDouble(op.getRequest().getHeader("Screen-Height"));
            String left_text = op.getFormValue("content.left");
            String top_text = op.getFormValue("content.top");
            String width_text = op.getFormValue("content.width");
            String height_text = op.getFormValue("content.height");
            if (left_text != null && top_text != null) {
                int left = (int)Double.parseDouble(left_text);
                int top = (int)Double.parseDouble(top_text);
                rect = new RectGeom((double)left, (double)top, (double)(width - left), (double)(height - top));
                if (width_text != null && height_text != null) {
                    width = (int)Double.parseDouble(width_text);
                    height = (int)Double.parseDouble(height_text);
                    if (width > 0 && height > 0) {
                        rect = new RectGeom((double)left, (double)top, (double)width, (double)height);
                    }
                }
            }
        }
        if (BHxHtmlPxView.USE_SESSION_GEOM) {
            op.getRequest().getSession().setAttribute("contentGeom", (Object)rect);
        } else {
            op.getRequest().setAttribute("contentGeom", (Object)rect);
        }
        return rect;
    }
}

