/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hx.stub;

import com.tridium.hx.BDefaultHxProfile;
import com.tridium.util.warmup.BWarmupConfig;
import com.tridium.web.stub.StubWebOp;
import java.util.logging.Logger;
import javax.baja.hx.HxOp;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.BFacets;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.web.UserAgent;
import javax.baja.web.WebOp;

public class StubHxOp
extends HxOp {
    private static UserAgent FF = new UserAgent("Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.9.2.2) Gecko/20100316 Firefox/3.6.2 (.NET CLR 3.5.30729)");
    private static final Logger logger = Logger.getLogger("com.tridium.hx.warmup");
    private BUser user;

    public StubHxOp(OrdTarget target, BUser user) throws Exception {
        this(target);
        this.user = user;
    }

    public StubHxOp(OrdTarget target) throws Exception {
        this((WebOp)new StubWebOp(target));
        this.setProfile(BDefaultHxProfile.INSTANCE);
    }

    public StubHxOp(WebOp op) throws Exception {
        super(op);
        if (this.user == null) {
            this.user = StubHxOp.getFallbackUser();
        }
        if (this.user != null) {
            this.mergeFacets(BFacets.make((String)"username", (String)this.user.getUsername()));
        }
    }

    protected StubHxOp(String name, OrdTarget base, HxOp op) {
        super(name, base, op);
        BWarmupConfig.checkInterrupted();
    }

    public UserAgent getUserAgent() {
        return FF;
    }

    public BUser getUser() {
        return this.user;
    }

    private static BUser getFallbackUser() {
        try {
            BUserService userService = Sys.findService((Type)BUserService.TYPE).orElse(new BUserService());
            return userService.getAdmin();
        }
        catch (Exception e) {
            logger.warning("Unable to retrieve admin user from the user service");
            return null;
        }
    }

    @Override
    public void sendError(int sc, Exception ex) {
        super.sendError(sc, ex);
        throw new BWarmupConfig.WarmupInterruptError((Throwable)ex);
    }

    @Override
    public HxOp make(String name, OrdTarget base) {
        StubHxOp newOp = new StubHxOp(name, base, this);
        newOp.mounted = this.mounted;
        newOp.user = this.user;
        return newOp;
    }
}

